/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PeekSocket.java,v 1.6 2005/02/16 22:20:20 qiyanli Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.http.remote;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.io.BufferedInputStream;

/*
 * Created on Oct 14, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */

/**
 * @author ptasnik@us.ibm.com
 *
 * Only designed currently to peek on read side of sockets
 * created from PeekServerSocket, could be changed to make
 * peek available from read side of client. 
 */
public class PeekSocket extends Socket {	
	
	public PeekSocket() {
		super();
	}

	protected BufferedInputStream m_BufferedIn = null;
	protected synchronized void setupBufferedInputStream () throws IOException {
		//
		// Better be connected or we are screwed
		//
		if (m_BufferedIn == null) {
			m_BufferedIn = new BufferedInputStream (super.getInputStream());	
		}
	}
	
	public InputStream getInputStream() throws IOException {
		setupBufferedInputStream ();
		return (m_BufferedIn);
	}

	//
	// peek - method will block 
	//
	public int peek () throws IOException {
		int peekbyte = 0;
		BufferedInputStream in = (BufferedInputStream)getInputStream(); 
		
		in.mark (1);
		peekbyte = in.read();	 		
		in.reset ();

		return peekbyte;	
	}
}
