/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: SSLProxyRecorder.java,v 1.22 2005/04/29 13:50:51 mddunn Exp $

Contributors:
 IBM Corporation - initial implementation
**********************************************************************/
/*
 * NONE OF THE QUOTED STRINGS IN THIS FILE ARE TO BE LOCALIZED
 * THEY ARE ALL FOR XML TAGS, DEBUGGING SUPPORT, THEY ARE NOT FOR USER INTERFACES
 */
 
/*
 * Created on Jun 21, 2003
 *
 * To change this generated comment go to 
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.eclipse.hyades.execution.recorder.http.remote;

/**
 * @author morris
 *
 * To change this generated comment go to 
 * Window>Preferences>Java>Code Generation>Code and Comments
 */

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketException;


import org.eclipse.hyades.internal.execution.recorder.remote.RecorderAgent;
import org.eclipse.hyades.internal.execution.recorder.remote.RecorderAgentController;



/**
 * @author morris
 *
 * To change this generated comment go to 
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class SSLProxyRecorder extends RecorderAgent
{
	static int iProxyRecorderPort = 0;
	static Proxy proxy = null;
	// mdd Hyades 1.3 HTTP Proxy 
	static String strProxyType = "";
	static String strProxyAddr = "";
	static int iProxyPort = 0;
	// defect 79219 mdd
	static String strSSLProxyAddr = "";
	static int sslIProxyPort = 0;
	public static final String ERROR_CREATING_CLIENTSIDEREADER = "-3";
	
	// mdd for proxyOverrideString and proxyAutoConfigURLString 
	static String strProxyOverride = "";
	static String strProxyAutoConfigURL = "";
	
	//jn
	static String strKeyFile = "C:\\testkeys";
	private static boolean bFinished = false;
	
	static final String ErrorStartingRecorder = HttpRecResourceBundle.getInstance().getString("RECORDER_ERR_STARTING");
	static final String StartingRecorder = HttpRecResourceBundle.getInstance().getString("RECORDER_STARTING_SSLPROXYRECORDER");
	static final String ListeningToPort = HttpRecResourceBundle.getInstance().getString("RECORDER_LISTENING_TO_PORT");
	static final String SocketBindError = HttpRecResourceBundle.getInstance().getString("RECORDER_BIND_ERROR");
	static final String CSRCreateError = HttpRecResourceBundle.getInstance().getString("RECORDER_CREATING_CLIENTSIDEREADER");
	static final String TooManyBindErrors = HttpRecResourceBundle.getInstance().getString("RECORDER_TOO_MANY_BIND_ERROR");
	
	
	public static void main(String[] args)
	{		
		new SSLProxyRecorder().run();
		
	}

	public Thread run()
	{

		try
		{
			sendDebugMessageToDataProcessor(StartingRecorder);
			proxy = new Proxy(this, controller);
			proxy.start();
			sendDebugMessageToDataProcessor(ListeningToPort + iProxyRecorderPort);
					
		}
		
		catch (Exception e){
			controller.reportException(ErrorStartingRecorder + e.getMessage(), e);
			System.err.println(e);
			System.exit(1);
		}
		
		setIsReady(true);
		return proxy;
	}
	
	
	static PacketWriter packetWriter = null;
		
	private String configuration;
	public static class Proxy extends Thread 
	{
		String host;
		RecorderAgent agent = null;
		RecorderAgentController controller = null;
		PeekServerSocket serversocket = null;
		Thread packetQueueThread = null;
		
		public Proxy(RecorderAgent agent, RecorderAgentController controller)
		{
			this.setName("Proxy");
			this.agent = agent;
			this.controller = controller;
			packetWriter = new PacketWriter(agent);
			
			packetWriter.writeRecorderStartInfo(iProxyRecorderPort,
						strProxyAddr, iProxyPort, strSSLProxyAddr, sslIProxyPort);	
			
			packetWriter.writeRecorderBrowserConfigInfo(iProxyRecorderPort,
					strProxyAddr, iProxyPort, strSSLProxyAddr, sslIProxyPort,strProxyOverride, strProxyAutoConfigURL);
		}
		
		public void run()  {
			//ServerSocket serversocket = null;
			
			int numTries = 0;
						
			try{
			
				//serversocket = new ServerSocket(iProxyRecorderPort);
				
				try {
					// to test throw new Exception ("bind IN USE");
			
					serversocket = new PeekServerSocket(iProxyRecorderPort);
					serversocket.setSoTimeout(600000);
				} catch (IOException listen_exception) {
					//TODO tell user about error in eclipse
					this.agent.sendDebugMessageToDataProcessor(CSRCreateError + " Port: " + iProxyRecorderPort);
					packetWriter.writeRecorderMessage(2, CSRCreateError + " Exception: " +getStackTraceInfo (listen_exception));
					//sendStatusMessageToControlView(CSRCreateError);
					agent.reportException(CSRCreateError,listen_exception);
					throw listen_exception;		
				}				 

				while (!bFinished){
					ClientSideReader cli_reader;
					
					try{
						//Socket client = serversocket.accept();
						
						PeekSocket client = serversocket.acceptPeekSocket();
						if (strProxyType.equalsIgnoreCase("http")) {
							if (strSSLProxyAddr.length() > 0 && sslIProxyPort > 0){
								cli_reader = new ClientSideReaderHTTP(client, packetWriter, strKeyFile, 
										strProxyAddr, iProxyPort, strSSLProxyAddr ,sslIProxyPort, null, null);
							} else {
								cli_reader = new ClientSideReaderHTTP(client, packetWriter, strKeyFile, 
										strProxyAddr, iProxyPort);
							}
						}
						else {
							cli_reader = new ClientSideReaderSOCKS(client, packetWriter, strKeyFile);
						}
						cli_reader.start();
					} catch (Exception e) {			
						if (numTries >= 10){
							throw new Exception (TooManyBindErrors);
						}
						numTries += 1;
						//PRINT THESE TO ECLIPSE TOO 
						this.agent.sendDebugMessageToDataProcessor(SocketBindError + iProxyRecorderPort + " Exception: " + getStackTraceInfo(e));
						packetWriter.writeRecorderMessage(2, SocketBindError + iProxyRecorderPort + " Exception: " + getStackTraceInfo (e));
						//controller.stopRecording();
						
					}
				}
				
			} catch (Exception e) {		
	
				//controller.sendCompleteNotification();
				packetWriter.writeRecorderMessage(2, "exception in socket run: " + getStackTraceInfo (e));
				packetWriter.getAgentController().sendControlMessageToDataProcessor(ERROR_CREATING_CLIENTSIDEREADER);
				controller.stopRecording();

			}
			
			System.out.println("Exiting Proxy normally");
		}
					
	}

	public static String getStackTraceInfo (Throwable exception) {
		Writer strResult = new StringWriter ();
		PrintWriter printWriter = new PrintWriter (strResult);
		exception.printStackTrace (printWriter);
	    return strResult.toString();
	 }

	
	public boolean init(String configuration )
	{
		this.configuration = configuration;
		int iStartPos, iEndPos;
		
		final String sslFile = "sslkeyfile";
		bFinished = false;
		setPortInfo(configuration);
		setProxyInfo(configuration);
		setSSLInfo(configuration);
		setBrowserConfigInfo(configuration);
		return true;
	}
/*
 *  (non-Javadoc)
 * @see org.eclipse.hyades.internal.execution.recorder.remote.RecorderAgent#handleCommand(int, java.lang.String)
		String proxyInfo = getProxyInfo(inputFileContents);
		if (proxyInfo.length()!= 0) {
			String[] proxySplit = proxyInfo.split(":");
			String myProxyAddr = proxySplit[0];
			String myProxyPort = proxySplit[1];
			setProxyAddr(myProxyAddr);	
			setProxyPort(myProxyPort);
			setProxyType("http");
		}
		else {
			setProxyType("socks");
		}
 * */	

	
	/**
	 * @param configuration
	 */
	private void setPortInfo(String configuration) {
		int iStartPos;
		int iEndPos;
		int iPortPos = configuration.indexOf("port,");
		if (iPortPos >= 0){
			iStartPos = iPortPos + 5;
			iEndPos = configuration.indexOf(";", iStartPos);
				if (iEndPos >= 0){
					iProxyRecorderPort = Integer.parseInt(configuration.substring(iStartPos, iEndPos ));
			}
			else{
				iProxyRecorderPort = Integer.parseInt(configuration.substring(iStartPos));
			}
		}
	}

	private void setSSLInfo(String configuration) {
		int iStartPos;
		int iEndPos;
		iStartPos = configuration.indexOf("sslkeyfile,");
		if (iStartPos >= 0){
			iStartPos = iStartPos + 11;
			iEndPos = configuration.indexOf(";", iStartPos);
				if (iEndPos >= 0){
					strKeyFile = configuration.substring(iStartPos, iEndPos );
			}
			else{
				strKeyFile = configuration.substring(iStartPos);
			}
		}
	}
	/**
	 * @param configuration
	 */
	private void setProxyInfo(String configuration) {
		int iStartPos = 0;
		int iEndPos = 0;
		final String proxyStr = "proxyInfo,";
		final String httpStr = "http=";
		final String socksStr = "socks";
		// defect 79219 mdd
		final String SSLproxyStr = "sslProxyInfo,";
		final String httpsStr = "https=";
		final String proxyOverrideStr = "proxyOverrideStr,";
		
		int iProxyInfoPos = configuration.indexOf(proxyStr);
		if (iProxyInfoPos >= 0) {
			iStartPos = iProxyInfoPos + proxyStr.length();
			iEndPos = configuration.indexOf(';', iStartPos);
			String pInfo;
			if (iEndPos >= 0)
				pInfo = configuration.substring(iStartPos, iEndPos);
			else
				pInfo = configuration.substring(iStartPos);
			
			if (pInfo.startsWith(httpStr)) {
				strProxyType = "http";
				String pAddr = pInfo.substring(httpStr.length());
				if (pAddr.length() != 0) {
					String[] proxySplit = pAddr.split(":");
					strProxyAddr = proxySplit[0];
					String tmpPort = proxySplit[1];
					iProxyPort = Integer.parseInt(tmpPort);
				} else {
					strProxyType = "socks";
				}
				// defect 79219 mdd
				int isSame = -1;
				isSame = strProxyType.compareToIgnoreCase("http");
				if (isSame == 0) {
					setSSLProxyInfo(configuration);
				}
			}
			else {
				strProxyType = "socks";
			}
		}
	}

	private void setBrowserConfigInfo(String configuration) {
		int iStartPos = 0;
		int iEndPos = 0;

		// defect 79219 mdd
		final String proxyOverrideStr = "proxyOverride,";
		final String autoConfigURLStr = "autoConfigURL,";
		
		int iAutoConfigURLPos = configuration.indexOf(autoConfigURLStr);
		int iProxyOverridePos = configuration.indexOf(proxyOverrideStr);
		String tmpOverrideStr = "";
		String tmpAutoConfigURLStr = "";
		boolean foundProxyOverride = false;
		boolean foundAutoConfigURL = false;
		int tmpFirstInfo = 0;
	
		if (iProxyOverridePos >= 0) {
				foundProxyOverride = true;
				tmpFirstInfo = iProxyOverridePos;
		}
		if (iAutoConfigURLPos >= 0) {
			foundAutoConfigURL = true;
			if (iAutoConfigURLPos < tmpFirstInfo) {
				tmpFirstInfo = iAutoConfigURLPos;
			}
		}
		
		// This assumes ProxyOverride will be written before 
		if (foundProxyOverride) {
			iStartPos = iProxyOverridePos + proxyOverrideStr.length();
			// may have multiple ';'
			if (iAutoConfigURLPos > -1) {
				tmpOverrideStr = configuration.substring(iStartPos,iAutoConfigURLPos);
			} else {
				tmpOverrideStr = configuration.substring(iStartPos,configuration.length());
			}
			strProxyOverride = tmpOverrideStr;
		}
		
		if (foundAutoConfigURL) {
			iStartPos = iAutoConfigURLPos + autoConfigURLStr.length();
			tmpAutoConfigURLStr = configuration.substring(iStartPos,configuration.length());
			
			strProxyAutoConfigURL = tmpAutoConfigURLStr ;
		}
		
	}
	public boolean handleCommand(int commandID, String commandData)
	{
		switch(commandID)
		{
			case STOP_RECORDING:
				bFinished = true;
				
				if (packetWriter != null) {
					GlobalSocketList.killAllOpenSockets(packetWriter);
					GlobalSocketList.writeCloseMessages(packetWriter);
					packetWriter.writeRecorderStopInfo();
					packetWriter.flushRemainingPackets();
				}
				// bugzilla_69967
				try {
					proxy.serversocket.close();
				}
				catch (SocketException se) {
					//this will occur if serversocket is in the middle of an accept(),
					//chance of incomplete data -- but probably it's just waiting for another page
					//System.out.println(se);
				}catch (IOException ioe) {}
				return true;
				
			default:
				return false;
		}
	}
	private void setSSLProxyInfo(String configuration) {
		int iStartPos = 0;
		int iEndPos = 0;

		// defect 79219 mdd
		final String SSLproxyStr = "sslProxyInfo,";
		final String httpsStr = "https=";
		
		int iSSLProxyInfoPos = configuration.indexOf(SSLproxyStr);
		if (iSSLProxyInfoPos >= 0) {
			iStartPos = iSSLProxyInfoPos + SSLproxyStr.length();
			// note - may not have ';' at end, may just be end of string
			iEndPos = configuration.indexOf(';', iStartPos);
			if (iEndPos == -1){
				iEndPos = configuration.length();
			}
			String pInfo;
			if (iEndPos >= 0)
				pInfo = configuration.substring(iStartPos, iEndPos);
			else
				pInfo = configuration.substring(iStartPos);
			
			if (pInfo.startsWith(httpsStr)) {
				
				String pAddr = pInfo.substring(httpsStr.length());
				if (pAddr.length() != 0) {
					String[] proxySplit = pAddr.split(":");
					strSSLProxyAddr = proxySplit[0];
					String tmpPort = proxySplit[1];
					sslIProxyPort = Integer.parseInt(tmpPort);
				} 
			}
		}
	}


}
