/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TimeStampDispatcher.java,v 1.4 2005/02/16 22:20:20 qiyanli Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.recorder.http.remote;

/**
 * @author morris
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public final class TimeStampDispatcher {
	static long refTimeStamp = System.currentTimeMillis();
	
	synchronized static long getTimeStamp(){
		long currTime = System.currentTimeMillis();
		// the returned value will be the time in milliseconds since the recorder started
		return (currTime - refTimeStamp);
	}
	// method for convenience in case it is needed.
	synchronized static void resetRefTimeStamp(){
		refTimeStamp = System.currentTimeMillis();
	}

}
