/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Testgen.java,v 1.4 2005/02/16 22:20:27 qiyanli Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.testgen.http;

import java.io.PrintStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.internal.execution.testgen.TestGenerator;
import org.eclipse.hyades.internal.execution.testgen.TestgenException;
import org.eclipse.hyades.internal.execution.testgen.util.TestGenFileUtil;


/**
 * @author dhinson
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class Testgen extends TestGenerator 
{

	PrintStream debugStream;

	public class ProgressUpdater
	{
		public int ticks;
		
		public void progress ()
		{
			setProgress(ticks = (++ticks % 100));
		}
		
		public void message (String message)
		{
			setMessage(message);
		}
		
		public void progress (String message)
		{
			progress();
			if (message != null)
				message(message);
		}
		
		public void finishedOk ()
		{
			setProgress(100);
			closeProgressDialog();
		}
		
		public void finishedError ()
		{
			closeProgressDialog();
		}
	}
	
	public boolean runTestGen ()
		throws TestgenException
	{
		debugStream = System.out;

		// get IFile from recModelFile parser
		IFile file = TestGenFileUtil.getTraceFile(recModelFile);	

		ProgressUpdater updater = new ProgressUpdater();
		TRCFileLoader loader = new TRCFileLoader(updater, debugStream);
		try {
			loader.load(file, outputFileName);
		}
		catch (TestgenException e) {
			e.dumpMessages(System.err);
			e.printStackTrace();
			updater.finishedError();
			return false;
		}
		updater.finishedOk();
						
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loadtest.testgen.TestGenerator#showProgress()
	 */
	public boolean showProgress()
	{
		return true;
	}

}
