/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: ContextPackageImpl.java,v 1.11 2005/03/24 21:12:28 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.context.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.impl.XMLTypePackageImpl;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.impl.AdapterPackageImpl;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ConfigurationPackageImpl;
import org.eclipse.hyades.logging.adapter.model.internal.context.Component;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextFactory;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextPackage;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextRoleNames;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextType;
import org.eclipse.hyades.logging.adapter.model.internal.context.ContextsType;
import org.eclipse.hyades.logging.adapter.model.internal.context.DocumentRoot;
import org.eclipse.hyades.logging.adapter.model.internal.context.RoleNames;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.impl.ExtractorPackageImpl;
import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage;

import org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.impl.FormatterPackageImpl;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.impl.OutputterPackageImpl;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage;
import org.eclipse.hyades.logging.adapter.model.internal.parser.impl.ParserPackageImpl;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.impl.SensorPackageImpl;
import org.eclipse.hyades.logging.adapter.model.internal.unit.UnitPackage;
import org.eclipse.hyades.logging.adapter.model.internal.unit.impl.UnitPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ContextPackageImpl extends EPackageImpl implements ContextPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass componentEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass contextsTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass contextTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass documentRootEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum contextRoleNamesEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum roleNamesEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType contextRoleNamesObjectEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType roleNamesObjectEDataType = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.hyades.logging.adapter.model.internal.context.ContextPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ContextPackageImpl() {
		super(eNS_URI, ContextFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ContextPackage init() {
		if (isInited) return (ContextPackage)EPackage.Registry.INSTANCE.getEPackage(ContextPackage.eNS_URI);

		// Obtain or create and register package
		ContextPackageImpl theContextPackage = (ContextPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(eNS_URI) instanceof ContextPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(eNS_URI) : new ContextPackageImpl());

		isInited = true;

		// Initialize simple dependencies
		XMLTypePackageImpl.init();

		// Obtain or create and register interdependencies
		FilterPackageImpl theFilterPackage = (FilterPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(FilterPackage.eNS_URI) instanceof FilterPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(FilterPackage.eNS_URI) : FilterPackageImpl.eINSTANCE);
		ParserPackageImpl theParserPackage = (ParserPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ParserPackage.eNS_URI) instanceof ParserPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ParserPackage.eNS_URI) : ParserPackageImpl.eINSTANCE);
		AdapterPackageImpl theAdapterPackage = (AdapterPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(AdapterPackage.eNS_URI) instanceof AdapterPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(AdapterPackage.eNS_URI) : AdapterPackageImpl.eINSTANCE);
		ConfigurationPackageImpl theConfigurationPackage = (ConfigurationPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ConfigurationPackage.eNS_URI) instanceof ConfigurationPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ConfigurationPackage.eNS_URI) : ConfigurationPackageImpl.eINSTANCE);
		UnitPackageImpl theUnitPackage = (UnitPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(UnitPackage.eNS_URI) instanceof UnitPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(UnitPackage.eNS_URI) : UnitPackageImpl.eINSTANCE);
		ExtractorPackageImpl theExtractorPackage = (ExtractorPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ExtractorPackage.eNS_URI) instanceof ExtractorPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ExtractorPackage.eNS_URI) : ExtractorPackageImpl.eINSTANCE);
		FormatterPackageImpl theFormatterPackage = (FormatterPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(FormatterPackage.eNS_URI) instanceof FormatterPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(FormatterPackage.eNS_URI) : FormatterPackageImpl.eINSTANCE);
		OutputterPackageImpl theOutputterPackage = (OutputterPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(OutputterPackage.eNS_URI) instanceof OutputterPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(OutputterPackage.eNS_URI) : OutputterPackageImpl.eINSTANCE);
		SensorPackageImpl theSensorPackage = (SensorPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(SensorPackage.eNS_URI) instanceof SensorPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(SensorPackage.eNS_URI) : SensorPackageImpl.eINSTANCE);

		// Create package meta-data objects
		theContextPackage.createPackageContents();
		theFilterPackage.createPackageContents();
		theParserPackage.createPackageContents();
		theAdapterPackage.createPackageContents();
		theConfigurationPackage.createPackageContents();
		theUnitPackage.createPackageContents();
		theExtractorPackage.createPackageContents();
		theFormatterPackage.createPackageContents();
		theOutputterPackage.createPackageContents();
		theSensorPackage.createPackageContents();

		// Initialize created meta-data
		theContextPackage.initializePackageContents();
		theFilterPackage.initializePackageContents();
		theParserPackage.initializePackageContents();
		theAdapterPackage.initializePackageContents();
		theConfigurationPackage.initializePackageContents();
		theUnitPackage.initializePackageContents();
		theExtractorPackage.initializePackageContents();
		theFormatterPackage.initializePackageContents();
		theOutputterPackage.initializePackageContents();
		theSensorPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theContextPackage.freeze();

		return theContextPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getComponent() {
		return componentEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_Group() {
		return (EAttribute)componentEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getComponent_Component() {
		return (EReference)componentEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_Description() {
		return (EAttribute)componentEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_ExecutableClass() {
		return (EAttribute)componentEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_ImplementationCreationDate() {
		return (EAttribute)componentEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_ImplementationVersion() {
		return (EAttribute)componentEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_ImplementationVersionDescription() {
		return (EAttribute)componentEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_LoggingLevel() {
		return (EAttribute)componentEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_Name() {
		return (EAttribute)componentEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_Role() {
		return (EAttribute)componentEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_RoleCreationDate() {
		return (EAttribute)componentEClass.getEStructuralFeatures().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_RoleVersion() {
		return (EAttribute)componentEClass.getEStructuralFeatures().get(11);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_RoleVersionDescription() {
		return (EAttribute)componentEClass.getEStructuralFeatures().get(12);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getComponent_UniqueID() {
		return (EAttribute)componentEClass.getEStructuralFeatures().get(13);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getContextsType() {
		return contextsTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextsType_Group() {
		return (EAttribute)contextsTypeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getContextsType_Context() {
		return (EReference)contextsTypeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getContextType() {
		return contextTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_Group() {
		return (EAttribute)contextTypeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getContextType_Component() {
		return (EReference)contextTypeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_Description() {
		return (EAttribute)contextTypeEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_ExecutableClass() {
		return (EAttribute)contextTypeEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_ImplementationCreationDate() {
		return (EAttribute)contextTypeEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_ImplementationVersion() {
		return (EAttribute)contextTypeEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_ImplementationVersionDescription() {
		return (EAttribute)contextTypeEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_LoggingLevel() {
		return (EAttribute)contextTypeEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_Name() {
		return (EAttribute)contextTypeEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_Role() {
		return (EAttribute)contextTypeEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_RoleCreationDate() {
		return (EAttribute)contextTypeEClass.getEStructuralFeatures().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_RoleVersion() {
		return (EAttribute)contextTypeEClass.getEStructuralFeatures().get(11);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_RoleVersionDescription() {
		return (EAttribute)contextTypeEClass.getEStructuralFeatures().get(12);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getContextType_UniqueID() {
		return (EAttribute)contextTypeEClass.getEStructuralFeatures().get(13);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDocumentRoot() {
		return documentRootEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDocumentRoot_Mixed() {
		return (EAttribute)documentRootEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDocumentRoot_XMLNSPrefixMap() {
		return (EReference)documentRootEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDocumentRoot_XSISchemaLocation() {
		return (EReference)documentRootEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDocumentRoot_Context() {
		return (EReference)documentRootEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDocumentRoot_Contexts() {
		return (EReference)documentRootEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getContextRoleNames() {
		return contextRoleNamesEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getRoleNames() {
		return roleNamesEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EDataType getContextRoleNamesObject() {
		return contextRoleNamesObjectEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EDataType getRoleNamesObject() {
		return roleNamesObjectEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ContextFactory getContextFactory() {
		return (ContextFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		componentEClass = createEClass(COMPONENT);
		createEAttribute(componentEClass, COMPONENT__GROUP);
		createEReference(componentEClass, COMPONENT__COMPONENT);
		createEAttribute(componentEClass, COMPONENT__DESCRIPTION);
		createEAttribute(componentEClass, COMPONENT__EXECUTABLE_CLASS);
		createEAttribute(componentEClass, COMPONENT__IMPLEMENTATION_CREATION_DATE);
		createEAttribute(componentEClass, COMPONENT__IMPLEMENTATION_VERSION);
		createEAttribute(componentEClass, COMPONENT__IMPLEMENTATION_VERSION_DESCRIPTION);
		createEAttribute(componentEClass, COMPONENT__LOGGING_LEVEL);
		createEAttribute(componentEClass, COMPONENT__NAME);
		createEAttribute(componentEClass, COMPONENT__ROLE);
		createEAttribute(componentEClass, COMPONENT__ROLE_CREATION_DATE);
		createEAttribute(componentEClass, COMPONENT__ROLE_VERSION);
		createEAttribute(componentEClass, COMPONENT__ROLE_VERSION_DESCRIPTION);
		createEAttribute(componentEClass, COMPONENT__UNIQUE_ID);

		contextsTypeEClass = createEClass(CONTEXT_STYPE);
		createEAttribute(contextsTypeEClass, CONTEXT_STYPE__GROUP);
		createEReference(contextsTypeEClass, CONTEXT_STYPE__CONTEXT);

		contextTypeEClass = createEClass(CONTEXT_TYPE);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__GROUP);
		createEReference(contextTypeEClass, CONTEXT_TYPE__COMPONENT);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__DESCRIPTION);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__EXECUTABLE_CLASS);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__IMPLEMENTATION_CREATION_DATE);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__IMPLEMENTATION_VERSION);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__IMPLEMENTATION_VERSION_DESCRIPTION);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__LOGGING_LEVEL);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__NAME);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__ROLE);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__ROLE_CREATION_DATE);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__ROLE_VERSION);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__ROLE_VERSION_DESCRIPTION);
		createEAttribute(contextTypeEClass, CONTEXT_TYPE__UNIQUE_ID);

		documentRootEClass = createEClass(DOCUMENT_ROOT);
		createEAttribute(documentRootEClass, DOCUMENT_ROOT__MIXED);
		createEReference(documentRootEClass, DOCUMENT_ROOT__XMLNS_PREFIX_MAP);
		createEReference(documentRootEClass, DOCUMENT_ROOT__XSI_SCHEMA_LOCATION);
		createEReference(documentRootEClass, DOCUMENT_ROOT__CONTEXT);
		createEReference(documentRootEClass, DOCUMENT_ROOT__CONTEXTS);

		// Create enums
		contextRoleNamesEEnum = createEEnum(CONTEXT_ROLE_NAMES);
		roleNamesEEnum = createEEnum(ROLE_NAMES);

		// Create data types
		contextRoleNamesObjectEDataType = createEDataType(CONTEXT_ROLE_NAMES_OBJECT);
		roleNamesObjectEDataType = createEDataType(ROLE_NAMES_OBJECT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		XMLTypePackageImpl theXMLTypePackage = (XMLTypePackageImpl)EPackage.Registry.INSTANCE.getEPackage(XMLTypePackage.eNS_URI);

		// Add supertypes to classes

		// Initialize classes and features; add operations and parameters
		initEClass(componentEClass, Component.class, "Component", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getComponent_Group(), ecorePackage.getEFeatureMapEntry(), "group", null, 0, -1, Component.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getComponent_Component(), this.getComponent(), null, "component", null, 0, -1, Component.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED);
		initEAttribute(getComponent_Description(), theXMLTypePackage.getString(), "description", null, 0, 1, Component.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getComponent_ExecutableClass(), theXMLTypePackage.getString(), "executableClass", null, 1, 1, Component.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getComponent_ImplementationCreationDate(), theXMLTypePackage.getDateTime(), "implementationCreationDate", null, 0, 1, Component.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getComponent_ImplementationVersion(), theXMLTypePackage.getString(), "implementationVersion", null, 1, 1, Component.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getComponent_ImplementationVersionDescription(), theXMLTypePackage.getString(), "implementationVersionDescription", null, 0, 1, Component.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getComponent_LoggingLevel(), theXMLTypePackage.getString(), "loggingLevel", null, 1, 1, Component.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getComponent_Name(), theXMLTypePackage.getString(), "name", null, 1, 1, Component.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getComponent_Role(), this.getRoleNames(), "role", "sensor", 1, 1, Component.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getComponent_RoleCreationDate(), theXMLTypePackage.getDateTime(), "roleCreationDate", null, 0, 1, Component.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getComponent_RoleVersion(), theXMLTypePackage.getString(), "roleVersion", null, 1, 1, Component.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getComponent_RoleVersionDescription(), theXMLTypePackage.getString(), "roleVersionDescription", null, 0, 1, Component.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getComponent_UniqueID(), theXMLTypePackage.getID(), "uniqueID", null, 1, 1, Component.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(contextsTypeEClass, ContextsType.class, "ContextsType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getContextsType_Group(), ecorePackage.getEFeatureMapEntry(), "group", null, 0, -1, ContextsType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getContextsType_Context(), this.getContextType(), null, "context", null, 1, -1, ContextsType.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED);

		initEClass(contextTypeEClass, ContextType.class, "ContextType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getContextType_Group(), ecorePackage.getEFeatureMapEntry(), "group", null, 0, -1, ContextType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getContextType_Component(), this.getComponent(), null, "component", null, 1, -1, ContextType.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED);
		initEAttribute(getContextType_Description(), theXMLTypePackage.getString(), "description", null, 0, 1, ContextType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContextType_ExecutableClass(), theXMLTypePackage.getString(), "executableClass", null, 1, 1, ContextType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContextType_ImplementationCreationDate(), theXMLTypePackage.getDateTime(), "implementationCreationDate", null, 0, 1, ContextType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContextType_ImplementationVersion(), theXMLTypePackage.getString(), "implementationVersion", null, 1, 1, ContextType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContextType_ImplementationVersionDescription(), theXMLTypePackage.getString(), "implementationVersionDescription", null, 0, 1, ContextType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContextType_LoggingLevel(), theXMLTypePackage.getString(), "loggingLevel", null, 1, 1, ContextType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContextType_Name(), theXMLTypePackage.getString(), "name", null, 1, 1, ContextType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContextType_Role(), this.getContextRoleNames(), "role", "context", 1, 1, ContextType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContextType_RoleCreationDate(), theXMLTypePackage.getDateTime(), "roleCreationDate", null, 0, 1, ContextType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContextType_RoleVersion(), theXMLTypePackage.getString(), "roleVersion", null, 1, 1, ContextType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContextType_RoleVersionDescription(), theXMLTypePackage.getString(), "roleVersionDescription", null, 0, 1, ContextType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContextType_UniqueID(), theXMLTypePackage.getID(), "uniqueID", null, 1, 1, ContextType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(documentRootEClass, DocumentRoot.class, "DocumentRoot", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getDocumentRoot_Mixed(), ecorePackage.getEFeatureMapEntry(), "mixed", null, 0, -1, null, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentRoot_XMLNSPrefixMap(), ecorePackage.getEStringToStringMapEntry(), null, "xMLNSPrefixMap", null, 0, -1, null, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentRoot_XSISchemaLocation(), ecorePackage.getEStringToStringMapEntry(), null, "xSISchemaLocation", null, 0, -1, null, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentRoot_Context(), this.getContextType(), null, "context", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentRoot_Contexts(), this.getContextsType(), null, "contexts", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(contextRoleNamesEEnum, ContextRoleNames.class, "ContextRoleNames");
		addEEnumLiteral(contextRoleNamesEEnum, ContextRoleNames.CONTEXT_LITERAL);

		initEEnum(roleNamesEEnum, RoleNames.class, "RoleNames");
		addEEnumLiteral(roleNamesEEnum, RoleNames.SENSOR_LITERAL);
		addEEnumLiteral(roleNamesEEnum, RoleNames.MESSAGE_EXTRACTOR_LITERAL);
		addEEnumLiteral(roleNamesEEnum, RoleNames.PARSER_LITERAL);
		addEEnumLiteral(roleNamesEEnum, RoleNames.FORMATTER_LITERAL);
		addEEnumLiteral(roleNamesEEnum, RoleNames.MESSAGE_FILTER_LITERAL);
		addEEnumLiteral(roleNamesEEnum, RoleNames.CBE_FILTER_LITERAL);
		addEEnumLiteral(roleNamesEEnum, RoleNames.OUTPUTTER_LITERAL);
		addEEnumLiteral(roleNamesEEnum, RoleNames.CONTEXT_LITERAL);
		addEEnumLiteral(roleNamesEEnum, RoleNames.UNDECLARED_LITERAL);

		// Initialize data types
		initEDataType(contextRoleNamesObjectEDataType, ContextRoleNames.class, "ContextRoleNamesObject", IS_SERIALIZABLE, IS_GENERATED_INSTANCE_CLASS);
		initEDataType(roleNamesObjectEDataType, RoleNames.class, "RoleNamesObject", IS_SERIALIZABLE, IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http:///org/eclipse/emf/ecore/util/ExtendedMetaData
		createExtendedMetaDataAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http:///org/eclipse/emf/ecore/util/ExtendedMetaData</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createExtendedMetaDataAnnotations() {
		String source = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";				
		addAnnotation
		  (componentEClass, 
		   source, 
		   new String[] {
			 "name", "component",
			 "kind", "elementOnly"
		   });		
		addAnnotation
		  (getComponent_Group(), 
		   source, 
		   new String[] {
			 "kind", "group",
			 "name", "group:0"
		   });		
		addAnnotation
		  (getComponent_Component(), 
		   source, 
		   new String[] {
			 "kind", "element",
			 "name", "Component",
			 "namespace", "##targetNamespace",
			 "group", "#group:0"
		   });		
		addAnnotation
		  (getComponent_Description(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "description"
		   });		
		addAnnotation
		  (getComponent_ExecutableClass(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "executableClass"
		   });		
		addAnnotation
		  (getComponent_ImplementationCreationDate(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "implementationCreationDate"
		   });		
		addAnnotation
		  (getComponent_ImplementationVersion(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "implementationVersion"
		   });		
		addAnnotation
		  (getComponent_ImplementationVersionDescription(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "implementationVersionDescription"
		   });		
		addAnnotation
		  (getComponent_LoggingLevel(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "loggingLevel"
		   });		
		addAnnotation
		  (getComponent_Name(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "name"
		   });		
		addAnnotation
		  (getComponent_Role(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "role"
		   });		
		addAnnotation
		  (getComponent_RoleCreationDate(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "roleCreationDate"
		   });		
		addAnnotation
		  (getComponent_RoleVersion(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "roleVersion"
		   });		
		addAnnotation
		  (getComponent_RoleVersionDescription(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "roleVersionDescription"
		   });		
		addAnnotation
		  (getComponent_UniqueID(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "uniqueID"
		   });			
		addAnnotation
		  (contextRoleNamesEEnum, 
		   source, 
		   new String[] {
			 "name", "contextRoleNames"
		   });		
		addAnnotation
		  (contextRoleNamesObjectEDataType, 
		   source, 
		   new String[] {
			 "name", "contextRoleNames:Object",
			 "baseType", "contextRoleNames"
		   });		
		addAnnotation
		  (contextsTypeEClass, 
		   source, 
		   new String[] {
			 "name", "ContextsType",
			 "kind", "elementOnly"
		   });		
		addAnnotation
		  (getContextsType_Group(), 
		   source, 
		   new String[] {
			 "kind", "group",
			 "name", "group:0"
		   });		
		addAnnotation
		  (getContextsType_Context(), 
		   source, 
		   new String[] {
			 "kind", "element",
			 "name", "Context",
			 "namespace", "##targetNamespace",
			 "group", "#group:0"
		   });			
		addAnnotation
		  (contextTypeEClass, 
		   source, 
		   new String[] {
			 "name", "contextType",
			 "kind", "elementOnly"
		   });		
		addAnnotation
		  (getContextType_Group(), 
		   source, 
		   new String[] {
			 "kind", "group",
			 "name", "group:0"
		   });		
		addAnnotation
		  (getContextType_Component(), 
		   source, 
		   new String[] {
			 "kind", "element",
			 "name", "Component",
			 "namespace", "##targetNamespace",
			 "group", "#group:0"
		   });		
		addAnnotation
		  (getContextType_Description(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "description"
		   });		
		addAnnotation
		  (getContextType_ExecutableClass(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "executableClass"
		   });		
		addAnnotation
		  (getContextType_ImplementationCreationDate(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "implementationCreationDate"
		   });		
		addAnnotation
		  (getContextType_ImplementationVersion(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "implementationVersion"
		   });		
		addAnnotation
		  (getContextType_ImplementationVersionDescription(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "implementationVersionDescription"
		   });		
		addAnnotation
		  (getContextType_LoggingLevel(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "loggingLevel"
		   });		
		addAnnotation
		  (getContextType_Name(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "name"
		   });		
		addAnnotation
		  (getContextType_Role(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "role"
		   });		
		addAnnotation
		  (getContextType_RoleCreationDate(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "roleCreationDate"
		   });		
		addAnnotation
		  (getContextType_RoleVersion(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "roleVersion"
		   });		
		addAnnotation
		  (getContextType_RoleVersionDescription(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "roleVersionDescription"
		   });		
		addAnnotation
		  (getContextType_UniqueID(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "uniqueID"
		   });			
		addAnnotation
		  (roleNamesEEnum, 
		   source, 
		   new String[] {
			 "name", "roleNames"
		   });		
		addAnnotation
		  (roleNamesObjectEDataType, 
		   source, 
		   new String[] {
			 "name", "roleNames:Object",
			 "baseType", "roleNames"
		   });		
		addAnnotation
		  (documentRootEClass, 
		   source, 
		   new String[] {
			 "name", "",
			 "kind", "mixed"
		   });		
		addAnnotation
		  (getDocumentRoot_Mixed(), 
		   source, 
		   new String[] {
			 "kind", "elementWildcard",
			 "name", ":mixed"
		   });		
		addAnnotation
		  (getDocumentRoot_XMLNSPrefixMap(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "xmlns:prefix"
		   });		
		addAnnotation
		  (getDocumentRoot_XSISchemaLocation(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "xsi:schemaLocation"
		   });		
		addAnnotation
		  (getDocumentRoot_Context(), 
		   source, 
		   new String[] {
			 "kind", "element",
			 "name", "Context",
			 "namespace", "##targetNamespace"
		   });		
		addAnnotation
		  (getDocumentRoot_Contexts(), 
		   source, 
		   new String[] {
			 "kind", "element",
			 "name", "Contexts",
			 "namespace", "##targetNamespace"
		   });
	}

} //ContextPackageImpl
