/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: FilterPackage.java,v 1.2 2005/03/24 21:12:26 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.filter;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.hyades.logging.adapter.model.internal.unit.UnitPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * 
 * 	        Copyright (c) 2005 IBM Corporation and others.
 *         All rights reserved.   This program and the accompanying materials
 *         are made available under the terms of the Eclipse Public License v1.0
 *         which accompanies this distribution, and is available at
 *         http://www.eclipse.org/legal/epl-v10.html
 * 			
 * 		This document describes the format for representation of filter rules
 * 		which can be consumed by the generic filter component.
 * 		*********************************************************************
 * 		Change History:
 * 		23 Mar 2005 - Dave Smith initial implementation 
 * 		*********************************************************************
 * 		
 * 
 *           Copyright (c) 2005 IBM Corporation and others.
 *           All rights reserved.   This program and the accompanying materials
 *           are made available under the terms of the Eclipse Public License v1.0
 *           which accompanies this distribution, and is available at
 *           http://www.eclipse.org/legal/epl-v10.html
 *         
 * <!-- end-model-doc -->
 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterFactory
 * @generated
 */
public interface FilterPackage extends EPackage{
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "filter";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/hyades/schema/Filter.xsd";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "filter";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	FilterPackage eINSTANCE = org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.AbstractFilterRuleTypeImpl <em>Abstract Filter Rule Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.AbstractFilterRuleTypeImpl
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl#getAbstractFilterRuleType()
	 * @generated
	 */
	int ABSTRACT_FILTER_RULE_TYPE = 0;

	/**
	 * The feature id for the '<em><b>Attribute Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME = 0;

	/**
	 * The feature id for the '<em><b>Attribute Name Path</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH = 1;

	/**
	 * The feature id for the '<em><b>Attribute Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_VALUE = 2;

	/**
	 * The feature id for the '<em><b>Implementation Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS = 3;

	/**
	 * The feature id for the '<em><b>Negation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FILTER_RULE_TYPE__NEGATION = 4;

	/**
	 * The number of structural features of the the '<em>Abstract Filter Rule Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_FILTER_RULE_TYPE_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterConfigTypeImpl <em>Config Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterConfigTypeImpl
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl#getFilterConfigType()
	 * @generated
	 */
	int FILTER_CONFIG_TYPE = 1;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_CONFIG_TYPE__PROPERTY = UnitPackage.PROCESS_UNIT_TYPE__PROPERTY;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_CONFIG_TYPE__DESCRIPTION = UnitPackage.PROCESS_UNIT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Unique ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_CONFIG_TYPE__UNIQUE_ID = UnitPackage.PROCESS_UNIT_TYPE__UNIQUE_ID;

	/**
	 * The feature id for the '<em><b>Abstract Filter Rule</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_CONFIG_TYPE__ABSTRACT_FILTER_RULE = UnitPackage.PROCESS_UNIT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Filter Rule Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_CONFIG_TYPE__FILTER_RULE_BLOCK = UnitPackage.PROCESS_UNIT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the the '<em>Config Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_CONFIG_TYPE_FEATURE_COUNT = UnitPackage.PROCESS_UNIT_TYPE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterRuleBlockTypeImpl <em>Rule Block Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterRuleBlockTypeImpl
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl#getFilterRuleBlockType()
	 * @generated
	 */
	int FILTER_RULE_BLOCK_TYPE = 2;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_RULE_BLOCK_TYPE__GROUP = 0;

	/**
	 * The feature id for the '<em><b>Abstract Filter Rule</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_RULE_BLOCK_TYPE__ABSTRACT_FILTER_RULE = 1;

	/**
	 * The feature id for the '<em><b>Filter Rule Block</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_RULE_BLOCK_TYPE__FILTER_RULE_BLOCK = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_RULE_BLOCK_TYPE__NAME = 3;

	/**
	 * The feature id for the '<em><b>Negation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_RULE_BLOCK_TYPE__NEGATION = 4;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_RULE_BLOCK_TYPE__OPERATOR = 5;

	/**
	 * The number of structural features of the the '<em>Rule Block Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_RULE_BLOCK_TYPE_FEATURE_COUNT = 6;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterRuleTypeImpl <em>Rule Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterRuleTypeImpl
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl#getFilterRuleType()
	 * @generated
	 */
	int FILTER_RULE_TYPE = 3;

	/**
	 * The feature id for the '<em><b>Attribute Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_RULE_TYPE__ATTRIBUTE_NAME = ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME;

	/**
	 * The feature id for the '<em><b>Attribute Name Path</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH = ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH;

	/**
	 * The feature id for the '<em><b>Attribute Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_RULE_TYPE__ATTRIBUTE_VALUE = ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_VALUE;

	/**
	 * The feature id for the '<em><b>Implementation Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_RULE_TYPE__IMPLEMENTATION_CLASS = ABSTRACT_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS;

	/**
	 * The feature id for the '<em><b>Negation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_RULE_TYPE__NEGATION = ABSTRACT_FILTER_RULE_TYPE__NEGATION;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_RULE_TYPE__OPERATOR = ABSTRACT_FILTER_RULE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Rule Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FILTER_RULE_TYPE_FEATURE_COUNT = ABSTRACT_FILTER_RULE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.NumericalFilterRuleTypeImpl <em>Numerical Filter Rule Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.NumericalFilterRuleTypeImpl
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl#getNumericalFilterRuleType()
	 * @generated
	 */
	int NUMERICAL_FILTER_RULE_TYPE = 4;

	/**
	 * The feature id for the '<em><b>Attribute Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERICAL_FILTER_RULE_TYPE__ATTRIBUTE_NAME = ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME;

	/**
	 * The feature id for the '<em><b>Attribute Name Path</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERICAL_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH = ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH;

	/**
	 * The feature id for the '<em><b>Attribute Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERICAL_FILTER_RULE_TYPE__ATTRIBUTE_VALUE = ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_VALUE;

	/**
	 * The feature id for the '<em><b>Implementation Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERICAL_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS = ABSTRACT_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS;

	/**
	 * The feature id for the '<em><b>Negation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERICAL_FILTER_RULE_TYPE__NEGATION = ABSTRACT_FILTER_RULE_TYPE__NEGATION;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERICAL_FILTER_RULE_TYPE__OPERATOR = ABSTRACT_FILTER_RULE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Numerical Filter Rule Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NUMERICAL_FILTER_RULE_TYPE_FEATURE_COUNT = ABSTRACT_FILTER_RULE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.PathExpressionTypeImpl <em>Path Expression Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.PathExpressionTypeImpl
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl#getPathExpressionType()
	 * @generated
	 */
	int PATH_EXPRESSION_TYPE = 5;

	/**
	 * The feature id for the '<em><b>Group</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATH_EXPRESSION_TYPE__GROUP = 0;

	/**
	 * The feature id for the '<em><b>Node</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATH_EXPRESSION_TYPE__NODE = 1;

	/**
	 * The number of structural features of the the '<em>Path Expression Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PATH_EXPRESSION_TYPE_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.DocumentRootImpl <em>Document Root</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.DocumentRootImpl
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl#getDocumentRoot()
	 * @generated
	 */
	int DOCUMENT_ROOT = 6;

	/**
	 * The feature id for the '<em><b>Mixed</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__MIXED = 0;

	/**
	 * The feature id for the '<em><b>XMLNS Prefix Map</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__XMLNS_PREFIX_MAP = 1;

	/**
	 * The feature id for the '<em><b>XSI Schema Location</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__XSI_SCHEMA_LOCATION = 2;

	/**
	 * The feature id for the '<em><b>Filter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT__FILTER = 3;

	/**
	 * The number of structural features of the the '<em>Document Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DOCUMENT_ROOT_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.RangeFilterRuleTypeImpl <em>Range Filter Rule Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.RangeFilterRuleTypeImpl
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl#getRangeFilterRuleType()
	 * @generated
	 */
	int RANGE_FILTER_RULE_TYPE = 7;

	/**
	 * The feature id for the '<em><b>Attribute Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANGE_FILTER_RULE_TYPE__ATTRIBUTE_NAME = ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME;

	/**
	 * The feature id for the '<em><b>Attribute Name Path</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANGE_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH = ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH;

	/**
	 * The feature id for the '<em><b>Attribute Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANGE_FILTER_RULE_TYPE__ATTRIBUTE_VALUE = ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_VALUE;

	/**
	 * The feature id for the '<em><b>Implementation Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANGE_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS = ABSTRACT_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS;

	/**
	 * The feature id for the '<em><b>Negation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANGE_FILTER_RULE_TYPE__NEGATION = ABSTRACT_FILTER_RULE_TYPE__NEGATION;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANGE_FILTER_RULE_TYPE__OPERATOR = ABSTRACT_FILTER_RULE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>Range Filter Rule Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RANGE_FILTER_RULE_TYPE_FEATURE_COUNT = ABSTRACT_FILTER_RULE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.StringFilterRuleTypeImpl <em>String Filter Rule Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.StringFilterRuleTypeImpl
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl#getStringFilterRuleType()
	 * @generated
	 */
	int STRING_FILTER_RULE_TYPE = 8;

	/**
	 * The feature id for the '<em><b>Attribute Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_FILTER_RULE_TYPE__ATTRIBUTE_NAME = ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME;

	/**
	 * The feature id for the '<em><b>Attribute Name Path</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH = ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH;

	/**
	 * The feature id for the '<em><b>Attribute Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_FILTER_RULE_TYPE__ATTRIBUTE_VALUE = ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_VALUE;

	/**
	 * The feature id for the '<em><b>Implementation Class</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS = ABSTRACT_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS;

	/**
	 * The feature id for the '<em><b>Negation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_FILTER_RULE_TYPE__NEGATION = ABSTRACT_FILTER_RULE_TYPE__NEGATION;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_FILTER_RULE_TYPE__OPERATOR = ABSTRACT_FILTER_RULE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>String Filter Rule Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRING_FILTER_RULE_TYPE_FEATURE_COUNT = ABSTRACT_FILTER_RULE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.LogicalOperatorType <em>Logical Operator Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.LogicalOperatorType
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl#getLogicalOperatorType()
	 * @generated
	 */
	int LOGICAL_OPERATOR_TYPE = 9;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.NumericalRelationalOperatorType <em>Numerical Relational Operator Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.NumericalRelationalOperatorType
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl#getNumericalRelationalOperatorType()
	 * @generated
	 */
	int NUMERICAL_RELATIONAL_OPERATOR_TYPE = 10;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.RangeRelationalOperatorType <em>Range Relational Operator Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.RangeRelationalOperatorType
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl#getRangeRelationalOperatorType()
	 * @generated
	 */
	int RANGE_RELATIONAL_OPERATOR_TYPE = 11;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.StringRelationalOperatorType <em>String Relational Operator Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.StringRelationalOperatorType
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl#getStringRelationalOperatorType()
	 * @generated
	 */
	int STRING_RELATIONAL_OPERATOR_TYPE = 12;

	/**
	 * The meta object id for the '<em>Logical Operator Type Object</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.LogicalOperatorType
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl#getLogicalOperatorTypeObject()
	 * @generated
	 */
	int LOGICAL_OPERATOR_TYPE_OBJECT = 13;

	/**
	 * The meta object id for the '<em>Numerical Relational Operator Type Object</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.NumericalRelationalOperatorType
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl#getNumericalRelationalOperatorTypeObject()
	 * @generated
	 */
	int NUMERICAL_RELATIONAL_OPERATOR_TYPE_OBJECT = 14;

	/**
	 * The meta object id for the '<em>Range Relational Operator Type Object</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.RangeRelationalOperatorType
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl#getRangeRelationalOperatorTypeObject()
	 * @generated
	 */
	int RANGE_RELATIONAL_OPERATOR_TYPE_OBJECT = 15;

	/**
	 * The meta object id for the '<em>String Relational Operator Type Object</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.StringRelationalOperatorType
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterPackageImpl#getStringRelationalOperatorTypeObject()
	 * @generated
	 */
	int STRING_RELATIONAL_OPERATOR_TYPE_OBJECT = 16;


	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType <em>Abstract Filter Rule Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract Filter Rule Type</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType
	 * @generated
	 */
	EClass getAbstractFilterRuleType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#getAttributeName <em>Attribute Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Attribute Name</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#getAttributeName()
	 * @see #getAbstractFilterRuleType()
	 * @generated
	 */
	EAttribute getAbstractFilterRuleType_AttributeName();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#getAttributeNamePath <em>Attribute Name Path</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Attribute Name Path</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#getAttributeNamePath()
	 * @see #getAbstractFilterRuleType()
	 * @generated
	 */
	EReference getAbstractFilterRuleType_AttributeNamePath();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#getAttributeValue <em>Attribute Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Attribute Value</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#getAttributeValue()
	 * @see #getAbstractFilterRuleType()
	 * @generated
	 */
	EAttribute getAbstractFilterRuleType_AttributeValue();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#getImplementationClass <em>Implementation Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Implementation Class</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#getImplementationClass()
	 * @see #getAbstractFilterRuleType()
	 * @generated
	 */
	EAttribute getAbstractFilterRuleType_ImplementationClass();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#isNegation <em>Negation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Negation</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType#isNegation()
	 * @see #getAbstractFilterRuleType()
	 * @generated
	 */
	EAttribute getAbstractFilterRuleType_Negation();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterConfigType <em>Config Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Config Type</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterConfigType
	 * @generated
	 */
	EClass getFilterConfigType();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterConfigType#getAbstractFilterRule <em>Abstract Filter Rule</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Abstract Filter Rule</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterConfigType#getAbstractFilterRule()
	 * @see #getFilterConfigType()
	 * @generated
	 */
	EReference getFilterConfigType_AbstractFilterRule();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterConfigType#getFilterRuleBlock <em>Filter Rule Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Filter Rule Block</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterConfigType#getFilterRuleBlock()
	 * @see #getFilterConfigType()
	 * @generated
	 */
	EReference getFilterConfigType_FilterRuleBlock();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType <em>Rule Block Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rule Block Type</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType
	 * @generated
	 */
	EClass getFilterRuleBlockType();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getGroup <em>Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Group</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getGroup()
	 * @see #getFilterRuleBlockType()
	 * @generated
	 */
	EAttribute getFilterRuleBlockType_Group();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getAbstractFilterRule <em>Abstract Filter Rule</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Abstract Filter Rule</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getAbstractFilterRule()
	 * @see #getFilterRuleBlockType()
	 * @generated
	 */
	EReference getFilterRuleBlockType_AbstractFilterRule();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getFilterRuleBlock <em>Filter Rule Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Filter Rule Block</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getFilterRuleBlock()
	 * @see #getFilterRuleBlockType()
	 * @generated
	 */
	EReference getFilterRuleBlockType_FilterRuleBlock();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getName()
	 * @see #getFilterRuleBlockType()
	 * @generated
	 */
	EAttribute getFilterRuleBlockType_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#isNegation <em>Negation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Negation</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#isNegation()
	 * @see #getFilterRuleBlockType()
	 * @generated
	 */
	EAttribute getFilterRuleBlockType_Negation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getOperator()
	 * @see #getFilterRuleBlockType()
	 * @generated
	 */
	EAttribute getFilterRuleBlockType_Operator();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleType <em>Rule Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rule Type</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleType
	 * @generated
	 */
	EClass getFilterRuleType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleType#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleType#getOperator()
	 * @see #getFilterRuleType()
	 * @generated
	 */
	EAttribute getFilterRuleType_Operator();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.NumericalFilterRuleType <em>Numerical Filter Rule Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Numerical Filter Rule Type</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.NumericalFilterRuleType
	 * @generated
	 */
	EClass getNumericalFilterRuleType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.NumericalFilterRuleType#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.NumericalFilterRuleType#getOperator()
	 * @see #getNumericalFilterRuleType()
	 * @generated
	 */
	EAttribute getNumericalFilterRuleType_Operator();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.PathExpressionType <em>Path Expression Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Path Expression Type</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.PathExpressionType
	 * @generated
	 */
	EClass getPathExpressionType();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.PathExpressionType#getGroup <em>Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Group</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.PathExpressionType#getGroup()
	 * @see #getPathExpressionType()
	 * @generated
	 */
	EAttribute getPathExpressionType_Group();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.PathExpressionType#getNode <em>Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Node</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.PathExpressionType#getNode()
	 * @see #getPathExpressionType()
	 * @generated
	 */
	EAttribute getPathExpressionType_Node();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.DocumentRoot <em>Document Root</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Document Root</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.DocumentRoot
	 * @generated
	 */
	EClass getDocumentRoot();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.DocumentRoot#getMixed <em>Mixed</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Mixed</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.DocumentRoot#getMixed()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EAttribute getDocumentRoot_Mixed();

	/**
	 * Returns the meta object for the map '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.DocumentRoot#getXMLNSPrefixMap <em>XMLNS Prefix Map</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>XMLNS Prefix Map</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.DocumentRoot#getXMLNSPrefixMap()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_XMLNSPrefixMap();

	/**
	 * Returns the meta object for the map '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.DocumentRoot#getXSISchemaLocation <em>XSI Schema Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>XSI Schema Location</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.DocumentRoot#getXSISchemaLocation()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_XSISchemaLocation();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.DocumentRoot#getFilter <em>Filter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Filter</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.DocumentRoot#getFilter()
	 * @see #getDocumentRoot()
	 * @generated
	 */
	EReference getDocumentRoot_Filter();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.RangeFilterRuleType <em>Range Filter Rule Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Range Filter Rule Type</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.RangeFilterRuleType
	 * @generated
	 */
	EClass getRangeFilterRuleType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.RangeFilterRuleType#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.RangeFilterRuleType#getOperator()
	 * @see #getRangeFilterRuleType()
	 * @generated
	 */
	EAttribute getRangeFilterRuleType_Operator();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.StringFilterRuleType <em>String Filter Rule Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>String Filter Rule Type</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.StringFilterRuleType
	 * @generated
	 */
	EClass getStringFilterRuleType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.StringFilterRuleType#getOperator <em>Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operator</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.StringFilterRuleType#getOperator()
	 * @see #getStringFilterRuleType()
	 * @generated
	 */
	EAttribute getStringFilterRuleType_Operator();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.LogicalOperatorType <em>Logical Operator Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Logical Operator Type</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.LogicalOperatorType
	 * @generated
	 */
	EEnum getLogicalOperatorType();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.NumericalRelationalOperatorType <em>Numerical Relational Operator Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Numerical Relational Operator Type</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.NumericalRelationalOperatorType
	 * @generated
	 */
	EEnum getNumericalRelationalOperatorType();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.RangeRelationalOperatorType <em>Range Relational Operator Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Range Relational Operator Type</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.RangeRelationalOperatorType
	 * @generated
	 */
	EEnum getRangeRelationalOperatorType();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.StringRelationalOperatorType <em>String Relational Operator Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>String Relational Operator Type</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.StringRelationalOperatorType
	 * @generated
	 */
	EEnum getStringRelationalOperatorType();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.LogicalOperatorType <em>Logical Operator Type Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Logical Operator Type Object</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.LogicalOperatorType
	 * @model instanceClass="org.eclipse.hyades.logging.adapter.model.internal.filter.LogicalOperatorType"
	 * @generated
	 */
	EDataType getLogicalOperatorTypeObject();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.NumericalRelationalOperatorType <em>Numerical Relational Operator Type Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Numerical Relational Operator Type Object</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.NumericalRelationalOperatorType
	 * @model instanceClass="org.eclipse.hyades.logging.adapter.model.internal.filter.NumericalRelationalOperatorType"
	 * @generated
	 */
	EDataType getNumericalRelationalOperatorTypeObject();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.RangeRelationalOperatorType <em>Range Relational Operator Type Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Range Relational Operator Type Object</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.RangeRelationalOperatorType
	 * @model instanceClass="org.eclipse.hyades.logging.adapter.model.internal.filter.RangeRelationalOperatorType"
	 * @generated
	 */
	EDataType getRangeRelationalOperatorTypeObject();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.StringRelationalOperatorType <em>String Relational Operator Type Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>String Relational Operator Type Object</em>'.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.StringRelationalOperatorType
	 * @model instanceClass="org.eclipse.hyades.logging.adapter.model.internal.filter.StringRelationalOperatorType"
	 * @generated
	 */
	EDataType getStringRelationalOperatorTypeObject();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	FilterFactory getFilterFactory();

} //FilterPackage
