/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: NumericalRelationalOperatorType.java,v 1.2 2005/03/24 21:12:26 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Numerical Relational Operator Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 *     Relational operators that can operate on
 *                 a numerical value.
 * <!-- end-model-doc -->
 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage#getNumericalRelationalOperatorType()
 * @model
 * @generated
 */
public final class NumericalRelationalOperatorType extends AbstractEnumerator {
	/**
	 * The '<em><b>Equals</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EQUALS_LITERAL
	 * @model name="equals"
	 * @generated
	 * @ordered
	 */
	public static final int EQUALS = 0;

	/**
	 * The '<em><b>Greater Than</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GREATER_THAN_LITERAL
	 * @model name="greaterThan"
	 * @generated
	 * @ordered
	 */
	public static final int GREATER_THAN = 1;

	/**
	 * The '<em><b>Less Than</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LESS_THAN_LITERAL
	 * @model name="lessThan"
	 * @generated
	 * @ordered
	 */
	public static final int LESS_THAN = 2;

	/**
	 * The '<em><b>Greater Than Or Equal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GREATER_THAN_OR_EQUAL_LITERAL
	 * @model name="greaterThanOrEqual"
	 * @generated
	 * @ordered
	 */
	public static final int GREATER_THAN_OR_EQUAL = 3;

	/**
	 * The '<em><b>Less Than Or Equal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LESS_THAN_OR_EQUAL_LITERAL
	 * @model name="lessThanOrEqual"
	 * @generated
	 * @ordered
	 */
	public static final int LESS_THAN_OR_EQUAL = 4;

	/**
	 * The '<em><b>Equals</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Equals</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EQUALS
	 * @generated
	 * @ordered
	 */
	public static final NumericalRelationalOperatorType EQUALS_LITERAL = new NumericalRelationalOperatorType(EQUALS, "equals");

	/**
	 * The '<em><b>Greater Than</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Greater Than</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #GREATER_THAN
	 * @generated
	 * @ordered
	 */
	public static final NumericalRelationalOperatorType GREATER_THAN_LITERAL = new NumericalRelationalOperatorType(GREATER_THAN, "greaterThan");

	/**
	 * The '<em><b>Less Than</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Less Than</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LESS_THAN
	 * @generated
	 * @ordered
	 */
	public static final NumericalRelationalOperatorType LESS_THAN_LITERAL = new NumericalRelationalOperatorType(LESS_THAN, "lessThan");

	/**
	 * The '<em><b>Greater Than Or Equal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Greater Than Or Equal</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #GREATER_THAN_OR_EQUAL
	 * @generated
	 * @ordered
	 */
	public static final NumericalRelationalOperatorType GREATER_THAN_OR_EQUAL_LITERAL = new NumericalRelationalOperatorType(GREATER_THAN_OR_EQUAL, "greaterThanOrEqual");

	/**
	 * The '<em><b>Less Than Or Equal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Less Than Or Equal</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LESS_THAN_OR_EQUAL
	 * @generated
	 * @ordered
	 */
	public static final NumericalRelationalOperatorType LESS_THAN_OR_EQUAL_LITERAL = new NumericalRelationalOperatorType(LESS_THAN_OR_EQUAL, "lessThanOrEqual");

	/**
	 * An array of all the '<em><b>Numerical Relational Operator Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final NumericalRelationalOperatorType[] VALUES_ARRAY =
		new NumericalRelationalOperatorType[] {
			EQUALS_LITERAL,
			GREATER_THAN_LITERAL,
			LESS_THAN_LITERAL,
			GREATER_THAN_OR_EQUAL_LITERAL,
			LESS_THAN_OR_EQUAL_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Numerical Relational Operator Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Numerical Relational Operator Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static NumericalRelationalOperatorType get(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			NumericalRelationalOperatorType result = VALUES_ARRAY[i];
			if (result.toString().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Numerical Relational Operator Type</b></em>' literal with the specified value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static NumericalRelationalOperatorType get(int value) {
		switch (value) {
			case EQUALS: return EQUALS_LITERAL;
			case GREATER_THAN: return GREATER_THAN_LITERAL;
			case LESS_THAN: return LESS_THAN_LITERAL;
			case GREATER_THAN_OR_EQUAL: return GREATER_THAN_OR_EQUAL_LITERAL;
			case LESS_THAN_OR_EQUAL: return LESS_THAN_OR_EQUAL_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private NumericalRelationalOperatorType(int value, String name) {
		super(value, name);
	}

} //NumericalRelationalOperatorType
