/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: FilterConfigTypeImpl.java,v 1.2 2005/03/24 21:12:27 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.filter.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType;

import org.eclipse.hyades.logging.adapter.model.internal.unit.impl.ProcessUnitTypeImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Config Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterConfigTypeImpl#getAbstractFilterRule <em>Abstract Filter Rule</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterConfigTypeImpl#getFilterRuleBlock <em>Filter Rule Block</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class FilterConfigTypeImpl extends ProcessUnitTypeImpl implements FilterConfigType {
	/**
	 * The cached value of the '{@link #getAbstractFilterRule() <em>Abstract Filter Rule</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAbstractFilterRule()
	 * @generated
	 * @ordered
	 */
	protected AbstractFilterRuleType abstractFilterRule = null;

	/**
	 * The cached value of the '{@link #getFilterRuleBlock() <em>Filter Rule Block</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFilterRuleBlock()
	 * @generated
	 * @ordered
	 */
	protected FilterRuleBlockType filterRuleBlock = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FilterConfigTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return FilterPackage.eINSTANCE.getFilterConfigType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AbstractFilterRuleType getAbstractFilterRule() {
		return abstractFilterRule;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAbstractFilterRule(AbstractFilterRuleType newAbstractFilterRule, NotificationChain msgs) {
		AbstractFilterRuleType oldAbstractFilterRule = abstractFilterRule;
		abstractFilterRule = newAbstractFilterRule;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, FilterPackage.FILTER_CONFIG_TYPE__ABSTRACT_FILTER_RULE, oldAbstractFilterRule, newAbstractFilterRule);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAbstractFilterRule(AbstractFilterRuleType newAbstractFilterRule) {
		if (newAbstractFilterRule != abstractFilterRule) {
			NotificationChain msgs = null;
			if (abstractFilterRule != null)
				msgs = ((InternalEObject)abstractFilterRule).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - FilterPackage.FILTER_CONFIG_TYPE__ABSTRACT_FILTER_RULE, null, msgs);
			if (newAbstractFilterRule != null)
				msgs = ((InternalEObject)newAbstractFilterRule).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - FilterPackage.FILTER_CONFIG_TYPE__ABSTRACT_FILTER_RULE, null, msgs);
			msgs = basicSetAbstractFilterRule(newAbstractFilterRule, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, FilterPackage.FILTER_CONFIG_TYPE__ABSTRACT_FILTER_RULE, newAbstractFilterRule, newAbstractFilterRule));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FilterRuleBlockType getFilterRuleBlock() {
		return filterRuleBlock;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetFilterRuleBlock(FilterRuleBlockType newFilterRuleBlock, NotificationChain msgs) {
		FilterRuleBlockType oldFilterRuleBlock = filterRuleBlock;
		filterRuleBlock = newFilterRuleBlock;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, FilterPackage.FILTER_CONFIG_TYPE__FILTER_RULE_BLOCK, oldFilterRuleBlock, newFilterRuleBlock);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFilterRuleBlock(FilterRuleBlockType newFilterRuleBlock) {
		if (newFilterRuleBlock != filterRuleBlock) {
			NotificationChain msgs = null;
			if (filterRuleBlock != null)
				msgs = ((InternalEObject)filterRuleBlock).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - FilterPackage.FILTER_CONFIG_TYPE__FILTER_RULE_BLOCK, null, msgs);
			if (newFilterRuleBlock != null)
				msgs = ((InternalEObject)newFilterRuleBlock).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - FilterPackage.FILTER_CONFIG_TYPE__FILTER_RULE_BLOCK, null, msgs);
			msgs = basicSetFilterRuleBlock(newFilterRuleBlock, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, FilterPackage.FILTER_CONFIG_TYPE__FILTER_RULE_BLOCK, newFilterRuleBlock, newFilterRuleBlock));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case FilterPackage.FILTER_CONFIG_TYPE__PROPERTY:
					return ((InternalEList)getProperty()).basicRemove(otherEnd, msgs);
				case FilterPackage.FILTER_CONFIG_TYPE__ABSTRACT_FILTER_RULE:
					return basicSetAbstractFilterRule(null, msgs);
				case FilterPackage.FILTER_CONFIG_TYPE__FILTER_RULE_BLOCK:
					return basicSetFilterRuleBlock(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.FILTER_CONFIG_TYPE__PROPERTY:
				return getProperty();
			case FilterPackage.FILTER_CONFIG_TYPE__DESCRIPTION:
				return getDescription();
			case FilterPackage.FILTER_CONFIG_TYPE__UNIQUE_ID:
				return getUniqueID();
			case FilterPackage.FILTER_CONFIG_TYPE__ABSTRACT_FILTER_RULE:
				return getAbstractFilterRule();
			case FilterPackage.FILTER_CONFIG_TYPE__FILTER_RULE_BLOCK:
				return getFilterRuleBlock();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.FILTER_CONFIG_TYPE__PROPERTY:
				getProperty().clear();
				getProperty().addAll((Collection)newValue);
				return;
			case FilterPackage.FILTER_CONFIG_TYPE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case FilterPackage.FILTER_CONFIG_TYPE__UNIQUE_ID:
				setUniqueID((String)newValue);
				return;
			case FilterPackage.FILTER_CONFIG_TYPE__ABSTRACT_FILTER_RULE:
				setAbstractFilterRule((AbstractFilterRuleType)newValue);
				return;
			case FilterPackage.FILTER_CONFIG_TYPE__FILTER_RULE_BLOCK:
				setFilterRuleBlock((FilterRuleBlockType)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.FILTER_CONFIG_TYPE__PROPERTY:
				getProperty().clear();
				return;
			case FilterPackage.FILTER_CONFIG_TYPE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case FilterPackage.FILTER_CONFIG_TYPE__UNIQUE_ID:
				setUniqueID(UNIQUE_ID_EDEFAULT);
				return;
			case FilterPackage.FILTER_CONFIG_TYPE__ABSTRACT_FILTER_RULE:
				setAbstractFilterRule((AbstractFilterRuleType)null);
				return;
			case FilterPackage.FILTER_CONFIG_TYPE__FILTER_RULE_BLOCK:
				setFilterRuleBlock((FilterRuleBlockType)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.FILTER_CONFIG_TYPE__PROPERTY:
				return property != null && !property.isEmpty();
			case FilterPackage.FILTER_CONFIG_TYPE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case FilterPackage.FILTER_CONFIG_TYPE__UNIQUE_ID:
				return UNIQUE_ID_EDEFAULT == null ? uniqueID != null : !UNIQUE_ID_EDEFAULT.equals(uniqueID);
			case FilterPackage.FILTER_CONFIG_TYPE__ABSTRACT_FILTER_RULE:
				return abstractFilterRule != null;
			case FilterPackage.FILTER_CONFIG_TYPE__FILTER_RULE_BLOCK:
				return filterRuleBlock != null;
		}
		return eDynamicIsSet(eFeature);
	}

} //FilterConfigTypeImpl
