/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: FilterSwitch.java,v 1.2 2005/03/24 21:12:27 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.filter.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.logging.adapter.model.internal.filter.*;

import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage
 * @generated
 */
public class FilterSwitch {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static FilterPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FilterSwitch() {
		if (modelPackage == null) {
			modelPackage = FilterPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch((EClass)eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case FilterPackage.FILTER_CONFIG_TYPE: {
				FilterConfigType filterConfigType = (FilterConfigType)theEObject;
				Object result = caseFilterConfigType(filterConfigType);
				if (result == null) result = caseProcessUnitType(filterConfigType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case FilterPackage.FILTER_RULE_BLOCK_TYPE: {
				FilterRuleBlockType filterRuleBlockType = (FilterRuleBlockType)theEObject;
				Object result = caseFilterRuleBlockType(filterRuleBlockType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case FilterPackage.FILTER_RULE_TYPE: {
				FilterRuleType filterRuleType = (FilterRuleType)theEObject;
				Object result = caseFilterRuleType(filterRuleType);
				if (result == null) result = caseAbstractFilterRuleType(filterRuleType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case FilterPackage.NUMERICAL_FILTER_RULE_TYPE: {
				NumericalFilterRuleType numericalFilterRuleType = (NumericalFilterRuleType)theEObject;
				Object result = caseNumericalFilterRuleType(numericalFilterRuleType);
				if (result == null) result = caseAbstractFilterRuleType(numericalFilterRuleType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case FilterPackage.PATH_EXPRESSION_TYPE: {
				PathExpressionType pathExpressionType = (PathExpressionType)theEObject;
				Object result = casePathExpressionType(pathExpressionType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case FilterPackage.DOCUMENT_ROOT: {
				DocumentRoot documentRoot = (DocumentRoot)theEObject;
				Object result = caseDocumentRoot(documentRoot);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case FilterPackage.RANGE_FILTER_RULE_TYPE: {
				RangeFilterRuleType rangeFilterRuleType = (RangeFilterRuleType)theEObject;
				Object result = caseRangeFilterRuleType(rangeFilterRuleType);
				if (result == null) result = caseAbstractFilterRuleType(rangeFilterRuleType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case FilterPackage.STRING_FILTER_RULE_TYPE: {
				StringFilterRuleType stringFilterRuleType = (StringFilterRuleType)theEObject;
				Object result = caseStringFilterRuleType(stringFilterRuleType);
				if (result == null) result = caseAbstractFilterRuleType(stringFilterRuleType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Abstract Filter Rule Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Abstract Filter Rule Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseAbstractFilterRuleType(AbstractFilterRuleType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Config Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Config Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseFilterConfigType(FilterConfigType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Rule Block Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Rule Block Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseFilterRuleBlockType(FilterRuleBlockType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Rule Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Rule Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseFilterRuleType(FilterRuleType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Numerical Filter Rule Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Numerical Filter Rule Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseNumericalFilterRuleType(NumericalFilterRuleType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Path Expression Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Path Expression Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object casePathExpressionType(PathExpressionType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Document Root</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Document Root</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseDocumentRoot(DocumentRoot object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Range Filter Rule Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Range Filter Rule Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRangeFilterRuleType(RangeFilterRuleType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>String Filter Rule Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>String Filter Rule Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseStringFilterRuleType(StringFilterRuleType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Process Unit Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Process Unit Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseProcessUnitType(ProcessUnitType object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object) {
		return null;
	}

} //FilterSwitch
