/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: ParserConfigTypeImpl.java,v 1.10 2005/03/24 21:12:25 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.parser.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.util.Guid;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Config Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.ParserConfigTypeImpl#getRuleElement <em>Rule Element</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.ParserConfigTypeImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.ParserConfigTypeImpl#getDesignationToken <em>Designation Token</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.ParserConfigTypeImpl#getSeparatorToken <em>Separator Token</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.ParserConfigTypeImpl#getUniqueID <em>Unique ID</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ParserConfigTypeImpl extends EObjectImpl implements ParserConfigType {
	/**
	 * The cached value of the '{@link #getRuleElement() <em>Rule Element</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRuleElement()
	 * @generated
	 * @ordered
	 */
	protected EList ruleElement = null;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * The default value of the '{@link #getDesignationToken() <em>Designation Token</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDesignationToken()
	 * @generated
	 * @ordered
	 */
	protected static final String DESIGNATION_TOKEN_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDesignationToken() <em>Designation Token</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDesignationToken()
	 * @generated
	 * @ordered
	 */
	protected String designationToken = DESIGNATION_TOKEN_EDEFAULT;

	/**
	 * The default value of the '{@link #getSeparatorToken() <em>Separator Token</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSeparatorToken()
	 * @generated
	 * @ordered
	 */
	protected static final String SEPARATOR_TOKEN_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSeparatorToken() <em>Separator Token</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSeparatorToken()
	 * @generated
	 * @ordered
	 */
	protected String separatorToken = SEPARATOR_TOKEN_EDEFAULT;

	/**
	 * The default value of the '{@link #getUniqueID() <em>Unique ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUniqueID()
	 * @generated
	 * @ordered
	 */
	protected static final String UNIQUE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getUniqueID() <em>Unique ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUniqueID()
	 * @generated
	 * @ordered
	 */
	protected String uniqueID = UNIQUE_ID_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected ParserConfigTypeImpl() {
		super();
		uniqueID = (new Guid()).toString();		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ParserPackage.eINSTANCE.getParserConfigType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRuleElement() {
		if (ruleElement == null) {
			ruleElement = new EObjectContainmentEList(RuleElementType.class, this, ParserPackage.PARSER_CONFIG_TYPE__RULE_ELEMENT);
		}
		return ruleElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.PARSER_CONFIG_TYPE__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDesignationToken() {
		return designationToken;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDesignationToken(String newDesignationToken) {
		String oldDesignationToken = designationToken;
		designationToken = newDesignationToken;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.PARSER_CONFIG_TYPE__DESIGNATION_TOKEN, oldDesignationToken, designationToken));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getSeparatorToken() {
		return separatorToken;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSeparatorToken(String newSeparatorToken) {
		String oldSeparatorToken = separatorToken;
		separatorToken = newSeparatorToken;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.PARSER_CONFIG_TYPE__SEPARATOR_TOKEN, oldSeparatorToken, separatorToken));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getUniqueID() {
		return uniqueID;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUniqueID(String newUniqueID) {
		String oldUniqueID = uniqueID;
		uniqueID = newUniqueID;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.PARSER_CONFIG_TYPE__UNIQUE_ID, oldUniqueID, uniqueID));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ParserPackage.PARSER_CONFIG_TYPE__RULE_ELEMENT:
					return ((InternalEList)getRuleElement()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.PARSER_CONFIG_TYPE__RULE_ELEMENT:
				return getRuleElement();
			case ParserPackage.PARSER_CONFIG_TYPE__DESCRIPTION:
				return getDescription();
			case ParserPackage.PARSER_CONFIG_TYPE__DESIGNATION_TOKEN:
				return getDesignationToken();
			case ParserPackage.PARSER_CONFIG_TYPE__SEPARATOR_TOKEN:
				return getSeparatorToken();
			case ParserPackage.PARSER_CONFIG_TYPE__UNIQUE_ID:
				return getUniqueID();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.PARSER_CONFIG_TYPE__RULE_ELEMENT:
				getRuleElement().clear();
				getRuleElement().addAll((Collection)newValue);
				return;
			case ParserPackage.PARSER_CONFIG_TYPE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case ParserPackage.PARSER_CONFIG_TYPE__DESIGNATION_TOKEN:
				setDesignationToken((String)newValue);
				return;
			case ParserPackage.PARSER_CONFIG_TYPE__SEPARATOR_TOKEN:
				setSeparatorToken((String)newValue);
				return;
			case ParserPackage.PARSER_CONFIG_TYPE__UNIQUE_ID:
				setUniqueID((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.PARSER_CONFIG_TYPE__RULE_ELEMENT:
				getRuleElement().clear();
				return;
			case ParserPackage.PARSER_CONFIG_TYPE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case ParserPackage.PARSER_CONFIG_TYPE__DESIGNATION_TOKEN:
				setDesignationToken(DESIGNATION_TOKEN_EDEFAULT);
				return;
			case ParserPackage.PARSER_CONFIG_TYPE__SEPARATOR_TOKEN:
				setSeparatorToken(SEPARATOR_TOKEN_EDEFAULT);
				return;
			case ParserPackage.PARSER_CONFIG_TYPE__UNIQUE_ID:
				setUniqueID(UNIQUE_ID_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.PARSER_CONFIG_TYPE__RULE_ELEMENT:
				return ruleElement != null && !ruleElement.isEmpty();
			case ParserPackage.PARSER_CONFIG_TYPE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case ParserPackage.PARSER_CONFIG_TYPE__DESIGNATION_TOKEN:
				return DESIGNATION_TOKEN_EDEFAULT == null ? designationToken != null : !DESIGNATION_TOKEN_EDEFAULT.equals(designationToken);
			case ParserPackage.PARSER_CONFIG_TYPE__SEPARATOR_TOKEN:
				return SEPARATOR_TOKEN_EDEFAULT == null ? separatorToken != null : !SEPARATOR_TOKEN_EDEFAULT.equals(separatorToken);
			case ParserPackage.PARSER_CONFIG_TYPE__UNIQUE_ID:
				return UNIQUE_ID_EDEFAULT == null ? uniqueID != null : !UNIQUE_ID_EDEFAULT.equals(uniqueID);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (description: ");
		result.append(description);
		result.append(", designationToken: ");
		result.append(designationToken);
		result.append(", separatorToken: ");
		result.append(separatorToken);
		result.append(", uniqueID: ");
		result.append(uniqueID);
		result.append(')');
		return result.toString();
	}

} //ParserConfigTypeImpl
