/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: SubstitutionRuleTypeImpl.java,v 1.8 2005/03/24 21:12:25 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.parser.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage;
import org.eclipse.hyades.logging.adapter.model.internal.parser.SubstitutionRuleType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Substitution Rule Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.SubstitutionRuleTypeImpl#getMatch <em>Match</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.SubstitutionRuleTypeImpl#getPositions <em>Positions</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.SubstitutionRuleTypeImpl#getSubstitute <em>Substitute</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.SubstitutionRuleTypeImpl#getSubstitutionExtensionClass <em>Substitution Extension Class</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.SubstitutionRuleTypeImpl#getTimeFormat <em>Time Format</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.SubstitutionRuleTypeImpl#isUseBuiltInFunction <em>Use Built In Function</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SubstitutionRuleTypeImpl extends EObjectImpl implements SubstitutionRuleType {
	/**
	 * The default value of the '{@link #getMatch() <em>Match</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMatch()
	 * @generated
	 * @ordered
	 */
	protected static final String MATCH_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMatch() <em>Match</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMatch()
	 * @generated
	 * @ordered
	 */
	protected String match = MATCH_EDEFAULT;

	/**
	 * The default value of the '{@link #getPositions() <em>Positions</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPositions()
	 * @generated
	 * @ordered
	 */
	protected static final String POSITIONS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getPositions() <em>Positions</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPositions()
	 * @generated
	 * @ordered
	 */
	protected String positions = POSITIONS_EDEFAULT;

	/**
	 * The default value of the '{@link #getSubstitute() <em>Substitute</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubstitute()
	 * @generated
	 * @ordered
	 */
	protected static final String SUBSTITUTE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSubstitute() <em>Substitute</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubstitute()
	 * @generated
	 * @ordered
	 */
	protected String substitute = SUBSTITUTE_EDEFAULT;

	/**
	 * The default value of the '{@link #getSubstitutionExtensionClass() <em>Substitution Extension Class</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubstitutionExtensionClass()
	 * @generated
	 * @ordered
	 */
	protected static final String SUBSTITUTION_EXTENSION_CLASS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSubstitutionExtensionClass() <em>Substitution Extension Class</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubstitutionExtensionClass()
	 * @generated
	 * @ordered
	 */
	protected String substitutionExtensionClass = SUBSTITUTION_EXTENSION_CLASS_EDEFAULT;

	/**
	 * The default value of the '{@link #getTimeFormat() <em>Time Format</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimeFormat()
	 * @generated
	 * @ordered
	 */
	protected static final String TIME_FORMAT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTimeFormat() <em>Time Format</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimeFormat()
	 * @generated
	 * @ordered
	 */
	protected String timeFormat = TIME_FORMAT_EDEFAULT;

	/**
	 * The default value of the '{@link #isUseBuiltInFunction() <em>Use Built In Function</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isUseBuiltInFunction()
	 * @generated
	 * @ordered
	 */
	protected static final boolean USE_BUILT_IN_FUNCTION_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isUseBuiltInFunction() <em>Use Built In Function</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isUseBuiltInFunction()
	 * @generated
	 * @ordered
	 */
	protected boolean useBuiltInFunction = USE_BUILT_IN_FUNCTION_EDEFAULT;

	/**
	 * This is true if the Use Built In Function attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean useBuiltInFunctionESet = false;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SubstitutionRuleTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ParserPackage.eINSTANCE.getSubstitutionRuleType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getMatch() {
		return match;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMatch(String newMatch) {
		String oldMatch = match;
		match = newMatch;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.SUBSTITUTION_RULE_TYPE__MATCH, oldMatch, match));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getPositions() {
		return positions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPositions(String newPositions) {
		String oldPositions = positions;
		positions = newPositions;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.SUBSTITUTION_RULE_TYPE__POSITIONS, oldPositions, positions));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getSubstitute() {
		return substitute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSubstitute(String newSubstitute) {
		String oldSubstitute = substitute;
		substitute = newSubstitute;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.SUBSTITUTION_RULE_TYPE__SUBSTITUTE, oldSubstitute, substitute));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getSubstitutionExtensionClass() {
		return substitutionExtensionClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSubstitutionExtensionClass(String newSubstitutionExtensionClass) {
		String oldSubstitutionExtensionClass = substitutionExtensionClass;
		substitutionExtensionClass = newSubstitutionExtensionClass;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.SUBSTITUTION_RULE_TYPE__SUBSTITUTION_EXTENSION_CLASS, oldSubstitutionExtensionClass, substitutionExtensionClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getTimeFormat() {
		return timeFormat;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTimeFormat(String newTimeFormat) {
		String oldTimeFormat = timeFormat;
		timeFormat = newTimeFormat;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.SUBSTITUTION_RULE_TYPE__TIME_FORMAT, oldTimeFormat, timeFormat));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isUseBuiltInFunction() {
		return useBuiltInFunction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUseBuiltInFunction(boolean newUseBuiltInFunction) {
		boolean oldUseBuiltInFunction = useBuiltInFunction;
		useBuiltInFunction = newUseBuiltInFunction;
		boolean oldUseBuiltInFunctionESet = useBuiltInFunctionESet;
		useBuiltInFunctionESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.SUBSTITUTION_RULE_TYPE__USE_BUILT_IN_FUNCTION, oldUseBuiltInFunction, useBuiltInFunction, !oldUseBuiltInFunctionESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetUseBuiltInFunction() {
		boolean oldUseBuiltInFunction = useBuiltInFunction;
		boolean oldUseBuiltInFunctionESet = useBuiltInFunctionESet;
		useBuiltInFunction = USE_BUILT_IN_FUNCTION_EDEFAULT;
		useBuiltInFunctionESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, ParserPackage.SUBSTITUTION_RULE_TYPE__USE_BUILT_IN_FUNCTION, oldUseBuiltInFunction, USE_BUILT_IN_FUNCTION_EDEFAULT, oldUseBuiltInFunctionESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetUseBuiltInFunction() {
		return useBuiltInFunctionESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.SUBSTITUTION_RULE_TYPE__MATCH:
				return getMatch();
			case ParserPackage.SUBSTITUTION_RULE_TYPE__POSITIONS:
				return getPositions();
			case ParserPackage.SUBSTITUTION_RULE_TYPE__SUBSTITUTE:
				return getSubstitute();
			case ParserPackage.SUBSTITUTION_RULE_TYPE__SUBSTITUTION_EXTENSION_CLASS:
				return getSubstitutionExtensionClass();
			case ParserPackage.SUBSTITUTION_RULE_TYPE__TIME_FORMAT:
				return getTimeFormat();
			case ParserPackage.SUBSTITUTION_RULE_TYPE__USE_BUILT_IN_FUNCTION:
				return isUseBuiltInFunction() ? Boolean.TRUE : Boolean.FALSE;
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.SUBSTITUTION_RULE_TYPE__MATCH:
				setMatch((String)newValue);
				return;
			case ParserPackage.SUBSTITUTION_RULE_TYPE__POSITIONS:
				setPositions((String)newValue);
				return;
			case ParserPackage.SUBSTITUTION_RULE_TYPE__SUBSTITUTE:
				setSubstitute((String)newValue);
				return;
			case ParserPackage.SUBSTITUTION_RULE_TYPE__SUBSTITUTION_EXTENSION_CLASS:
				setSubstitutionExtensionClass((String)newValue);
				return;
			case ParserPackage.SUBSTITUTION_RULE_TYPE__TIME_FORMAT:
				setTimeFormat((String)newValue);
				return;
			case ParserPackage.SUBSTITUTION_RULE_TYPE__USE_BUILT_IN_FUNCTION:
				setUseBuiltInFunction(((Boolean)newValue).booleanValue());
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.SUBSTITUTION_RULE_TYPE__MATCH:
				setMatch(MATCH_EDEFAULT);
				return;
			case ParserPackage.SUBSTITUTION_RULE_TYPE__POSITIONS:
				setPositions(POSITIONS_EDEFAULT);
				return;
			case ParserPackage.SUBSTITUTION_RULE_TYPE__SUBSTITUTE:
				setSubstitute(SUBSTITUTE_EDEFAULT);
				return;
			case ParserPackage.SUBSTITUTION_RULE_TYPE__SUBSTITUTION_EXTENSION_CLASS:
				setSubstitutionExtensionClass(SUBSTITUTION_EXTENSION_CLASS_EDEFAULT);
				return;
			case ParserPackage.SUBSTITUTION_RULE_TYPE__TIME_FORMAT:
				setTimeFormat(TIME_FORMAT_EDEFAULT);
				return;
			case ParserPackage.SUBSTITUTION_RULE_TYPE__USE_BUILT_IN_FUNCTION:
				unsetUseBuiltInFunction();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.SUBSTITUTION_RULE_TYPE__MATCH:
				return MATCH_EDEFAULT == null ? match != null : !MATCH_EDEFAULT.equals(match);
			case ParserPackage.SUBSTITUTION_RULE_TYPE__POSITIONS:
				return POSITIONS_EDEFAULT == null ? positions != null : !POSITIONS_EDEFAULT.equals(positions);
			case ParserPackage.SUBSTITUTION_RULE_TYPE__SUBSTITUTE:
				return SUBSTITUTE_EDEFAULT == null ? substitute != null : !SUBSTITUTE_EDEFAULT.equals(substitute);
			case ParserPackage.SUBSTITUTION_RULE_TYPE__SUBSTITUTION_EXTENSION_CLASS:
				return SUBSTITUTION_EXTENSION_CLASS_EDEFAULT == null ? substitutionExtensionClass != null : !SUBSTITUTION_EXTENSION_CLASS_EDEFAULT.equals(substitutionExtensionClass);
			case ParserPackage.SUBSTITUTION_RULE_TYPE__TIME_FORMAT:
				return TIME_FORMAT_EDEFAULT == null ? timeFormat != null : !TIME_FORMAT_EDEFAULT.equals(timeFormat);
			case ParserPackage.SUBSTITUTION_RULE_TYPE__USE_BUILT_IN_FUNCTION:
				return isSetUseBuiltInFunction();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (match: ");
		result.append(match);
		result.append(", positions: ");
		result.append(positions);
		result.append(", substitute: ");
		result.append(substitute);
		result.append(", substitutionExtensionClass: ");
		result.append(substitutionExtensionClass);
		result.append(", timeFormat: ");
		result.append(timeFormat);
		result.append(", useBuiltInFunction: ");
		if (useBuiltInFunctionESet) result.append(useBuiltInFunction); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} //SubstitutionRuleTypeImpl
