/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GLALogger.java,v 1.4 2005/04/20 19:11:38 dnsmith Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.parsers;

import org.eclipse.hyades.logging.commons.Logger;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;

/**
 * This class extends org.eclipse.hyades.logging.commons.Logger
 * so that it only logs the Common Base Event message instead of the
 * whole Common Base Event.
 * 
 * @see org.apache.commons.logging.Log
 * @see org.apache.commons.logging.LogFactory
 * @see org.eclipse.hyades.logging.core.LoggingAgent
 * @see org.eclipse.hyades.logging.commons.Logger
 * @see org.eclipse.hyades.logging.commons.LoggerFactory
 */
public class GLALogger extends Logger {

    /**
     * Constructor to create a logger instance with a Logging Agent using the
     * parameter name.
     * 
     * NOTE: The default logging level is set to WARN until explicitly set.
     * 
     * @param name
     *            The name of the newly created logger.
     */
    public GLALogger(String name) {

        super(name);
 
    }

    /**
     * Logs the parameter <code>java.lang.Object</code> log record to the
     * Logging Agent with the same name as the logger if TRACE logging is
     * currently enabled.
     * 
     * If the log record is a CommonBaseEvent only the CommonBaseEvent message will be 
     * sent to the Logging Agent.  Otherwise it is assumed the record is a String.
     * 
     * @param record
     *            The log record to be logged to the Logging Agent.
     */
    public void trace(Object record) {

        if (isTraceEnabled()) {
        	if (record instanceof CommonBaseEvent) {
        		loggingAgent.write("glalog=" + ((CommonBaseEvent)record).getMsg());
        	}
        	else if (record instanceof String) {
        		loggingAgent.write((String)record);
        	}
        }
    }

    /**
     * Logs the parameter <code>java.lang.Object</code> log record and
     * <code>java.lang.Throwable</code> exception to the Logging Agent with
     * the same name as the logger if TRACE logging is currently enabled.
     * 
     * If the log record is a CommonBaseEvent only the CommonBaseEvent message will be 
     * sent to the Logging Agent.  Otherwise it is assumed the record is a String.
     * 
     * Only the parameter <code>java.lang.Object</code> log record is logged.
     * The <code>java.lang.Throwable</code> exception is ignored.
     * 
     * @param record
     *            The log record to be logged to the Logging Agent.
     * @param throwable
     *            The exception will be ignored
     */
    public void trace(Object record, Throwable throwable) {

        if (isTraceEnabled()) {
           	if (record instanceof CommonBaseEvent) {
        		loggingAgent.write("glalog=" + ((CommonBaseEvent)record).getMsg());
        	}
        	else if (record instanceof String) {
        		loggingAgent.write((String)record);
        	}
        }
    }

}