/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GLALoggerFactory.java,v 1.3 2005/02/16 22:20:55 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.parsers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.eclipse.hyades.logging.commons.LoggerFactory;

/**
 * This class extends org.eclipse.hyades.logging.commons.LoggerFactory
 * to instantiate the org.eclpise.hyades.logging.parsers.GLALogger class.
 * 
 * @see org.apache.commons.logging.LogFactory
 * @see org.eclipse.hyades.logging.commons.Logger
 * @see org.eclipse.hyades.logging.commons.LoggerFactory
 * @see org.eclipse.hyades.logging.parsers.GLALogger
 */
public class GLALoggerFactory extends LoggerFactory {

    /**
     * No-argument constructor.
     */
    public GLALoggerFactory() {
        super();
    }

    /**
     * Returns an instance of a non-null named
     * <code>org.eclipse.hyades.logging.parsers.GLALogger</code> based on the
     * parameter name.
     * <p>
     * Passing a <code>null</code> logger name results in a <code>null</code>
     * return value.
     * <p>
     * An instance of a named
     * <code>org.eclipse.hyades.logging.parsers.GLALogger</code> is created if no
     * named instance current exists or all instances have been released.
     * <p>
     * Once a named <code>org.eclipse.hyades.logging.parsers.GLALogger</code> is
     * created, the instance is cached for future calls to retrieve the same
     * named <code>org.eclipse.hyades.logging.parsers.GLALogger</code>.
     * <p>
     * The name of the <code>org.eclipse.hyades.logging.parsers.GLALogger</code>
     * uniquely identifies an instance of an
     * <code>org.eclipse.hyades.logging.parsers.GLALogger</code>. All subsequent
     * calls will return the same instance of the named
     * <code>org.eclipse.hyades.logging.parsers.GLALogger</code>.
     * <p>
     * 
     * @param loggerName
     *            The non-null name of the returned
     *            <code>org.eclipse.hyades.logging.parsers.GLALogger</code>
     *            instance.
     * @return A named <code>org.eclipse.hyades.logging.parsers.GLALogger</code>
     *         instance, otherwise <code>null</code> if the parameter logger
     *         name is <code>null</code>.
     * @exception LogConfigurationException
     *                if the named
     *                <code>org.eclipse.hyades.logging.parsers.GLALogger</code>
     *                instance could not be created.
     * @see org.apache.commons.logging.LogFactory#getInstance(java.lang.String)
     */
    public Log getInstance(String loggerName) throws LogConfigurationException {

        if (loggerName != null) {

            if (loggers.containsKey(loggerName)) { return (((Log) (loggers.get(loggerName)))); }

            GLALogger logger = new GLALogger(loggerName);

            loggers.put(loggerName, logger);

            return logger;
        }

        return null;
    }
}