package org.eclipse.hyades.logging.parsers;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LoggingParsersPlugin.java,v 1.5 2005/02/16 22:20:55 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;


public class LoggingParsersPlugin extends Plugin {
	// The shared instance.
    private static LoggingParsersPlugin instance = null;
    
	//Resource bundle.
	private static ResourceBundle resourceBundle;

    public LoggingParsersPlugin() {

		super();
		instance = this;
		try {
			resourceBundle = Platform.getResourceBundle(Platform.getBundle("org.eclipse.hyades.logging.parsers"));
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}

    }

    public static LoggingParsersPlugin getPlugin() {
        return instance;
    }

    public static ResourceBundle getResourceBundle() {
    	if (resourceBundle == null) {
    		try {
    			resourceBundle = Platform.getResourceBundle(Platform.getBundle("org.eclipse.hyades.logging.parsers"));
    		} catch (MissingResourceException x) {
    			resourceBundle = null;
    		}
    	}
    	return resourceBundle;
    }

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
	}

}