/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StatusMonitor.java,v 1.3 2005/02/16 22:20:55 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.parsers;

import org.apache.commons.logging.Log;

/**
 * This class is a runnable that checks the status of a log parser
 * at regular intervals and sends the status to a logging agent.
 */
public class StatusMonitor implements Runnable {

	// Class of the parser object
	private Class parserClass = null;
	
	// The parser object
	private Object parser = null;
	
	// The logging agent to write the status to.
	private Log statusLogger = null;
	
	/**
	 * Constructor with required parameters
	 * @param parser object that is doing the log parsing
	 * @param parserClass class of the parser object
	 * @param statusLogger logging agent to write the status to
	 */
	public StatusMonitor(Object parser, Class parserClass, Log statusLogger) {
		super();
		
		this.parser = parser;
		this.parserClass = parserClass;
		this.statusLogger = statusLogger;
	}

	/* (non-Javadoc)
	 * @see java.lang.Runnable#run()
	 */
	public void run() {
		String status = null;
		
		// Status checking loop.
		while (true) {
			try {
				// Get the status of the parsing object.
				status = (String)parserClass.getMethod("getStatus",null).invoke(parser, null);
			}
			catch (Exception e) {
				System.err.println("Exception occured when getting status: " + e.getMessage());
				status = null;
			}
			// write status string to status agent
			if (status != null) {
				statusLogger.trace(status);
			}
			
			// If this thread has been interrupted then quit the monitoring loop.
			if (Thread.interrupted()) {
				break;
			}
			
	   		/* Sleep for 2 seconds before checking the status again.
    		 * The parsing thread may interrupt this thread to indicate it is done so break
    		 * from the monitoring loop.
    		 */
            try {
            	Thread.sleep(2000);
            }
            catch (InterruptedException e) {
            	// Quit the monitoring loop if this thread has been interrupted
            	break;
            }
		}

	}

}
