/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProbekitPlugin.java,v 1.6 2005/02/16 22:21:28 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit;

import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.*;
import org.eclipse.core.resources.*;
import org.osgi.framework.BundleContext;

import java.util.*;

/**
 * The main plugin class to be used in the desktop.
 */
public class ProbekitPlugin extends AbstractUIPlugin {
	//The shared instance.
	private static ProbekitPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;
	
	/**
	 * The constructor.
	 */
	public ProbekitPlugin() {
		super();
		plugin = this;
	}

	/**
	 * Start method. Overrides base class start method. Gets the resource bundle
	 * for translations etcetera.
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		try {
			this.resourceBundle = Platform.getResourceBundle(this.getBundle());
		} catch (MissingResourceException x) {
			this.resourceBundle = null;
		}
	}
	
	/**
	 * Returns the shared instance.
	 */
	public static ProbekitPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getString(String key) {
		ResourceBundle bundle= ProbekitPlugin.getDefault().getResourceBundle();
		if (bundle == null) return key;
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
}
