/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JavaProcessExecutableObjectAdapter.java,v 1.16 2005/02/16 22:20:15 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.harness;

import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

/**
 * @author rduggan
 *
 * This is an adapter that knows how to configure the JavaProcessExecutorImpl
 * at runtime.
 */
public class JavaProcessExecutableObjectAdapter	implements IExecutableObjectAdapter {

	/**
	 * @see org.eclipse.hyades.execution.harness.IExecutableObjectAdapter#setupExecutableObject(org.eclipse.hyades.execution.core.IExecutableObject, org.eclipse.hyades.models.common.testprofile.TPFTestSuite, org.eclipse.hyades.models.common.testprofile.TPFTest)
	 */
	public void setupExecutableObject(IExecutableObject execObj, CFGClass rootResource, IImplementor theImplementor, TPFDeployment deployment)	throws ClassCastException {
			/* Read the classname of the test out of the test suite */
			String testID=theImplementor.getId();
			String testClass = theImplementor.getResource();
			final boolean DEBUG = false;
			
			// Get the number of users from the CFGInstance
			int nusers = 1;
			try {
				if ( rootResource instanceof TPFTestSuite)
				{
					if(((TPFTestSuite)rootResource).getInstances().isEmpty())
					{
						CFGInstance instance = Common_ConfigurationFactory.eINSTANCE.createCFGInstance();
						((TPFTestSuite)rootResource).getInstances().add(instance);
					}
					
					CFGInstance cfg = (CFGInstance) ((TPFTestSuite)rootResource).getInstances().get(0);
					nusers = cfg.getMaxCount();
				}
			} catch (Exception e) {
				nusers = 1;
			}
			
			String jvmArgs = ""; //$NON-NLS-1$
			
			if ( DEBUG )
				jvmArgs += "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=8005 "; //$NON-NLS-1$
			
			jvmArgs += "-Dhyades.loadtest.nusers=" + nusers + " "; //$NON-NLS-1$ //$NON-NLS-2$
			jvmArgs += "org.eclipse.hyades.test.java.runner.HyadesJUnitRunner "+testClass+" "; //$NON-NLS-1$ //$NON-NLS-2$
			jvmArgs += testID+" "+nusers; //$NON-NLS-1$
			
			// If we're running something other than a test suite, pass in the name of the 
			// test method we should call
			if ( !(rootResource instanceof ITestSuite))
				jvmArgs += " "+theImplementor.getLocation(); //$NON-NLS-1$
			
			((JavaProcessExecutableObjectStub)execObj).setArgs(jvmArgs);
			((JavaProcessExecutableObjectStub)execObj).setTestID(testID);
		    ((JavaProcessExecutableObjectStub)execObj).setSuiteID(rootResource.getId());
	}

}
