/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLExecutionDataProcessor.java,v 1.20 2005/06/22 14:25:45 sschneid Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.execution.harness;

import java.net.InetAddress;
import java.util.HashMap;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.internal.execution.local.common.DataServerListener;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.loaders.common.ExecutionContext;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;

/**
 * @author amathur
 * @author ejessee
 */
public class XMLExecutionDataProcessor
	extends XMLLoader
	implements DataServerListener, IExecutionHarnessDataProcessor2 {
		
	private final String START_TAG = "<EXECUTION>"; //$NON-NLS-1$
	private final String XML_VERSION_TAG = "<?xml version=\"1.0\"?>"; //$NON-NLS-1$
	public static final String IID = "org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor"; //$NON-NLS-1$
	private ITest test = null;
	private Agent controlAgent = null;
	private Process process = null;
	
	private static final HashMap contextMap = new HashMap();

	private String executionResultName;
	private boolean overrideExistingExcResult = false;
	private String executionResultLocation;
	
	/**
	 * XMLDataProcessor constructor comment.
	 */
	public XMLExecutionDataProcessor() 
	{
	 
		super((TRCMonitor) null);
		
	}
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLLoader#isIgnoredElement()
	 */
	protected boolean isIgnoredElement() {
		if (this.startDocument) {
			if (this.currentElementName == null) {
				return true;
			}
			if (this.currentElementName.equals("EXECUTION")) { //$NON-NLS-1$
				return true;
			}
			this.startDocument = false;
		}
		return false;
	}
	
	protected boolean isValidTag(String buf) {
		return (!(buf.startsWith(this.START_TAG) || buf.startsWith(this.XML_VERSION_TAG)));
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.local.common.DataServerListener#dataServerExited()
	 */
	public void dataServerExited() 
	{		
	    
		// Clean up the ExecutionContext
		final ExecutionContext eContext = (ExecutionContext) this.context.getCustomData().get(ExecutionContext.root);
		synchronized(eContext)
		{
			//if we are the last agent out, then we'll clean up the context.
			if(eContext.decrementAgentCount()==0)
			{
			    
		        contextMap.remove(XMLExecutionDataProcessor.this.executionResultLocation + "/" + //$NON-NLS-1$ 
		                XMLExecutionDataProcessor.this.executionResultName); 
		        
				//here we have a problem.  Because sometimes, there are still message streaming when the 
				//dataserver exits, we cannot clean up yet.  WE need to synchronized this.  
				//for now, we will just put in this less than optimal wait.  I think 3 seconds should be adequate time.
				Thread contextCleaner = new Thread()
				{
				    public void run() {
				        
			            try 
			            {
			                sleep(3000);
			            } 
			            catch (InterruptedException e) {}
			            
			            eContext.cleanUp(); 
				        
				    }
				
				
				};
				contextCleaner.setName("context cleanup"); //$NON-NLS-1$
				contextCleaner.start();
			}
		}
		cleanUp();
		
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IDataProcessor#incommingData(byte[], int, java.net.InetAddress)
	 */
	public void incommingData(byte[] buffer, int length, InetAddress peer) {
		try {
			super.loadEvent(buffer, length);
		}
		catch (InvalidXMLException e) {
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IDataProcessor#incommingData(char[], int, java.net.InetAddress)
	 */
	public void incommingData(char[] buffer, int length, InetAddress peer) {
		byte[] newBuffer = new byte[length];
		for (int i = 0; i < length; i++) {
			newBuffer[i] = (byte) buffer[i];
		}
		this.incommingData(newBuffer, newBuffer.length, peer);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IDataProcessor#invalidDataType(byte[], int, java.net.InetAddress)
	 */
	public void invalidDataType(byte[] data, int length, InetAddress peer) {
		// No use of this method	
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.core.IDataProcessor#waitingForData()
	 */
	public void waitingForData() 
	{
		// No use of this method		
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.harness.TestExecutionHarnessDataProcessor#init(org.eclipse.hyades.models.common.facades.behavioral.ITest, org.eclipse.hyades.models.common.configuration.CFGLocation, java.lang.String, java.lang.String)
	 */
	public void init()
	{

			//		Specify the ignore for an unexpected event
			 this.defaultLoader =  new IgnoredXMLFragmentLoader();
		
			
			 if(!(getTest() instanceof TPFTestSuite))
			 	return;
			 	
		     // Create an execution context & add it to the Hierarchy Context					
			// This will create the root execution result/history for this execution
			 ExecutionContext eContext = null;
			 
			 /*
			  * Lock down context map for gets and puts since it is static and shared amongst
			  * all class instances
			  */
			 synchronized (XMLExecutionDataProcessor.contextMap) {
			     			     
			     eContext = (ExecutionContext)contextMap.get(this.executionResultLocation+"/"+this.executionResultName); //$NON-NLS-1$
			 
		         TPFTestSuite suite = (TPFTestSuite)getTest();
			     
			     if(eContext==null)
			     {
			         eContext = new ExecutionContext(suite, suite.getId(), this.executionResultLocation, this.executionResultName, this.overrideExistingExcResult);
			         contextMap.put(this.executionResultLocation+"/"+this.executionResultName,eContext); //$NON-NLS-1$
			     }
			 }
		     eContext.incrementAgentCount();
		     // Add the ExecutionContext to the HierarchyContext
		     this.context.getCustomData().put(ExecutionContext.root, eContext);

	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.harness.IExecutionDataProcessor#getConfigElement()
	 */
	public IConfigurationElement getConfigElement()
	{
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.harness.IExecutionDataProcessor#getID()
	 */
	public String getID()
	{
		return IID;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.harness.IExecutionDataProcessor#getName()
	 */
	public String getName()
	{
		return getClass().getName();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.harness.IExecutionDataProcessor#setConfigElement(org.eclipse.core.runtime.IConfigurationElement)
	 */
	public void setConfigElement(IConfigurationElement theElement)
	{

	}

	/**
	 * @return
	 */
	public ITest getTest()
	{
		return this.test;
	}

		
	/**
	 * @return
	 */
	public Agent getControlAgent()
	{
		return this.controlAgent;
	}

	/**
	 * @param agent
	 */
	public void setControlAgent(Agent agent)
	{
		this.controlAgent = agent;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.harness.IExecutionDataProcessor#setInitData(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public void setInitData(
		ITest test,
		String hostName,
		String executionResultName,
		String executionResultLocation,
		String portNumber)
	{
		this.setInitData(test, hostName, executionResultName, executionResultLocation, false, portNumber);
		

	}
		
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.harness.IExecutionHarnessDataProcessor#setInitData(org.eclipse.hyades.models.common.facades.behavioral.ITest, java.lang.String, java.lang.String, boolean, java.lang.String, java.lang.String)
	 */
	public void setInitData(ITest theTest, String hostName,
			String executionResultName, String executionResultLocation, 
			boolean overwriteExistingResults, String portNumber) 
	{
		this.test= theTest;
		this.executionResultName = executionResultName;
		this.overrideExistingExcResult = overwriteExistingResults;
		this.executionResultLocation = executionResultLocation;
	}
	
	/**
	 * @return
	 */
	public Process getProcess()
	{
		return this.process;
	}

	/**
	 * @param process
	 */
	public void setProcess(Process process)
	{
		this.process = process;
	}

}
