/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionAdapterUtilities.java,v 1.7 2005/02/16 22:20:15 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.execution.harness.util;

import java.util.HashMap;

import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.harness.IExecutableObjectAdapter;
import org.eclipse.hyades.execution.harness.IExecutionDeploymentAdapter;
import org.eclipse.hyades.execution.harness.IExecutionDeploymentAdapterExtended;
import org.eclipse.hyades.execution.harness.IExecutionEnvironmentAdapter;
import org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor;
import org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;

/**
 * @author jtoomey
 */
public class ExecutionAdapterUtilities {
	
	public static Object getAdapterInstance(String executionComponentType, String testType, 
			boolean bStandalone, HashMap testTypemap, ISystemUtility systemUtility ) throws ClassNotFoundException
		{
			Object temp = testTypemap.get(executionComponentType);
			if ( temp != null && temp instanceof HashMap )
			{
				HashMap execCompMap = (HashMap) temp;
				temp = execCompMap.get(testType);
				try {
					if ( bStandalone )
					{
						if ( temp != null && temp instanceof String )
						{
							return Class.forName((String)temp).newInstance();
						}
					}
					else
					{
						if ( temp != null && temp instanceof ConfigurationElement)
						{
							return ((ConfigurationElement)temp).createExecutableExtension("class"); //$NON-NLS-1$
						}
					}
				}
				catch ( Exception accessExc )
				{
				}
				
			}
			String msg = systemUtility.getString("EXEC_NOT_FOUND_ERR_"); //$NON-NLS-1$
			msg = StringUtil.change(msg, "%1", executionComponentType); //$NON-NLS-1$
			msg = StringUtil.change(msg, "%2", testType); //$NON-NLS-1$
			
			// We couldn't find the right execution component
			throw new ClassNotFoundException(msg);
		}

		public static boolean adaptExecutableObject(IExecutableObject executableObject, CFGClass rootResource, IImplementor theImplementor, boolean bStandalone, String testType, TPFDeployment deployment, StringBuffer bufError, ISystemUtility systemUtility, HashMap testTypeMap) {
			// Call out into an adapter class to configure this execution 
			// environment for this test
			IExecutableObjectAdapter execObjAdapter = null;
			try {
				execObjAdapter = (IExecutableObjectAdapter) getAdapterInstance("EXECUTABLE_OBJECT_ADAPTER", testType, bStandalone, testTypeMap, systemUtility); //$NON-NLS-1$
			}
			catch ( Exception accessExc )
			{
				systemUtility.logError(accessExc);			
				bufError.append(StringUtil.change(systemUtility.getString("EXEC_ENV_ERR_"), "%1", testType)); //$NON-NLS-1$ //$NON-NLS-2$
				return false;					
			}
			if ( execObjAdapter != null )
				execObjAdapter.setupExecutableObject(executableObject, rootResource, theImplementor, deployment);
			
			if(executableObject instanceof JavaProcessExecutableObjectStub)
			 {
				JavaProcessExecutableObjectStub stub = (JavaProcessExecutableObjectStub)executableObject;
				String args = stub.getArgs();
				args+=" "+XMLExecutionDataProcessor.IID; //$NON-NLS-1$
				stub.setArgs(args);
			 }
				
			return true;
		}

		public static boolean adaptExecutionEnvironment(IExecutionEnvironment exeEnvironment, CFGClass rootResource, IImplementor theImplementor, boolean bStandalone, String testType, TPFDeployment deployment, StringBuffer bufError, ISystemUtility systemUtility, HashMap testTypeMap) {
			// Call out into an adapter class to configure this execution 
			// environment for this test
			
			IExecutionEnvironmentAdapter envAdapter = null;
			try {
				envAdapter = (IExecutionEnvironmentAdapter)getAdapterInstance("EXECUTION_ENVIRONMENT_ADAPTER", testType, bStandalone, testTypeMap, systemUtility); //$NON-NLS-1$
			}
			catch ( Exception accessExc )
			{
				systemUtility.logError(accessExc);			
				bufError.append(StringUtil.change(systemUtility.getString("EXEC_ENV_ERR_"), "%1", testType)); //$NON-NLS-1$ //$NON-NLS-2$
				return false;				
			}
			if ( envAdapter != null )
				envAdapter.setupExecutionEnvironment(exeEnvironment, rootResource, theImplementor, deployment);
				
			return true;
		}

		public static boolean adaptExecutionDeployment(INode node, TPFDeployment deployment, boolean bStandalone, String testType, StringBuffer bufError, ISystemUtility systemUtility, HashMap testTypeMap)
		{
		    IExecutionDeploymentAdapter deployAdapter = null;
			try {
				deployAdapter = (IExecutionDeploymentAdapter)getAdapterInstance("EXECUTION_DEPLOYMENT_ADAPTER", testType, bStandalone, testTypeMap, systemUtility); //$NON-NLS-1$
			}
			catch ( Exception accessExc )
			{
			    systemUtility.logError(accessExc);			
				// TODO
				//bufError.append(StringUtil.change(systemUtility.getString("EXEC_ENV_ERR_"), "%1", testType));
				return false;				
			}
			if ( deployAdapter != null ) {
			    if (deployAdapter instanceof IExecutionDeploymentAdapterExtended) {
			        ((IExecutionDeploymentAdapterExtended) deployAdapter).deployTestAssets(node, deployment, bStandalone, bufError);
			        return (bufError.length() == 0); // an exception was accumulated while deploying test assets
			    } else {
			        deployAdapter.deployTestAssets(node, deployment, bStandalone);
			    }
			}
				
			return true;
		}	
		
		public static boolean adaptExecutionDeploymentCleanup(INode node, TPFDeployment deployment, boolean bStandalone, String testType, StringBuffer bufError, ISystemUtility systemUtility, HashMap testTypeMap)
		{
		    IExecutionDeploymentAdapter deployAdapter = null;
			try {
				deployAdapter = (IExecutionDeploymentAdapter)getAdapterInstance("EXECUTION_DEPLOYMENT_ADAPTER", testType, bStandalone, testTypeMap, systemUtility); //$NON-NLS-1$
			}
			catch ( Exception accessExc )
			{
			    systemUtility.logError(accessExc);			
				// TODO
				//bufError.append(StringUtil.change(systemUtility.getString("EXEC_ENV_ERR_"), "%1", testType));
				return false;				
			}
			if ( deployAdapter != null ) {
			    if (deployAdapter instanceof IExecutionDeploymentAdapterExtended) {
			        ((IExecutionDeploymentAdapterExtended) deployAdapter).cleanUpTestAssets(node, deployment, bStandalone, bufError);
			        return (bufError.length() == 0); // an exception was accumulated while cleaning up test assets
			    } else {
			        deployAdapter.cleanUpTestAssets(node, deployment, bStandalone);
			    }
			}
				
			return true;
		}	
}
