/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISystemUtility.java,v 1.4 2005/02/16 22:20:15 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.harness.util;

import java.util.ResourceBundle;

/**
 * This interfaces defines a small set of services execution that may be provided
 * by an Eclipse plugin, or may be provided by a standalone implementation.  Among 
 * these services are locating and retrieving strings from the correct resource 
 * bundle for the current locale, and logging errors.
 *  
 * @author jtoomey
 */
public interface ISystemUtility {
	public abstract ResourceBundle getResourceBundle();
	public abstract String getString(String key);
	public abstract void logError(Throwable exc);
}