/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestManualPropertySource.java,v 1.4 2005/02/16 22:21:49 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.manual.internal;

import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.adapter.CMNNamedElementPropertySource;
import org.eclipse.hyades.test.ui.adapter.INamedElementPropertySource;
import org.eclipse.hyades.test.ui.navigator.IExecutionResultProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestCaseProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestComponentProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.ui.views.properties.IPropertySource;

/**
 * @author jgout
 */
public class TestManualPropertySource implements INamedElementPropertySource {

	public IPropertySource getPropertySource(Object adaptableObject) {
		if(adaptableObject instanceof ITestSuiteProxyNode) {
			return new CMNNamedElementPropertySource(((ITestSuiteProxyNode)adaptableObject).getTestSuite());
		} else if(adaptableObject instanceof ITestCaseProxyNode) {
			return new CMNNamedElementPropertySource(((ITestCaseProxyNode)adaptableObject).getTestCase());
		} else if(adaptableObject instanceof ITestComponentProxyNode) {
			return new CMNNamedElementPropertySource(((ITestComponentProxyNode)adaptableObject).getTestComponent());
		} else if(adaptableObject instanceof IExecutionResultProxyNode) {
			return new CMNNamedElementPropertySource(((IExecutionResultProxyNode)adaptableObject).getExecutionResult());
		} else {
			return new CMNNamedElementPropertySource((CMNNamedElement)adaptableObject);
		}
	}
}
