/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ManualGenerator.java,v 1.4 2005/05/03 22:16:47 bjiang Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.internal.codegen;

import java.io.ByteArrayInputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.internal.codegen.Generator;
import org.eclipse.hyades.test.common.internal.codegen.Helper;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class ManualGenerator 
extends Generator
{
	/**
	 * @see org.eclipse.hyades.test.common.internal.codegen.Generator#generateFile(org.eclipse.hyades.models.common.facades.behavioral.ITestSuite, org.eclipse.core.resources.IFile, org.eclipse.core.runtime.IProgressMonitor)
	 */
	protected void generateFile(ITestSuite testSuite, IFile file, IProgressMonitor monitor)
	throws Exception
	{
		// bugzilla_93098 specifically use UTF-8 when generating test file to work for multi-byte characters.
		file.create(new ByteArrayInputStream(generateScript(testSuite).getBytes(CHARSET_UTF8)), true, monitor);
		file.setCharset(CHARSET_UTF8, monitor);
	}
	
	public static String generateScript(ITestSuite testSuite)
	{
		GenTestSuite genTestSuite = new GenTestSuite();
		String script = genTestSuite.generate(testSuite, new Helper());
		
		String extraChars = "\t\t" + genTestSuite.NL;
		if(script.startsWith(extraChars))
			script = script.substring(extraChars.length());
		
		return script;
	}
}
