/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ManualTestSuiteNewWizard.java,v 1.3 2005/02/16 22:21:49 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.manual.internal.wizard;

import org.eclipse.jface.dialogs.IDialogSettings;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.TestCommon;
import org.eclipse.hyades.test.common.internal.wizard.TestSuiteNewWizard;
import org.eclipse.hyades.test.manual.TestManualImages;
import org.eclipse.hyades.test.manual.TestManualPlugin;

/**
 * Extends the TestSuiteNewWizard to create the Http Test Suite.
 * 
 * @author marcelop
 * @since 1.0.2
 */
public class ManualTestSuiteNewWizard 
extends TestSuiteNewWizard
{
	/**
	 * Constructor for TestSuiteNewWizard
	 */
	public ManualTestSuiteNewWizard()
	{
		super();
		setWindowTitle(TestManualPlugin.getString("WIZ_TST_SUITE_TTL"));
		setDefaultPageImageDescriptor(TestManualImages.INSTANCE.getImageDescriptor(TestManualImages.IMG_WIZBAN_NEW_MANUAL_TESTSUITE));

		IDialogSettings dialogSettings = TestManualPlugin.getInstance().getDialogSettings();
		IDialogSettings settings = dialogSettings.getSection("ManualTestSuiteNewWizard");
		if(settings == null)
			settings = dialogSettings.addNewSection("ManualTestSuiteNewWizard");
		setDialogSettings(settings);
	}

	/**
	 * Returns the type for the test suite created by this wizard.
	 * @return String
	 */
	protected String getType()
	{
		return TestCommon.MANUAL_TEST_SUITE_TYPE;
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.wizard.TestSuiteNewWizard#registerResource(org.eclipse.hyades.models.common.facades.behavioral.ITestSuite)
	 */
	protected void registerResource(ITestSuite testSuite)
	{
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		getLocationPage().setTitle(TestManualPlugin.getString("WIZ_TST_SUITE_TTL"));
		getLocationPage().setDescription(TestManualPlugin.getString("WIZ_TST_SUITE_GEN_PG_LOC_DSC"));
		
		getAttributeWizardPage().setTitle(TestManualPlugin.getString("WIZ_TST_SUITE_TTL"));
		getAttributeWizardPage().setDescription(TestManualPlugin.getString("WIZ_TST_SUITE_GEN_PG_ATT_DSC"));
		
		super.addPages();
	}	
}
