package org.eclipse.hyades.logging.events.cbe;

import java.io.Serializable;

import org.eclipse.emf.ecore.EObject;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ComponentIdentification.java,v 1.3 2005/02/16 22:20:39 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Component Identification</b></em>'.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0 
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getApplication <em>Application</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getComponent <em>Component</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getComponentType <em>Component Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getComponentIdType <em>Component Id Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getExecutionEnvironment <em>Execution Environment</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getInstanceId <em>Instance Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getLocation <em>Location</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getLocationType <em>Location Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getProcessId <em>Process Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getSubComponent <em>Sub Component</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getThreadId <em>Thread Id</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getComponentIdentification()
 * @model 
 * @generated
 */
public interface ComponentIdentification extends EObject, Serializable {

    /**
     * <p>
     * Well-known type for the '<em><b>Component Id Type</b></em>' attribute.
     * </p>
     * 
     * @see #getComponentIdType() 
     */
    String COMPONENT_ID_TYPE_PRODUCT_NAME = "ProductName";

    /**
     * <p>
     * Well-known type for the '<em><b>Component Id Type</b></em>' attribute.
     * </p>
     * 
     * @see #getComponentIdType() 
     */
    String COMPONENT_ID_TYPE_DEVICE_NAME = "DeviceName";

    /**
     * <p>
     * Well-known type for the '<em><b>Component Id Type</b></em>' attribute.
     * </p>
     * 
     * @see #getComponentIdType() 
     */
    String COMPONENT_ID_TYPE_SYSTEM_NAME = "SystemName";

    /**
     * <p>
     * Well-known type for the '<em><b>Component Id Type</b></em>' attribute.
     * </p>
     * 
     * @see #getComponentIdType() 
     */
    String COMPONENT_ID_TYPE_SERVICE_NAME = "ServiceName";

    /**
     * <p>
     * Well-known type for the '<em><b>Component Id Type</b></em>' attribute.
     * </p>
     * 
     * @see #getComponentIdType() 
     */
    String COMPONENT_ID_TYPE_PROCESS = "Process";

    /**
     * <p>
     * Well-known type for the '<em><b>Component Id Type</b></em>' attribute.
     * </p>
     * 
     * @see #getComponentIdType() 
     */
    String COMPONENT_ID_TYPE_APPLICATION = "Application";

    /**
     * <p>
     * Well-known type for the '<em><b>Component Id Type</b></em>' attribute.
     * </p>
     * 
     * @see #getComponentIdType() 
     */
    String COMPONENT_ID_TYPE_UNKNOWN = "Unknown";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_UNKNOWN = "Unknown";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_IPV4 = "IPV4";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_IPV6 = "IPV6";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_NWA = "NWA";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_ISDN = "ISDN";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_ICD = "ICD";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_OID_OSI = "OID-OSI";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_DIAL = "Dial";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_HWA = "HWA";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_HID = "HID";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_X25 = "X25";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_DCC = "DCC";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_SNA = "SNA";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_IPX = "IPX";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_E_164 = "E.164";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_HOSTNAME = "Hostname";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_FQ_HOSTNAME = "FQHostname";

    /**
     * <p>
     * Well-known type for the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * 
     * @see #getLocationType() 
     */
    String LOCATION_TYPE_DEVICE_NAME = "Devicename";

    /**
     * <p>
     * Returns the value of the '<em><b>Application</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Application</em>' attribute.
     * @see #setApplication(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getComponentIdentification_Application()
     * @model 
     * @generated
     */
    String getApplication();

    /**
     * <p>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getApplication <em>Application</em>}' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Application</em>' attribute.
     * @see #getApplication()
     * @generated
     */
    void setApplication(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Component</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Component</em>' attribute.
     * @see #setComponent(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getComponentIdentification_Component()
     * @model required="true"
     * @generated
     */
    String getComponent();

    /**
     * <p>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getComponent <em>Component</em>}' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Component</em>' attribute.
     * @see #getComponent()
     * @generated
     */
    void setComponent(String value);

    /**
     * Returns the value of the '<em><b>Component Type</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <p>
     * If the meaning of the '<em>Component Type</em>' attribute isn't clear,
     * there really should be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Component Type</em>' attribute.
     * @see #setComponentType(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getComponentIdentification_ComponentType()
     * @model required="true"
     * @generated
     */
    String getComponentType();

    /**
     * <p>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getComponentType <em>Component Type</em>}' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Component Type</em>' attribute.
     * @see #getComponentType()
     * @generated
     */
    void setComponentType(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Component Id Type</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Component Id Type</em>' attribute.
     * @see #setComponentIdType(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getComponentIdentification_ComponentIdType()
     * @model required="true"
     * @generated
     */
    String getComponentIdType();

    /**
     * <p>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getComponentIdType <em>Component Id Type</em>}' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Component Id Type</em>' attribute.
     * @see #getComponentIdType()
     * @generated
     */
    void setComponentIdType(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Execution Environment</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Execution Environment</em>' attribute.
     * @see #setExecutionEnvironment(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getComponentIdentification_ExecutionEnvironment()
     * @model 
     * @generated
     */
    String getExecutionEnvironment();

    /**
     * <p>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getExecutionEnvironment <em>Execution Environment</em>}' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Execution Environment</em>' attribute.
     * @see #getExecutionEnvironment()
     * @generated
     */
    void setExecutionEnvironment(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Instance Id</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Instance Id</em>' attribute.
     * @see #setInstanceId(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getComponentIdentification_InstanceId()
     * @model 
     * @generated
     */
    String getInstanceId();

    /**
     * <p>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getInstanceId <em>Instance Id</em>}' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Instance Id</em>' attribute.
     * @see #getInstanceId()
     * @generated
     */
    void setInstanceId(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Location</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Location</em>' attribute.
     * @see #setLocation(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getComponentIdentification_Location()
     * @model required="true"
     * @generated
     */
    String getLocation();

    /**
     * <p>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getLocation <em>Location</em>}' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Location</em>' attribute.
     * @see #getLocation()
     * @generated
     */
    void setLocation(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Location Type</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Location Type</em>' attribute.
     * @see #setLocationType(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getComponentIdentification_LocationType()
     * @model required="true"
     * @generated
     */
    String getLocationType();

    /**
     * <p>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getLocationType <em>Location Type</em>}' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Location Type</em>' attribute.
     * @see #getLocationType()
     * @generated
     */
    void setLocationType(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Process Id</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Process Id</em>' attribute.
     * @see #setProcessId(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getComponentIdentification_ProcessId()
     * @model 
     * @generated
     */
    String getProcessId();

    /**
     * <p>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getProcessId <em>Process Id</em>}' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Process Id</em>' attribute.
     * @see #getProcessId()
     * @generated
     */
    void setProcessId(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Sub Component</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Sub Component</em>' attribute.
     * @see #setSubComponent(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getComponentIdentification_SubComponent()
     * @model required="true"
     * @generated
     */
    String getSubComponent();

    /**
     * <p>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getSubComponent <em>Sub Component</em>}' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Sub Component</em>' attribute.
     * @see #getSubComponent()
     * @generated
     */
    void setSubComponent(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Thread Id</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Thread Id</em>' attribute.
     * @see #setThreadId(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getComponentIdentification_ThreadId()
     * @model 
     * @generated
     */
    String getThreadId();

    /**
     * <p>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ComponentIdentification#getThreadId <em>Thread Id</em>}' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Thread Id</em>' attribute.
     * @see #getThreadId()
     * @generated
     */
    void setThreadId(String value);

    /**
     * <p>
     * Checks whether the contents of this object conform to the
     * CBE specification.
     * </p>
     *
     * @throws ValidationException 
     *                       if the object does not follow the 
     *                       CBE specification.
     */
    void validate() throws ValidationException;

	/**
	 * Resets the object's properties to their initial (e.g. null) state.
	 * 
	 * All components are initialized to either zero or null.
	 * 
	 * @since 1.0
	 */
	void init();
} // ComponentIdentification
