package org.eclipse.hyades.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DependencySituation.java,v 1.3 2005/02/16 22:20:39 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Dependency Situation</b></em>'.
 * <P>
 * The DependencySituation deals with the situations that components produce
 * to say that they cannot find some component or feature they need.  This
 * category includes messages about not finding the version of the component 
 * that was expected.  Messages that say a resource was not found or that an 
 * application or subsystem that was unavailable also fall into this category.
 * Existing messages include words like "could not find", and "no such component", 
 * for example:
 * </P>
 * <P>
 * <code>
 * WSVR0017E: Error encountered binding the J2EE resource, Pet Store JMS Queue 
 * Connection Factory, as jms/queue/QueueConnectionFactory from resources.xml 
 * no resource binder found
 * </code>
 * </P>
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1 
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.DependencySituation#getDependencyDisposition <em>Dependency Disposition</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getDependencySituation()
 * @model 
 * @generated
 */
public interface DependencySituation extends SituationType {
    /**
     * <p>
     * Returns the value of the '<em><b>Dependency Disposition</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Dependency Disposition</em>' attribute.
     * @see #setDependencyDisposition(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getDependencySituation_DependencyDisposition()
     * @model required="true"
     * @generated
     */
    String getDependencyDisposition();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.DependencySituation#getDependencyDisposition <em>Dependency Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * This property specifies the dependency  disposition of a feature of a 
     * component that caused the situation to be reported.
     * The featureDisposition is a string with the following set of values:
     * <UL>
     * <LI>MET</LI>
     * <LI>NOT MET</LI>
     * </UL>
     * </p>
     * <p>
     * This is a <em>required</em> property and once it is set it <em>must not</em> change. The 
     * string length for this property <em>must not</em> exceed 64 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Dependency Disposition</em>' attribute.
     * @see #getDependencyDisposition()
     * @generated
     */
    void setDependencyDisposition(String value);

	/**
	 * Resets the object's properties to their initial (e.g. null) state.
	 * 
	 * All components are initialized to either zero or null.
	 * 
	 * @since 1.0
	 */
	void init();
} // DependencySituation
