package org.eclipse.hyades.logging.events.cbe;

import org.eclipse.emf.ecore.EFactory;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EventFactory.java,v 1.4 2005/02/16 22:20:39 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * <p>
 * It provides a create method for each non-abstract class of the model.
 * </p>
 * 
 * @author Denilson Nastacio
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
* <!-- end-user-doc -->
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage
 * @generated
 */
public interface EventFactory extends EFactory {
    /**
     * The singleton instance of the factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EventFactory eINSTANCE = new org.eclipse.hyades.logging.events.cbe.impl.EventFactoryImpl();

    /**
     * Sets the <code>ContentHandler</code> associated with this 
     * event factory instance.
     * <p>
     * <code>ContentHandler</code>s associated with this event factory 
     * instance are assigned to each newly create event instance.
     * <p>
     *
     * @param contentHandler The new <code>ContentHandler</code> associated with this event factory instance.
     */
    void setContentHandler(ContentHandler contentHandler);

    /**
     * Gets the <code>ContentHandler</code> associated with this 
     * event factory instance.
     * <p>
     * <code>ContentHandler</code>s associated with this event factory 
     * instance are assigned to each newly create event instance.
     * <p>
     *
     * @return The <code>ContentHandler</code> associated with this event factory instance, otherwise null.
     */
    ContentHandler getContentHandler();

    /**
     * Sets the complete event configuration flag for this event factory instance.
     * <p>
     * The complete event configuration flag instructs the event factory instance to 
     * automatically complete newly create event instances using the <code>ContentHandler</code> 
     * associated with this event factory instance, if any.
     * <p>
     * If the complete event configuration flag is false, the event factory will
     * not automatically complete newly create event instances.
     * <p>
     * By default, the complete event configuration flag is false.
     * <p>
     * 
     * @param completeEvent The complete event configuration flag.
     */
    void setCompleteEvent(boolean completeEvent);

    /**
     * Gets the complete event configuration flag for this event factory instance.
     * <p>
     * The complete event configuration flag instructs the event factory instance to 
     * automatically complete newly create event instances using the <code>ContentHandler</code> 
     * associated with this event factory instance, if any.
     * <p>
     * If the complete event configuration flag is false, the event factory will
     * not automatically complete newly create event instances.
     * <p>
     * By default, the complete event configuration flag is false.
     * <p>
     * 
     * @return True if the complete event configuration flag is set, otherwise false.
     */
    boolean getCompleteEvent();

    /**
     * <p>
     * Returns the package supported by this factory.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the package supported by this factory.
     * @generated
     */
    EventPackage getEventPackage();

    /**
     * <p>
     * Returns a new object of class '<em>Associated Event</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Associated Event</em>'.
     * @generated
     */
    AssociatedEvent createAssociatedEvent();

    /**
     * <p>
     * Returns a new object of class '<em>Association Engine</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Association Engine</em>'.
     * @generated
     */
    AssociationEngine createAssociationEngine();

    /**
     * <p>
     * Returns a new object of class '<em>Available Situation</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Available Situation</em>'.
     * @generated
     */
    AvailableSituation createAvailableSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Common Base Event</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Common Base Event</em>'.
     * @generated
     */
    CommonBaseEvent createCommonBaseEvent();

    /**
     * <p>
     * Returns a new object of class '<em>Common Base Event</em>'.
     * </p>
     * <P>
     * @param extensionName  the extension name for the newly returned event or null.
    
     * @return a new object of class '<em>Common Base Event</em>'.
     */
    CommonBaseEvent createCommonBaseEvent(String extensionName);

    /**
     * <p>
     * Returns a new object of class '<em>Common Base Event</em>'.
     * </p>
     * @param extensionName  the extension name for the newly returned event or null.
     * @param creationTime   the creation time, in xsd:dateTime format, for the
     *                       newly created event or -1.
     * 
     * @return a new object of class '<em>Common Base Event</em>'.
     */
    CommonBaseEvent createCommonBaseEvent(String extensionName, long creationTime);

    /**
     * <p>
     * Returns a new object of class '<em>Common Base Event</em>'.
     * </p>
     * @param severity         the severity of the event being created or -1
     * @param situation        the situation of the event being created or null
     * @param msg              the msg of the CommonBaseEvent created or null 
     * 
     * @return a new object of class '<em>Common Base Event</em>'.
     */
    CommonBaseEvent createCommonBaseEvent(short severity, Situation situation, String msg);

    /**
     * <p>
     * Returns a new object of class '<em>Common Base Event</em>'.
     * </p>
     * @param severity         the severity of the event being created or -1
     * @param situation        the situation of the event being created or null
     * @param msgCatalogId     the msgCatalogId of the MsgDataElement of the CommonBaseEvent
     *                         being created or null
     * @param msgCatalogTokens the msgCatalogTokens of the MsgDataElement of the CommonBaseEvent
     *                         being created or null
     * @param msgId            the msgId of the MsgDataElement of the CommonBaseEvent being created
     *                         or null
     * @param msg              the msg of the CommonBaseEvent created or null 
     * 
     * @return a new object of class '<em>Common Base Event</em>'.
     */
    CommonBaseEvent createCommonBaseEvent(short severity, Situation situation, String msgCatalogId, String[] msgCatalogTokens, String msgId, String msg);

    /**
     * <p>
     * Returns a new object of class '<em>Common Base Event</em>'.
     * </p>
     * @param severity         the severity of the event being created or -1
     * @param reporterCompId   the reporter component Id of the event being created or null
     * @param sourceCompId     the source component Id of the event being created or null
     * @param situation        the situation of the event being created or null
     * @param msg              the msg of the CommonBaseEvent created or null 
     * 
     * @return a new object of class '<em>Common Base Event</em>'.
     */
    CommonBaseEvent createCommonBaseEvent(short severity, ComponentIdentification reporterCompId, ComponentIdentification sourceCompId, Situation situation, String msg);

    /**
     * <p>
     * Returns a new object of class '<em>Common Base Event</em>'.
     * </p>
     * @param severity         the severity of the event being created or -1
     * @param reporterCompId   the reporter component Id of the event being created or null
     * @param sourceCompId     the source component Id of the event being created or null
     * @param situation        the situation of the event being created or null
     * @param msgCatalogId     the msgCatalogId of the MsgDataElement of the CommonBaseEvent
     *                         being created or null
     * @param msgCatalogTokens the msgCatalogTokens of the MsgDataElement of the CommonBaseEvent
     *                         being created or null
     * @param msgId            the msgId of the MsgDataElement of the CommonBaseEvent being created
     *                         or null
     * @param msg              the msg of the CommonBaseEvent created or null 
     * 
     * @return a new object of class '<em>Common Base Event</em>'.
     */
    CommonBaseEvent createCommonBaseEvent(short severity, ComponentIdentification reporterCompId, ComponentIdentification sourceCompId, Situation situation, String msgCatalogId, String[] msgCatalogTokens, String msgId, String msg);

    /**
     * <p>
     * Returns a new object of class '<em>Component Identification</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Component Identification</em>'.
     * @generated
     */
    ComponentIdentification createComponentIdentification();

    /**
     * <p>
     * Returns a new object of class '<em>Configure Situation</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Configure Situation</em>'.
     * @generated
     */
    ConfigureSituation createConfigureSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Connect Situation</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Connect Situation</em>'.
     * @generated
     */
    ConnectSituation createConnectSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Context Data Element</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Context Data Element</em>'.
     * @generated
     */
    ContextDataElement createContextDataElement();

    /**
     * <p>
     * Returns a new object of class '<em>Create Situation</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Create Situation</em>'.
     * @generated
     */
    CreateSituation createCreateSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Dependency Situation</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Dependency Situation</em>'.
     * @generated
     */
    DependencySituation createDependencySituation();

    /**
     * <p>
     * Returns a new object of class '<em>Destroy Situation</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Destroy Situation</em>'.
     * @generated
     */
    DestroySituation createDestroySituation();

    /**
     * <p>
     * Returns a new object of class '<em>Extended Data Element</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Extended Data Element</em>'.
     * @generated
     */
    ExtendedDataElement createExtendedDataElement();

    /**
     * <p>
     * Returns a new object of class '<em>Feature Situation</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Feature Situation</em>'.
     * @generated
     */
    FeatureSituation createFeatureSituation();

    /**
     * Produces a globally unique identifier according to the 
     * Open Group algorithm. 
     * <P>
     * The algorithm is described in
     * {@link <a href="http://www.opengroup.org/dce/info/draft-leach-uuids-guids-01.txt">http://www.opengroup.org/dce/info/draft-leach-uuids-guids-01.txt</a>}
     * </p>
     * <P>
     * The produced identifier is always prefixed with "CE" so that it does 
     * not clash with identifiers produced by another application using the 
     * same algorithm.
     * </p>
     * 
     * @return               a globally unique identifier according to the 
     *                       algorithm above.
     */
    String createGlobalInstanceId();

    /**
     * <p>
     * Returns a new object of class '<em>Msg Catalog Token</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Msg Catalog Token</em>'.
     * @generated
     */
    MsgCatalogToken createMsgCatalogToken();

    /**
     * <p>
     * Returns a new object of class '<em>Msg Data Element</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Msg Data Element</em>'.
     * @generated
     */
    MsgDataElement createMsgDataElement();

    /**
     * <p>
     * Returns a new object of class '<em>Other Situation</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Other Situation</em>'.
     * @generated
     */
    OtherSituation createOtherSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Report Situation</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Report Situation</em>'.
     * @generated
     */
    ReportSituation createReportSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Request Situation</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Request Situation</em>'.
     * @generated
     */
    RequestSituation createRequestSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Situation</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Situation</em>'.
     * @generated
     */
    Situation createSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Start Situation</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Start Situation</em>'.
     * @generated
     */
    StartSituation createStartSituation();

    /**
     * <p>
     * Returns a new object of class '<em>Stop Situation</em>'.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return a new object of class '<em>Stop Situation</em>'.
     * @generated
     */
    StopSituation createStopSituation();

} //EventFactory
