package org.eclipse.hyades.logging.events.cbe;

import java.io.Serializable;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExtendedDataElement.java,v 1.3 2005/02/16 22:20:39 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Extended Data
 * Element</b></em>'.
 * <P>
 * The ExtendedDataElement allows for application-supplied name-type-value 
 * collections to be specified for extensibility purposes.  This is the 
 * mechanism by which other attributes not specified in the CommonBaseEvent 
 * data model can be added.  Collections specified here are assumed to be 
 * product specific data.
 * </p>
 * <p>
 * The named properties can be filtered, searched or referenced by the 
 * correlation rules.  The name is user defined, however, the nonexclusive 
 * reserved keywords are as follows: 
 * <UL>
 * <LI>RawData - This keyword is indicative of "as is" data that is meaningful 
 * only to the producer of the data (typically proprietary data).  It may be 
 * in any form, including binary.  It is intended to allow the data to be 
 * retrieved verbatim and to support tools that understand the format of 
 * the context.</LI>
 * <LI>RootHeader - This keyword  is intended to identify the root 
 * ExtendedDataElement for a hierarchy of ExtendedDataElements that are 
 * defined by dataRefs.</LI>
 * <LI>LoggingLevel - This keyword is intended to specify the level of 
 * logging represeted as an integer.  Higher numbers <em>must</em> include 
 * all the granularity of lower numbers.</LI> 
 * </P>
 * 
 * @author Denilson Nastacio
 * @author Andrea Chiavegatto
 * @version 1.0.1
 * @since 1.0
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getExtendedDataElement()
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getHexValue <em>Hex Value</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValues <em>Values</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getChildren <em>Children</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getExtendedDataElement()
 * @model 
 * @generated
 */
public interface ExtendedDataElement extends EObject, Serializable {

    /**
     * Indicates that type for an extended data element that does not have a value.
     *
     * @see #getType()
     */
    String TYPE_NO_VALUE = "noValue";

    /**
     * Indicates that type for an extended data element that does not have a value.
     *
     * @see #getType()
     */
    int TYPE_NO_VALUE_VALUE = 0;

    /**
     * Indicates a byte value for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_BYTE = "byte";

    /**
     * Indicates a byte value for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_BYTE_VALUE = 1;

    /**
     * Indicates a short value for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_SHORT = "short";

    /**
     * Indicates a short value for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_SHORT_VALUE = 2;

    /**
     * Indicates an integer value for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_INT = "int";

    /**
     * Indicates an integer value for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_INT_VALUE = 3;

    /**
     * Indicates a long value for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_LONG = "long";

    /**
     * Indicates a long value for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_LONG_VALUE = 4;

    /**
     * Indicates a float value for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_FLOAT = "float";

    /**
     * Indicates a float value for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_FLOAT_VALUE = 5;

    /**
     * Indicates a double value for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_DOUBLE = "double";

    /**
     * Indicates a double value for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_DOUBLE_VALUE = 6;

    /**
     * Indicates a string value for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_STRING = "string";

    /**
     * Indicates a string value for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_STRING_VALUE = 7;

    /**
     * Indicates a date time value for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_DATE_TIME = "dateTime";

    /**
     * Indicates a date time value for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_DATE_TIME_VALUE = 8;

    /**
     * Indicates a boolean value for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_BOOLEAN = "boolean";

    /**
     * Indicates a boolean value for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_BOOLEAN_VALUE = 9;

    /**
     * Indicates an array of byte values for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_BYTE_ARRAY = "byteArray";

    /**
     * Indicates an array of byte values for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_BYTE_ARRAY_VALUE = 10;

    /**
     * Indicates an array of short values for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_SHORT_ARRAY = "shortArray";

    /**
     * Indicates an array of short values for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_SHORT_ARRAY_VALUE = 11;

    /**
     * Indicates an array of integer values for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_INT_ARRAY = "intArray";

    /**
     * Indicates an array of integer values for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_INT_ARRAY_VALUE = 12;

    /**
     * Indicates an array of long values for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_LONG_ARRAY = "longArray";

    /**
     * Indicates an array of long values for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_LONG_ARRAY_VALUE = 13;

    /**
     * Indicates an array of float values for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_FLOAT_ARRAY = "floatArray";

    /**
     * Indicates an array of float values for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_FLOAT_ARRAY_VALUE = 14;

    /**
     * Indicates an array of double values for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_DOUBLE_ARRAY = "doubleArray";

    /**
     * Indicates an array of double values for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_DOUBLE_ARRAY_VALUE = 15;

    /**
     * Indicates an array of string values for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_STRING_ARRAY = "stringArray";

    /**
     * Indicates an array of string values for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_STRING_ARRAY_VALUE = 16;

    /**
     * Indicates an array of date time values for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_DATE_TIME_ARRAY = "dateTimeArray";

    /**
     * Indicates an array of date time values for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_DATE_TIME_ARRAY_VALUE = 17;

    /**
     * Indicates an array of boolean values for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_BOOLEAN_ARRAY = "booleanArray";

    /**
     * Indicates an array of boolean values for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_BOOLEAN_ARRAY_VALUE = 18;

    /**
     * Indicates an hex binary value for the extended data element.
     *
     * @see #getType()
     */
    String TYPE_HEX_BINARY = "hexBinary";

    /**
     * Indicates an hex binary value for the extended data element.
     *
     * @see #getType()
     */
    int TYPE_HEX_BINARY_VALUE = 19;

    /**
     * <p>
     * Helper method to return a named child <code>ExtendedDataElement</code>
     * from the list of children <code>ExtendedDataElement</code>s.
     * </p>
     *
     * @param name the name of the child <code>ExtendedDataElement</code>
     *
     * @return a list of <code>ExtendedDataElement</code> objects.
     */
    EList getChildren(String name);

    /**
     * Returns the value of the '<em><b>Children</b></em>' containment reference list.
     * The list contents are of type {@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement}.
     * <!-- begin-user-doc -->
     * <p>
     * Contains other extendedDataElements to specify a structured list of  
     * extendedDataElements.  This list allows a reporter to create a hierarchy 
     * of extendedDataElements for a specific CommonBaseEvent.
     * This is an <em>optional</em> property.
     * </P>
     * <P><b>Important:</b> This method is automatically generated and returns
     * an <code>EList</code>, which inherits from 
     * <code>{@link java.util.List}</code>
     * </P>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Children</em>' containment reference list.
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getExtendedDataElement_Children()
     * @model type="org.eclipse.hyades.logging.events.cbe.ExtendedDataElement" containment="true"
     * @generated
     */
    EList getChildren();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getHexValue <em>Hex Value</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * The hexValue is an array of characters that holds the data for any 
     * other data type or complexType not in the supported types described above.
     * The hexValue and the values properties are mutually exclusive.  
     * Only one of these properties shall be defined.  
     * This is an <em>optional</em> property.
     * </P>
     * <p>
     * The value is represented according to the
     * <A HREF="http://www.w3.org/TR/2001/REC-xmlschema-2-20010502/#hexBinary">
     * XML schema hexBinary definition</A>.
     * </p>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Hex Value</em>' attribute.
     * @see #getHexValue()
     * @generated
     */
    void setHexValue(String value);

    /**
     * Returns the value of the '<em><b>Hex Value</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * The value is represented according to the
     * <A HREF="http://www.w3.org/TR/2001/REC-xmlschema-2-20010502/#hexBinary">
     * XML schema hexBinary definition</A>.
     * </p>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Hex Value</em>' attribute.
     * @see #setHexValue(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getExtendedDataElement_HexValue()
     * @model 
     * @generated
     */
    String getHexValue();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getName <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * The name of the extended data element.  This name <em>must</em> be unique with 
     * respect to all other fields at the same level of extendedDataElement 
     * hierarchy, however, there may exist a child with the same name at 
     * different level or hierarchy.
     * </p>
     * <p>
     * This is a <em>required</em> property.  The string length for this property 
     * <em>must not</em> exceed 64 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Name</em>' attribute.
     * @see #getName()
     * @generated
     */
    void setName(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Name</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Name</em>' attribute.
     * @see #setName(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getExtendedDataElement_Name()
     * @model required="true"
     * @generated
     */
    String getName();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getType <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <p>
     * The data type of the values specified in the values property.
     * </p>
     * <p>
     * Valid types are as follows:
     * <UL>
     * <LI>byte, short, int, long, float, double</LI>
     * <LI>string</LI>
     * <LI>dateTime</LI>
     * <LI>byteArray, shortArray, intArray, longArray, floatArray, doubleArray</LI>
     * <LI>stringArray</LI>
     * <LI>dateTimeArray</LI>
     * <LI>hexBinary</LI>
     * <LI>boolean, booleanArray</LI>
     * <LI>noValue</LI>
     * </UL>
     * <br>
     * These are the only valid data types for the ExtendedDataElement type.
     * </p>
     * <p>
     * The default value is "string".  This is a <em>required</em> property.  The string 
     * length for this property <em>must not</em> exceed 64 characters.
     * </p>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Type</em>' attribute.
     * @see #getType()
     * @generated
     */
    void setType(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Type</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Type</em>' attribute.
     * @see #setType(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getExtendedDataElement_Type()
     * @model required="true"
     * @generated
     */
    String getType();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getType <em>Type</em>}' attribute.
     * <P>
     * The value must be one of the 
     * <code>ExtendedDataElement.TYPE_&lt;type&gt;_VALUE</code>
     * constants.
     * </p>
     * 
     * @param value the new value of the '<em>Type</em>' attribute.
     * 
     * @see #getType()
     * @see #getTypeAsInt()
     */
    void setTypeAsInt(int value);

    /**
     * Returns the value of the '<em><b>Type</b></em>' attribute.
     * <P>
     * The value is represented through one of the 
     * <code>ExtendedDataElement.TYPE_&lt;type&gt;_VALUE</code>
     * constants.
     * </p>
     * 
     * @return the value of the '<em>Type</em>' attribute.
     * @see #setType(String)
     * @see #setTypeAsInt(int)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getExtendedDataElement_Type()
     */
    int getTypeAsInt();

    /**
     * Removes all values that this event is referencing 
     */
    void clearValues();

    /**
     * Returns the value of the '<em><b>Values</b></em>' attribute list.
     * The list contents are of type {@link java.lang.String}.
     * <!-- begin-user-doc -->
     * <P>
     * The array of values for this extended data element represented as a 
     * string of the specified type, excluding hexBinary.  hexBinary values 
     * <em>must</em> be defined using the hexValue property.  
     * </p>
     * <p>
     * The hexValue and the values properties are mutually exclusive.  
     * Only one of these properties shall be defined.  This is an <em>optional</em> 
     * property.  The string length for a value <em>must not</em> exceed 1024 
     * characters.
     * </P>
     * <P>
     * <b>Important:</b> This method is automatically generated and returns
     * an <code>EList</code>, which inherits from 
     * <code>{@link java.util.List}</code>
     * </P>
     * <!-- end-user-doc -->
     * @return the value of the '<em>Values</em>' attribute list.
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getExtendedDataElement_Values()
     * @model type="java.lang.String" unique="false"
     * @generated
     */
    EList getValues();

    /**
     * The array of values for this extended data element as a string representation
     * of the type specified above, excluding hexBinary.  hexBinary values MUST be 
     * defined using the hexValue property.  This is an OPTIONAL property.
     * 
     * @throws InvalidExtendedDataElementTypeException if the extended data element is a hexBinary data type.
     * @param String[] the values to set
     */
    void setValues(String[] values);

    /**
     * Sets the value of the extended data element as a byte value.
     *
     * <p>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_BYTE}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsByte(byte value);

    /**
     * Sets the value of the extended data element as an array of bytes.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_BYTE_ARRAY}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsByteArray(byte[] value);

    /**
     * <p>
     * Returns the value of the extended data element cast as a byte value.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_BYTE}.
     */
    byte getValuesAsByte();

    /**
     * <p>
     * Returns the values of the extended data element cast as byte values.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_BYTE_ARRAY}.
     */
    byte[] getValuesAsByteArray();

    /**
     * Sets the value of the extended data element as a boolean value.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_BOOLEAN}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsBoolean(boolean value);

    /**
     * Sets the value of the extended data element as an array of boolean 
     * values.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_BOOLEAN_ARRAY}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsBooleanArray(boolean[] value);

    /**
     * <p>
     * Returns the value of the extended data element cast as a boolean value.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_BOOLEAN}.
     */
    boolean getValuesAsBoolean();

    /**
     * <p>
     * Returns the values of the extended data element cast as boolean values.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_BOOLEAN_ARRAY}.
     */
    boolean[] getValuesAsBooleanArray();

    /**
     * Sets the value of the extended data element as a date time value.
     * <P>
     * The values are represented according to the
     * <A HREF="http://www.w3.org/TR/2001/REC-xmlschema-2-20010502/#dateTime">
     * XML schema dateTime definition</A>.
     * </p>
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_DATE_TIME}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsDate(String value);

    /**
     * Sets the value of the extended data element as an array of date time
     * values.
     * <P>
     * The values are represented according to the
     * <A HREF="http://www.w3.org/TR/2001/REC-xmlschema-2-20010502/#dateTime">
     * XML schema dateTime definition</A>.
     * </p>
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_DATE_TIME_ARRAY}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsDateArray(String[] value);

    /**
      * Sets the value of the extended data element as a date/time value.
      * <P>
      * The values are represented according to the
      * <A HREF="http://www.w3.org/TR/2001/REC-xmlschema-2-20010502/#dateTime">
      * XML schema dateTime definition</A>.
      * </p>
      * <P>
      * It also changes the '<em><b>Type</b></em>' attribute to {@link
      * #TYPE_DATE_TIME}.
      * </p>
      *
      * @param value the new value for the extended data element.
      */

    void setValuesAsDateAsLong(long value);

    /**
     * Sets the value of the extended data element as an array of date/time
     * values.
     * <P>
     * The values are represented according to the
     * <A HREF="http://www.w3.org/TR/2001/REC-xmlschema-2-20010502/#dateTime">
     * XML schema dateTime definition</A>.
     * </p>
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_DATE_TIME_ARRAY}.
     * </p>
     *
     * @param values the new value for the extended data element.
     */
    void setValuesAsDateAsLongArray(long[] values);

    /**
     * <p>
     * Returns the value of the extended data element cast as a date/time
     * value.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_DATE_TIME}.
     */
    long getValuesAsDateAsLong();

    /**
     * Returns the value of the extended data element cast as a date/time
     * value.
     * <P>
     * The value is represented according to the
     * <A HREF="http://www.w3.org/TR/2001/REC-xmlschema-2-20010502/#dateTime">
     * XML schema dateTime definition</A>.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_DATE_TIME}.
     */
    String getValuesAsDate();

    /**
     * <p>
     * Returns the values of the extended data element cast as date/time
     * values.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_DATE_TIME_ARRAY}.
     */
    long[] getValuesAsDateAsLongArray();

    /**
     * Returns the value of the extended data element cast as a date/time
     * values.
     * <P>
     * The values are represented according to the
     * <A HREF="http://www.w3.org/TR/2001/REC-xmlschema-2-20010502/#dateTime">
     * XML schema dateTime definition</A>.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_DATE_TIME_ARRAY}.
     */
    String[] getValuesAsDateArray();

    /**
     * Sets the value of the extended data element as a double value.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_DOUBLE}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsDouble(double value);

    /**
     * Sets the value of the extended data element as an array of double values.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_DOUBLE_ARRAY}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsDoubleArray(double[] value);

    /**
     * <p>
     * Returns the value of the extended data element cast as a double value.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_DOUBLE}.
     */
    double getValuesAsDouble();

    /**
     * <p>
     * Returns the values of the extended data element cast as double values.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_DOUBLE_ARRAY}.
     */
    double[] getValuesAsDoubleArray();

    /**
     * Sets the value of the extended data element as a float value.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_FLOAT}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsFloat(float value);

    /**
     * Sets the value of the extended data element as an array of float values.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_FLOAT_ARRAY}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsFloatArray(float[] value);

    /**
     * <p>
     * Returns the value of the extended data element cast as a float value.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_FLOAT}.
     */
    float getValuesAsFloat();

    /**
     * <p>
     * Returns the values of the extended data element cast as float values.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_FLOAT_ARRAY}.
     */
    float[] getValuesAsFloatArray();

    /**
     * Sets the value of the extended data element as a int value.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_INT}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsInt(int value);

    /**
     * Sets the value of the extended data element as an array of integer values.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_INT_ARRAY}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsIntArray(int[] value);

    /**
     * <p>
     * Returns the value of the extended data element cast as an integer value.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_INT}.
     */
    int getValuesAsInt();

    /**
     * <p>
     * Returns the values of the extended data element cast as integer values.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_INT_ARRAY}.
     */
    int[] getValuesAsIntArray();

    /**
     * Sets the value of the extended data element as a long value.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_LONG}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsLong(long value);

    /**
     * Sets the value of the extended data element as an array of long values.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_LONG_ARRAY}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsLongArray(long[] value);

    /**
     * <p>
     * Returns the value of the extended data element cast as a long value.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_LONG}.
     */
    long getValuesAsLong();

    /**
     * <p>
     * Returns the values of the extended data element cast as long values.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_LONG_ARRAY}.
     */
    long[] getValuesAsLongArray();

    /**
     * Sets the value of the extended data element as a short value.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_SHORT}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsShort(short value);

    /**
     * Sets the value of the extended data element as an array of short values.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_SHORT_ARRAY}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsShortArray(short[] value);

    /**
     * <p>
     * Returns the value of the extended data element cast as a short value.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_SHORT}.
     */
    short getValuesAsShort();

    /**
     * <p>
     * Returns the values of the extended data element cast as short values.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_SHORT_ARRAY}.
     */
    short[] getValuesAsShortArray();

    /**
     * Sets the value of the extended data element as a string value.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_STRING}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsString(String value);

    /**
     * Sets the value of the extended data element as an array of string values.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_STRING_ARRAY}.
     * </p>
     *
     * @param value the new value for the extended data element.
     */
    void setValuesAsStringArray(String[] value);

    /**
     * <p>
     * Returns the value of the extended data element cast as a string value.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_STRING}.
     */
    String getValuesAsString();

    /**
     * <p>
     * Returns the values of the extended data element cast as string values.
     * </p>
     *
     * @return the value of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_STRING_ARRAY}.
     */
    String[] getValuesAsStringArray();

    /**
     * <p>
     * Returns the hexValue of the extended data element cast as byte array
     * values.
     * </p>
     *
     * @return the hexValue of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_HEX_BINARY}.
     */
    byte[] getHexValueAsByteArray();

    /**
     * <p>
     * Returns the hexValue of the extended data element cast as char array
     * values.
     * </p>
     *
     * @return the hexValue of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_HEX_BINARY}.
     */
    char[] getHexValueAsCharArray();

    /**
     * Sets the hexValue of the extended data element as an array of bytes.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_HEX_BINARY}.
     * </p>
     *
     * @param value the new hexValue for the extended data element.
     */
    void setHexValueAsByteArray(byte[] value);

    /**
     * Sets the hexValue of the extended data element as an array of chars.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_HEX_BINARY}.
     * </p>
     *
     * @param value the new hexValue for the extended data element.
     */
    void setHexValueAsCharArray(char[] value);

    /**
     * Adds a new child <code>ExtendedDataElement</code> to this object.
     *
     * @param extendedDataElement the new child extended data element.
     * @return                    a reference to the child extended data element added to this object.
     * @see #getChildren()
     */
    ExtendedDataElement addChild(ExtendedDataElement child);

    /**
     * Removes all child ExtenedDataElements that this event is referencing 
     */
    void clearChildren();

    /**
     * Remove a named child extended data element that this event is referencing 
     * 
     * @param name the name of the child element to be removed
     */
    void removeChildren(String name);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object without
     * any values adds it to the list of extended data elements for this
     * object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChild(String name);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the
     * value passed as parameter and adds it to the list of extended data
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param type           represents the data type for the new
     *                       extended data element. Refer to the
     *                       <code>ExtendedDataElement.TYPE_&lt;type&gt;_VALUE</code>
     *                       constants for valid types.
     * @param value          the value for the new extended data element.
     *
     * @throws IllegalArgumentException
     *                       if the <code>type</code> parameter is not one
     *                       of the constants defined in
     *                       <code>ExtendedDataElement.TYPE_&lt;type&gt;_VALUE</code>
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChild(String name, int type, String value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param type           represents the data type for the new
     *                       extended data element. Refer to the
     *                       <code>ExtendedDataElement.TYPE_&lt;type&gt;_VALUE</code>
     *                       constants for valid types.
     * @param values         the array of values for the new extended data
     *                       element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     *
     * @throws IllegalArgumentException
     *                       if the <code>type</code> parameter is not one
     *                       of the constants defined in
     *                       <code>ExtendedDataElement.TYPE_&lt;type&gt;_VALUE</code>
     */
    ExtendedDataElement addChild(String name, int type, String[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the
     * value passed as parameter and adds it to the list of extended data
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          the value for the new extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChild(String name, String value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>String</code> values for the
     *                       new extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChild(String name, String[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>boolean</code> values for the new
     *                        extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithBooleanArrayValue(String name, boolean[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the
     * value passed as parameter and adds it to the list of extended data
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          the value for the new extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithBooleanValue(String name, boolean value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>byte</code> values for the new
     *                        extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithByteArrayValue(String name, byte[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the
     * value passed as parameter and adds it to the list of extended data
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          the value for the new extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithByteValue(String name, byte value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     * <p>
     * The values correspond to a date time string according to the
     * <A HREF="http://www.w3.org/TR/2001/REC-xmlschema-2-20010502/#dateTime">
     * XML schema dateTime definition</A>.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>String</code> instances
     *                        representing the date time values for the  new
     *                        extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithDateArrayValue(String name, String[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the
     * value passed as parameter and adds it to the list of extended data
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          number of milliseconds since January 1, 1970 UTC;
     *                        representing the date time value for the new
     *                       extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithDateAsLongValue(String name, long value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the
     * value passed as parameter and adds it to the list of extended data
     * elements for this object.
     * </p>
     * <p>
     * The value corresponds to a date time string according to the
     * <A HREF="http://www.w3.org/TR/2001/REC-xmlschema-2-20010502/#dateTime">
     * XML schema dateTime definition</A>.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          representation of the date time value for the  new
     *                        extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithDateValue(String name, String value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>long</code> values for the new
     *                        extended data element. Each
     *                        value corresponds to the number of milliseconds
     *                        since January 1, 1970 UTC.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithDatesAsLongValue(String name, long[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>double</code> values for the new
     *                        extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithDoubleArrayValue(String name, double[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the
     * value passed as parameter and adds it to the list of extended data
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value the <code>double</code> value that the new
     *        <code>ExtendedDataElement</code> will contain.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithDoubleValue(String name, double value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>float/code> values for the new
     *                        extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithFloatArrayValue(String name, float[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the
     * value passed as parameter and adds it to the list of extended data
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          the value for the new extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithFloatValue(String name, float value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>int</code> values for the new
     *                        extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithIntArrayValue(String name, int[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the
     * value passed as parameter and adds it to the list of extended data
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          the value for the new extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithIntValue(String name, int value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>long</code> values for the new
     *                        extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithLongArrayValue(String name, long[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the
     * value passed as parameter and adds it to the list of extended data
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          the value for the new extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithLongValue(String name, long value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object with the values
     * passed as parameters and adds it to the list of extended data elements
     * for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param values         the array of <code>short</code> values for the new
     *                        extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithShortArrayValue(String name, short[] values);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the
     * value passed as parameter and adds it to the list of extended data
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          the value for the new extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithShortValue(String name, short value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the
     * value passed as parameter and adds it to the list of extended data
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          the value for the new extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithHexValue(String name, String value);

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     * <p>
     * It creates an <code>ExtendedDataElement</code> object containing the
     * value passed as parameter and adds it to the list of extended data
     * elements for this object.
     * </p>
     *
     * @param name           the name for the new extended data element.
     * @param value          the value for the new extended data element.
     *
     * @return               a reference to the extended data element added
     *                       to this object.
     */
    ExtendedDataElement addChildWithHexValueAsByteArray(String name, byte[] value);

    /**
     * <p>
     * Checks whether the contents of this object conforms to the CBE
     * specification.
     * </p>
     *
     * @throws ValidationException if the object does not follow the  CBE
     *         specification.
     */
    void validate() throws ValidationException;

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    void init();
}
// ExtendedDataElement
