package org.eclipse.hyades.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StopSituation.java,v 1.3 2005/02/16 22:20:39 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Stop Situation</b></em>'.
 * <P>
 * The StopSituation deals with the shutdown process for a component.  Message
 * that indicate that a component has begun to stop, that it has stopped, or 
 * that the stopping process has failed all fall into this category.  Existing 
 * messages include words like "stop", "stopping", "stopped", "completed", and "exiting", 
 * for example:
 * </P>
 * <code>
 * WSVR0220I: Application stopped: {0}
 * <br>
 * WSVR0102E: An error occurred stopping, {0}
 * <br>
 * MSGS0657I: Stopping the MQJD JMS Provider
 * </code>
 * </P>
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.StopSituation#getSuccessDisposition <em>Success Disposition</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.StopSituation#getSituationQualifier <em>Situation Qualifier</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getStopSituation()
 * @model 
 * @generated
 */
public interface StopSituation extends SituationType {
    /**
     * <p>
     * Returns the value of the '<em><b>Success Disposition</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Success Disposition</em>' attribute.
     * @see #setSuccessDisposition(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getStopSituation_SuccessDisposition()
     * @model required="true"
     * @generated
     */
    String getSuccessDisposition();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.StopSituation#getSuccessDisposition <em>Success Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * This property specifies whether or not the operation that
     * caused the situation to be reported was successful.
     * The successDisposition is a string with the following set of values:
     * <UL>
     * <LI>SUCCESSFUL</LI>
     * <LI>UNSUCCESSFUL</LI>
     * </UL>
     * </p>
     * <p>
     * This is a <em>required</em> property and once it is set it <em>must not</em> change. 
     * The string length for this property <em>must not</em> exceed 64 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Success Disposition</em>' attribute.
     * @see #getSuccessDisposition()
     * @generated
     */
    void setSuccessDisposition(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Situation Qualifier</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Situation Qualifier</em>' attribute.
     * @see #setSituationQualifier(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getStopSituation_SituationQualifier()
     * @model required="true"
     * @generated
     */
    String getSituationQualifier();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.StopSituation#getSituationQualifier <em>Situation Qualifier</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * This property specifies the situation qualifiers that are representation 
     * of the parameters necessary to describe the situation.
     * The situationQualifier is a string with the following set of values:
     * <UL>
     * <LI>STOP INITIATED</LI>
     * <LI>ABORT INITIATED</LI>
     * <LI>PAUSE INITIATED</LI>
     * <LI>STOP COMPLETED</LI>
     * </UL>
     * </p>
     * <p>
     * This is a <em>required</em> property and once it is set it <em>must not</em> change. 
     * The string length for this property <em>must not</em> exceed 64 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Situation Qualifier</em>' attribute.
     * @see #getSituationQualifier()
     * @generated
     */
    void setSituationQualifier(String value);
    
	/**
	 * Resets the object's properties to their initial (e.g. null) state.
	 * 
	 * All components are initialized to either zero or null.
	 * 
	 * @since 1.0
	 */
	void init();
} // StopSituation
