package org.eclipse.hyades.logging.events.cbe.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.ListIterator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.logging.core.ISerializableAsXml;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;
import org.eclipse.hyades.logging.events.cbe.util.EventValidation;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CommonBaseEventImpl.java,v 1.21 2005/03/09 17:29:26 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Common Base Event</b></em>'.
 * <p>
 *
 * @author Denilson Nastacio
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0
 * @implements ISerializableAsXml
 * @implements Cloneable
* <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getCreationTime <em>Creation Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getGlobalInstanceId <em>Global Instance Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getElapsedTime <em>Elapsed Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getExtensionName <em>Extension Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getLocalInstanceId <em>Local Instance Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getMsg <em>Msg</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getPriority <em>Priority</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getRepeatCount <em>Repeat Count</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getSequenceNumber <em>Sequence Number</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getSeverity <em>Severity</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getVersion <em>Version</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getAny <em>Any</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getSituation <em>Situation</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getAssociatedEvents <em>Associated Events</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getContextDataElements <em>Context Data Elements</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getExtendedDataElements <em>Extended Data Elements</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getMsgDataElement <em>Msg Data Element</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getReporterComponentId <em>Reporter Component Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.CommonBaseEventImpl#getSourceComponentId <em>Source Component Id</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CommonBaseEventImpl extends SerializableImpl implements CommonBaseEvent, ISerializableAsXml, Cloneable {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = -7210409289362234835L;

    /**
     * Classname for trace/log
     */
    private static final String CLASS_NAME = CommonBaseEventImpl.class.getName();

    /**
     * Mediation handler associated to this factory.
     */
    transient private ContentHandler contentHandler;

    /**
     * Flag to denote if the associated content handler has been previously been invoked.
     */
    transient private boolean isComplete = false;

    /**
     * The default value of the '{@link #getCreationTime() <em>Creation Time</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getCreationTime()
     * @generated
     * @ordered
     */
    protected static final String CREATION_TIME_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getCreationTime() <em>Creation Time</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getCreationTime()
     * @generated
     * @ordered
     */
    protected String creationTime = CREATION_TIME_EDEFAULT;

    /**
     * This is true if the Creation Time attribute has been set.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    protected boolean creationTimeESet = false;

    /**
     * The default value of the '{@link #getGlobalInstanceId() <em>Global Instance Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getGlobalInstanceId()
     * @generated
     * @ordered
     */
    protected static final String GLOBAL_INSTANCE_ID_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getGlobalInstanceId() <em>Global Instance Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getGlobalInstanceId()
     * @generated
     * @ordered
     */
    protected String globalInstanceId = GLOBAL_INSTANCE_ID_EDEFAULT;

    /**
     * The default value of the '{@link #getElapsedTime() <em>Elapsed Time</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getElapsedTime()
     * @generated
     * @ordered
     */
    protected static final long ELAPSED_TIME_EDEFAULT = 0L;

    /**
     * The cached value of the '{@link #getElapsedTime() <em>Elapsed Time</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getElapsedTime()
     * @generated
     * @ordered
     */
    protected long elapsedTime = ELAPSED_TIME_EDEFAULT;

    /**
     * This is true if the Elapsed Time attribute has been set.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    protected boolean elapsedTimeESet = false;

    /**
     * The default value of the '{@link #getExtensionName() <em>Extension Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getExtensionName()
     * @generated
     * @ordered
     */
    protected static final String EXTENSION_NAME_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getExtensionName() <em>Extension Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getExtensionName()
     * @generated
     * @ordered
     */
    protected String extensionName = EXTENSION_NAME_EDEFAULT;

    /**
     * The default value of the '{@link #getLocalInstanceId() <em>Local Instance Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLocalInstanceId()
     * @generated
     * @ordered
     */
    protected static final String LOCAL_INSTANCE_ID_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getLocalInstanceId() <em>Local Instance Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLocalInstanceId()
     * @generated
     * @ordered
     */
    protected String localInstanceId = LOCAL_INSTANCE_ID_EDEFAULT;

    /**
     * The default value of the '{@link #getMsg() <em>Msg</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMsg()
     * @generated
     * @ordered
     */
    protected static final String MSG_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getMsg() <em>Msg</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMsg()
     * @generated
     * @ordered
     */
    protected String msg = MSG_EDEFAULT;

    /**
     * The default value of the '{@link #getPriority() <em>Priority</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getPriority()
     * @generated
     * @ordered
     */
    protected static final short PRIORITY_EDEFAULT = 0;

    /**
     * The cached value of the '{@link #getPriority() <em>Priority</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getPriority()
     * @generated
     * @ordered
     */
    protected short priority = PRIORITY_EDEFAULT;

    /**
     * This is true if the Priority attribute has been set.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    protected boolean priorityESet = false;

    /**
     * The default value of the '{@link #getRepeatCount() <em>Repeat Count</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getRepeatCount()
     * @generated
     * @ordered
     */
    protected static final short REPEAT_COUNT_EDEFAULT = 0;

    /**
     * The cached value of the '{@link #getRepeatCount() <em>Repeat Count</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getRepeatCount()
     * @generated
     * @ordered
     */
    protected short repeatCount = REPEAT_COUNT_EDEFAULT;

    /**
     * This is true if the Repeat Count attribute has been set.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    protected boolean repeatCountESet = false;

    /**
     * The default value of the '{@link #getSequenceNumber() <em>Sequence Number</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSequenceNumber()
     * @generated
     * @ordered
     */
    protected static final long SEQUENCE_NUMBER_EDEFAULT = 0L;

    /**
     * The cached value of the '{@link #getSequenceNumber() <em>Sequence Number</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSequenceNumber()
     * @generated
     * @ordered
     */
    protected long sequenceNumber = SEQUENCE_NUMBER_EDEFAULT;

    /**
     * This is true if the Sequence Number attribute has been set.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    protected boolean sequenceNumberESet = false;

    /**
     * The default value of the '{@link #getSeverity() <em>Severity</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSeverity()
     * @generated
     * @ordered
     */
    protected static final short SEVERITY_EDEFAULT = 0;

    /**
     * The cached value of the '{@link #getSeverity() <em>Severity</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSeverity()
     * @generated
     * @ordered
     */
    protected short severity = SEVERITY_EDEFAULT;

    /**
     * This is true if the Severity attribute has been set.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
    protected boolean severityESet = false;

    /**
     * The default value of the '{@link #getVersion() <em>Version</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getVersion()
     * @generated
     * @ordered
     */
    protected static final String VERSION_EDEFAULT = "1.0.1";

    /**
     * The cached value of the '{@link #getVersion() <em>Version</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getVersion()
     * @generated
     * @ordered
     */
    protected String version = VERSION_EDEFAULT;

    /**
     * The cached value of the '{@link #getAny() <em>Any</em>}' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getAny()
     * @generated
     * @ordered
     */
    protected EList any = null;

    /**
     * The cached value of the '{@link #getSituation() <em>Situation</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSituation()
     * @generated
     * @ordered
     */
    protected Situation situation = null;

    /**
     * The cached value of the '{@link #getAssociatedEvents() <em>Associated Events</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getAssociatedEvents()
     * @generated
     * @ordered
     */
    protected EList associatedEvents = null;

    /**
     * The cached value of the '{@link #getContextDataElements() <em>Context Data Elements</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getContextDataElements()
     * @generated
     * @ordered
     */
    protected EList contextDataElements = null;

    /**
     * The cached value of the '{@link #getExtendedDataElements() <em>Extended Data Elements</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getExtendedDataElements()
     * @generated
     * @ordered
     */
    protected EList extendedDataElements = null;

    /**
     * The cached value of the '{@link #getMsgDataElement() <em>Msg Data Element</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMsgDataElement()
     * @generated
     * @ordered
     */
    protected MsgDataElement msgDataElement = null;

    /**
     * The cached value of the '{@link #getReporterComponentId() <em>Reporter Component Id</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getReporterComponentId()
     * @generated
     * @ordered
     */
    protected ComponentIdentification reporterComponentId = null;

    /**
     * The cached value of the '{@link #getSourceComponentId() <em>Source Component Id</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSourceComponentId()
     * @generated
     * @ordered
     */
    protected ComponentIdentification sourceComponentId = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CommonBaseEventImpl() {
        super();        
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getAny() {
        if (any == null) {
            any = new EDataTypeEList(String.class, this, EventPackage.COMMON_BASE_EVENT__ANY);
        }
        return any;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getAssociatedEvents() {
        if (associatedEvents == null) {
            associatedEvents = new EObjectContainmentEList(AssociatedEvent.class, this, EventPackage.COMMON_BASE_EVENT__ASSOCIATED_EVENTS);
        }
        return associatedEvents;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setContentHandler(org.eclipse.hyades.logging.events.cbe.ContentHandler)
     */
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        isComplete = false;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getContentHandler()
     */
    public ContentHandler getContentHandler() {
        return contentHandler;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getContextDataElements() {
        if (contextDataElements == null) {
            contextDataElements = new EObjectContainmentEList(ContextDataElement.class, this, EventPackage.COMMON_BASE_EVENT__CONTEXT_DATA_ELEMENTS);
        }
        return contextDataElements;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getContextDataElements(String)
     */
    public EList getContextDataElements(String name) {

        ListIterator it = getContextDataElements().listIterator();
        BasicEList res = new BasicEList();
        ContextDataElement cde = null;
        
        while (it.hasNext()) {
            
            cde = ((ContextDataElement) (it.next()));

            if ((cde != null) && (cde.getName().equals(name))) {
                res.addUnique(cde);
            }
        }

        return res;
    }
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setCreationTime(String newCreationTime) {
        String oldCreationTime = creationTime;
        creationTime = newCreationTime;
        boolean oldCreationTimeESet = creationTimeESet;
        creationTimeESet = true;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__CREATION_TIME, oldCreationTime, creationTime, !oldCreationTimeESet));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getCreationTime() {
        return creationTime;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setCreationTimeAsLong(long)
     *
     * Converts a long representing UTC in milliseconds to the XML Schema
     * datetime format (CCYY-MM-DDThh:mm:ssZ)
     *
     * @param inDateTime The date in milliseconds since 1970-01-01T00:00:00Z
    
     */
    public void setCreationTimeAsLong(long inDateTime) {
        setCreationTime(EventHelpers.longToDate(inDateTime));
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getCreationTimeAsLong()
     *
     * Converts the creationTime from a string in XML Schema datetime
     * format (CCYY-MM-DDThh:mm:ss) to a long representing the
     * milliseconds since 1970-01-01T00:00:00
     */
    public long getCreationTimeAsLong() {
        
        long result = 0;

        if(isSetCreationTime()){

            try {
	            result = EventHelpers.dateToLong(getCreationTime());
	        }
	        catch (IllegalArgumentException e) {
	            throw new IllegalStateException(getCreationTime() + " is not a valid xsd:dateTime string");
	        }
        }
        
        return result;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setElapsedTime(long newElapsedTime) {
        long oldElapsedTime = elapsedTime;
        elapsedTime = newElapsedTime;
        boolean oldElapsedTimeESet = elapsedTimeESet;
        elapsedTimeESet = true;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__ELAPSED_TIME, oldElapsedTime, elapsedTime, !oldElapsedTimeESet));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public long getElapsedTime() {
        return elapsedTime;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getExtendedDataElements() {
        if (extendedDataElements == null) {
            extendedDataElements = new EObjectContainmentEList(ExtendedDataElement.class, this, EventPackage.COMMON_BASE_EVENT__EXTENDED_DATA_ELEMENTS);
        }
        return extendedDataElements;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#getExtendedDataElements(String)
     */
    public EList getExtendedDataElements(String name) {
        
        ListIterator it = getExtendedDataElements().listIterator();
        BasicEList res = new BasicEList();
        ExtendedDataElement ede = null;
        
        while (it.hasNext()) {
             
            ede = ((ExtendedDataElement) (it.next()));

            if ((ede != null) && (ede.getName().equals(name))) {
                res.addUnique(ede);
            }
        }

        return res;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setExtensionName(String newExtensionName) {
        String oldExtensionName = extensionName;
        extensionName = newExtensionName;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__EXTENSION_NAME, oldExtensionName, extensionName));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getExtensionName() {
        return extensionName;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setGlobalInstanceId(String newGlobalInstanceId) {
        String oldGlobalInstanceId = globalInstanceId;
        globalInstanceId = newGlobalInstanceId;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__GLOBAL_INSTANCE_ID, oldGlobalInstanceId, globalInstanceId));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getGlobalInstanceId() {
        return globalInstanceId;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setLocalInstanceId(String newLocalInstanceId) {
        String oldLocalInstanceId = localInstanceId;
        localInstanceId = newLocalInstanceId;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__LOCAL_INSTANCE_ID, oldLocalInstanceId, localInstanceId));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getLocalInstanceId() {
        return localInstanceId;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setMsg(String newMsg) {
        String oldMsg = msg;
        msg = newMsg;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__MSG, oldMsg, msg));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getMsg() {
        return msg;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setMsgDataElement(MsgDataElement newMsgDataElement) {
        if (newMsgDataElement != msgDataElement) {
            NotificationChain msgs = null;
            if (msgDataElement != null)
                msgs = ((InternalEObject) msgDataElement).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - EventPackage.COMMON_BASE_EVENT__MSG_DATA_ELEMENT, null, msgs);
            if (newMsgDataElement != null)
                msgs = ((InternalEObject) newMsgDataElement).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - EventPackage.COMMON_BASE_EVENT__MSG_DATA_ELEMENT, null, msgs);
            msgs = basicSetMsgDataElement(newMsgDataElement, msgs);
            if (msgs != null)
                msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__MSG_DATA_ELEMENT, newMsgDataElement, newMsgDataElement));
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setMsgDataElement(String, String, MsgCatalogToken[], String, String, String, String)
     */
    public MsgDataElement setMsgDataElement(String msgCatalog, String msgCatalogId, MsgCatalogToken[] tokens, String msgCatalogType, String msgId, String msgIdType, String msgCatalogLocale) {
        MsgDataElement mde = EventFactory.eINSTANCE.createMsgDataElement();
        mde.setMsgCatalog(msgCatalog);
        mde.setMsgCatalogId(msgCatalogId);
        mde.setMsgCatalogTokens(tokens);
        mde.setMsgCatalogType(msgCatalogType);
        mde.setMsgId(msgId);
        mde.setMsgIdType(msgIdType);
        mde.setMsgLocale(msgCatalogLocale);
        setMsgDataElement(mde);

        return mde;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setMsgDataElement(String, String, String[], String, String, String, String)
     */
    public MsgDataElement setMsgDataElement(String msgCatalog, String msgCatalogId, String[] tokens, String msgCatalogType, String msgId, String msgIdType, String msgCatalogLocale) {
        MsgDataElement mde = EventFactory.eINSTANCE.createMsgDataElement();
        mde.setMsgCatalog(msgCatalog);
        mde.setMsgCatalogId(msgCatalogId);
        mde.setMsgCatalogTokensAsStrings(tokens);
        mde.setMsgCatalogType(msgCatalogType);
        mde.setMsgId(msgId);
        mde.setMsgIdType(msgIdType);
        mde.setMsgLocale(msgCatalogLocale);
        setMsgDataElement(mde);

        return mde;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public MsgDataElement getMsgDataElement() {
        return msgDataElement;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setPriority(short newPriority) {
        short oldPriority = priority;
        priority = newPriority;
        boolean oldPriorityESet = priorityESet;
        priorityESet = true;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__PRIORITY, oldPriority, priority, !oldPriorityESet));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public short getPriority() {
        return priority;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setRepeatCount(short newRepeatCount) {
        short oldRepeatCount = repeatCount;
        repeatCount = newRepeatCount;
        boolean oldRepeatCountESet = repeatCountESet;
        repeatCountESet = true;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__REPEAT_COUNT, oldRepeatCount, repeatCount, !oldRepeatCountESet));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public short getRepeatCount() {
        return repeatCount;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setReporterComponentId(ComponentIdentification newReporterComponentId) {
        if (newReporterComponentId != reporterComponentId) {
            NotificationChain msgs = null;
            if (reporterComponentId != null)
                msgs = ((InternalEObject) reporterComponentId).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - EventPackage.COMMON_BASE_EVENT__REPORTER_COMPONENT_ID, null, msgs);
            if (newReporterComponentId != null)
                msgs = ((InternalEObject) newReporterComponentId).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - EventPackage.COMMON_BASE_EVENT__REPORTER_COMPONENT_ID, null, msgs);
            msgs = basicSetReporterComponentId(newReporterComponentId, msgs);
            if (msgs != null)
                msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__REPORTER_COMPONENT_ID, newReporterComponentId, newReporterComponentId));
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setReporterComponentId(String, String, String, String, String, String, String, String, String, String,String)
     */
    public void setReporterComponentId(String application, String component, String subComponent, String componentType, String componentIdType, String executionEnvironment, String instanceId, String location, String locationType, String processId, String threadId) {
        ComponentIdentification cid = EventFactory.eINSTANCE.createComponentIdentification();

        cid.setApplication(application);
        cid.setComponent(component);
        cid.setComponentType(componentType);
        cid.setComponentIdType(componentIdType);
        cid.setExecutionEnvironment(executionEnvironment);
        cid.setInstanceId(instanceId);
        cid.setLocation(location);
        cid.setLocationType(locationType);
        cid.setProcessId(processId);
        cid.setApplication(application);
        cid.setSubComponent(subComponent);
        cid.setThreadId(threadId);

        setReporterComponentId(cid);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setReporterComponentId(String, String, String, String, String, String, String)
     */
    public void setReporterComponentId(String application, String component, String subComponent, String componentType, String componentIdType, String location, String locationType) {
        setReporterComponentId(application, component, subComponent, componentType, componentIdType, null, // environment
        null, // instanceId
        location, locationType, null, // process
        null); // threadid
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ComponentIdentification getReporterComponentId() {
        return reporterComponentId;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setSequenceNumber(long newSequenceNumber) {
        long oldSequenceNumber = sequenceNumber;
        sequenceNumber = newSequenceNumber;
        boolean oldSequenceNumberESet = sequenceNumberESet;
        sequenceNumberESet = true;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__SEQUENCE_NUMBER, oldSequenceNumber, sequenceNumber, !oldSequenceNumberESet));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public long getSequenceNumber() {
        return sequenceNumber;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean isSetCreationTime() {
        return creationTimeESet;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean isSetElapsedTime() {
        return elapsedTimeESet;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean isSetPriority() {
        return priorityESet;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean isSetRepeatCount() {
        return repeatCountESet;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean isSetSequenceNumber() {
        return sequenceNumberESet;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean isSetSeverity() {
        return severityESet;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setSeverity(short newSeverity) {
        short oldSeverity = severity;
        severity = newSeverity;
        boolean oldSeverityESet = severityESet;
        severityESet = true;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__SEVERITY, oldSeverity, severity, !oldSeverityESet));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public short getSeverity() {
        return severity;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setSituation(Situation newSituation) {
        if (newSituation != situation) {
            NotificationChain msgs = null;
            if (situation != null)
                msgs = ((InternalEObject) situation).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - EventPackage.COMMON_BASE_EVENT__SITUATION, null, msgs);
            if (newSituation != null)
                msgs = ((InternalEObject) newSituation).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - EventPackage.COMMON_BASE_EVENT__SITUATION, null, msgs);
            msgs = basicSetSituation(newSituation, msgs);
            if (msgs != null)
                msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__SITUATION, newSituation, newSituation));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Situation getSituation() {
        return situation;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setSourceComponentId(ComponentIdentification newSourceComponentId) {
        if (newSourceComponentId != sourceComponentId) {
            NotificationChain msgs = null;
            if (sourceComponentId != null)
                msgs = ((InternalEObject) sourceComponentId).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - EventPackage.COMMON_BASE_EVENT__SOURCE_COMPONENT_ID, null, msgs);
            if (newSourceComponentId != null)
                msgs = ((InternalEObject) newSourceComponentId).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - EventPackage.COMMON_BASE_EVENT__SOURCE_COMPONENT_ID, null, msgs);
            msgs = basicSetSourceComponentId(newSourceComponentId, msgs);
            if (msgs != null)
                msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__SOURCE_COMPONENT_ID, newSourceComponentId, newSourceComponentId));
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setSourceComponentId(String, String, String, String, String, String, String, String, String, String,String)
     */
    public void setSourceComponentId(String application, String component, String subComponent, String componentType, String componentIdType, String executionEnvironment, String instanceId, String location, String locationType, String processId, String threadId) {
        ComponentIdentification cid = EventFactory.eINSTANCE.createComponentIdentification();

        cid.setApplication(application);
        cid.setComponent(component);
        cid.setSubComponent(subComponent);
        cid.setComponentType(componentType);
        cid.setComponentIdType(componentIdType);
        cid.setExecutionEnvironment(executionEnvironment);
        cid.setInstanceId(instanceId);
        cid.setLocation(location);
        cid.setLocationType(locationType);
        cid.setProcessId(processId);
        cid.setThreadId(threadId);

        setSourceComponentId(cid);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#setSourceComponentId(String, String, String, String, String, String,String)
     */
    public void setSourceComponentId(String application, String component, String subComponent, String componentType, String componentIdType, String location, String locationType) {
        setSourceComponentId(application, component, subComponent, componentType, componentIdType, null, // environment
        null, // instanceId
        location, locationType, null, // process
        null); // threadid
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ComponentIdentification getSourceComponentId() {
        return sourceComponentId;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setVersion(String newVersion) {
        String oldVersion = version;
        version = newVersion;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__VERSION, oldVersion, version));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getVersion() {
        return version;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addAny(String)
     */
    public void addAny(String any) {
        getAny().add(any);
    }

    /**
     * Removes all any strings that this event is referencing 
     */
    public void clearAny() {
        getAny().clear();
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addAssociatedEvent(String, String, String, String[])
     */
    public AssociatedEvent addAssociatedEvent(String associationEngineName, String associationEngineType, String associationEngineId, String[] resolvedEvents) {
        AssociatedEvent ase = EventFactory.eINSTANCE.createAssociatedEvent();
        ase.setAssociationEngineInfo(associationEngineName, associationEngineType, associationEngineId);

        ase.setResolvedEventsAsArray(resolvedEvents);

        getAssociatedEvents().add(ase);

        return ase;
    }

    /** 
     *  @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addContextDataElementWithValue(String, String, String)
     *  @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addContextDataElementWithId(String, String, String)
     */
    private ContextDataElement addContextDataElement(String contextType, String contextName, String contextValue, String contextId) {
        ContextDataElement cde = EventFactory.eINSTANCE.createContextDataElement();

        if (contextId != null) {
            cde.setContextId(contextId);
        }

        if (contextValue != null) {
            cde.setContextValue(contextValue);
        }

        cde.setName(contextName);
        cde.setType(contextType);
        getContextDataElements().add(cde);

        return cde;
    }

    /**
      * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addContextDataElementWithValue(String, String, String)
      */
    public ContextDataElement addContextDataElementWithValue(String contextType, String contextName, String contextValue) {
        return addContextDataElement(contextType, contextName, contextValue, null);
    }

    /**
      * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addContextDataElementWithId(String, String,String)
      */
    public ContextDataElement addContextDataElementWithId(String contextType, String contextName, String contextId) {
        return addContextDataElement(contextType, contextName, null, contextId);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElement(String, int, String)
     */
    public ExtendedDataElement addExtendedDataElement(String name, int type, String value) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setTypeAsInt(type);
        if (ExtendedDataElement.TYPE_HEX_BINARY_VALUE == type) {
            ede.setHexValue(value);
        }
        else {
            ede.getValues().add(value);
        }

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElement(String, int, String[])
     */
    public ExtendedDataElement addExtendedDataElement(String name, int type, String[] values) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setTypeAsInt(type);
        ede.getValues().addAll(Arrays.asList(values));

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElement(String, String)
     */
    public ExtendedDataElement addExtendedDataElement(String name, String value) {
        return addExtendedDataElement(name, ExtendedDataElement.TYPE_STRING_VALUE, value);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElement(String, String[])
     */
    public ExtendedDataElement addExtendedDataElement(String name, String[] values) {
        return addExtendedDataElement(name, ExtendedDataElement.TYPE_STRING_ARRAY_VALUE, values);
    }

    /**
     * Adds a new <code>ExtendedDataElement</code> to this object.
     *
     * @param extendedDataElement the new extended data element.
     * @return                    a reference to the extended data element added to this object.
     * @see #getExtendedDataElements()
     */
    public ExtendedDataElement addExtendedDataElement(ExtendedDataElement extendedDataElement) {

        getExtendedDataElements().add(extendedDataElement);

        return extendedDataElement;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElement(String)
     */
    public ExtendedDataElement addExtendedDataElement(String name) {
        ExtendedDataElement ede = EventFactory.eINSTANCE.createExtendedDataElement();
        ede.setName(name);
        getExtendedDataElements().add(ede);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithByteArrayValue(String, byte[])
     */
    public ExtendedDataElement addExtendedDataElementWithByteArrayValue(String name, byte[] values) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsByteArray(values);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithByteValue(String, byte)
     */
    public ExtendedDataElement addExtendedDataElementWithByteValue(String name, byte value) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsByte(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithNoValue(String)
     */
    public ExtendedDataElement addExtendedDataElementWithNoValue(String name) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setType(ExtendedDataElement.TYPE_NO_VALUE);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithBooleanArrayValue(java.lang.String, boolean[])
     */
    public ExtendedDataElement addExtendedDataElementWithBooleanArrayValue(String name, boolean[] values) {

        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsBooleanArray(values);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithBooleanValue(java.lang.String, boolean)
     */
    public ExtendedDataElement addExtendedDataElementWithBooleanValue(String name, boolean value) {

        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsBoolean(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithDateArrayValue(String, String[])
     */
    public ExtendedDataElement addExtendedDataElementWithDateArrayValue(String name, String[] values) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsDateArray(values);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithDateAsLongValue(String, long)
     */
    public ExtendedDataElement addExtendedDataElementWithDateAsLongValue(String name, long value) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsDateAsLong(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithDateValue(String, String)
     */
    public ExtendedDataElement addExtendedDataElementWithDateValue(String name, String value) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsDate(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithDatesAsLongValue(String, long[])
     */
    public ExtendedDataElement addExtendedDataElementWithDatesAsLongValue(String name, long[] values) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsDateAsLongArray(values);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithDoubleArrayValue(String, double[])
     */
    public ExtendedDataElement addExtendedDataElementWithDoubleArrayValue(String name, double[] values) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsDoubleArray(values);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithDoubleValue(String, double)
     */
    public ExtendedDataElement addExtendedDataElementWithDoubleValue(String name, double value) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsDouble(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithFloatArrayValue(String, float[])
     */
    public ExtendedDataElement addExtendedDataElementWithFloatArrayValue(String name, float[] values) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsFloatArray(values);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithFloatValue(String, float)
     */
    public ExtendedDataElement addExtendedDataElementWithFloatValue(String name, float value) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsFloat(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithIntArrayValue(String, int[])
     */
    public ExtendedDataElement addExtendedDataElementWithIntArrayValue(String name, int[] values) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsIntArray(values);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithIntValue(String, int)
     */
    public ExtendedDataElement addExtendedDataElementWithIntValue(String name, int value) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsInt(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithLongArrayValue(String, long[])
     */
    public ExtendedDataElement addExtendedDataElementWithLongArrayValue(String name, long[] values) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsLongArray(values);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithLongValue(String, long)
     */
    public ExtendedDataElement addExtendedDataElementWithLongValue(String name, long value) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsLong(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithShortArrayValue(String, short[])
     */
    public ExtendedDataElement addExtendedDataElementWithShortArrayValue(String name, short[] values) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsShortArray(values);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithShortValue(String, short)
     */
    public ExtendedDataElement addExtendedDataElementWithShortValue(String name, short value) {
        ExtendedDataElement ede = addExtendedDataElement(name);
        ede.setValuesAsShort(value);

        return ede;
    }

    /*
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithHexValue(java.lang.String, byte[])
     */
    public ExtendedDataElement addExtendedDataElementWithHexValue(String name, byte[] hexValue) {
        ExtendedDataElement result = EventFactory.eINSTANCE.createExtendedDataElement();
        result.setType(ExtendedDataElement.TYPE_HEX_BINARY);
        result.setName(name);
        result.setHexValueAsByteArray(hexValue);
        getExtendedDataElements().add(result);
        return result;
    }

    /*
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#addExtendedDataElementWithHexValue(java.lang.String, java.lang.String)
     */
    public ExtendedDataElement addExtendedDataElementWithHexValue(String name, String hexValue) {
        ExtendedDataElement result = EventFactory.eINSTANCE.createExtendedDataElement();
        result.setType(ExtendedDataElement.TYPE_HEX_BINARY);
        result.setName(name);
        result.setHexValue(hexValue);
        getExtendedDataElements().add(result);
        return result;
    }

    /**
     * Removes all ExtenedDataElements that this event is referencing 
     */
    public void clearExtendedDataElements() {
        getExtendedDataElements().clear();
    }

    /**
     * Remove a named extended data element that this event is referencing 
     * 
     * @param name the name of the element to be removed
     */
    public void removeExtendedDataElements(String name) {

        if (getExtendedDataElements() != null) {

            for (int counter = 0; counter < getExtendedDataElements().size(); counter++) {

                if (((ExtendedDataElement) (extendedDataElements.get(counter))).getName().equals(name)) {
                    extendedDataElements.remove(counter--);
                }
            }
        }
    }

    /**
     * Adds a new <code>ContextDataElement</code> to this object.
     *
     * @param contextDataElement the new context data element.
     * @return                    a reference to the context data element added to this object.
     * @see #getContextDataElements()
     */
    public ContextDataElement addContextDataElement(ContextDataElement contextDataElement) {

        getContextDataElements().add(contextDataElement);

        return contextDataElement;
    }

    /**
     * Removes all ExtenedDataElements that this event is referencing 
     */
    public void clearContextDataElements() {
        getContextDataElements().clear();
    }

    /**
     * Remove a named context data element that this event is referencing 
     * 
     * @param name the name of the element to be removed
     */
    public void removeContextDataElements(String name) {

        if (getContextDataElements() != null) {

            for (int counter = 0; counter < getContextDataElements().size(); counter++) {

                if (((ContextDataElement) (getContextDataElements().get(counter))).getName().equals(name)) {
                    getContextDataElements().remove(counter--);
                }
            }
        }
    }

    /**
     * Adds a new <code>AssociatedEvent</code> to this object.
     *
     * @param associatedEvents the new context data element.
     * @return a reference to the context data element added to this object.
     * @see #getAssociatedEvents()
     */
    public AssociatedEvent addAssociatedEvent(AssociatedEvent associatedEvent) {

        getAssociatedEvents().add(associatedEvent);

        return associatedEvent;
    }

    /**
     * Removes all ExtenedDataElements that this event is referencing 
     */
    public void clearAssociatedEvents() {
        getAssociatedEvents().clear();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetMsgDataElement(MsgDataElement newMsgDataElement, NotificationChain msgs) {
        MsgDataElement oldMsgDataElement = msgDataElement;
        msgDataElement = newMsgDataElement;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__MSG_DATA_ELEMENT, oldMsgDataElement, newMsgDataElement);
            if (msgs == null)
                msgs = notification;
            else
                msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetReporterComponentId(ComponentIdentification newReporterComponentId, NotificationChain msgs) {
        ComponentIdentification oldReporterComponentId = reporterComponentId;
        reporterComponentId = newReporterComponentId;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__REPORTER_COMPONENT_ID, oldReporterComponentId, newReporterComponentId);
            if (msgs == null)
                msgs = notification;
            else
                msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetSituation(Situation newSituation, NotificationChain msgs) {
        Situation oldSituation = situation;
        situation = newSituation;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__SITUATION, oldSituation, newSituation);
            if (msgs == null)
                msgs = notification;
            else
                msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetSourceComponentId(ComponentIdentification newSourceComponentId, NotificationChain msgs) {
        ComponentIdentification oldSourceComponentId = sourceComponentId;
        sourceComponentId = newSourceComponentId;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, EventPackage.COMMON_BASE_EVENT__SOURCE_COMPONENT_ID, oldSourceComponentId, newSourceComponentId);
            if (msgs == null)
                msgs = notification;
            else
                msgs.add(notification);
        }
        return msgs;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#complete
     */
    public void complete() throws CompletionException {
        
        if (contentHandler != null) {
            
            synchronized(this){
                contentHandler.completeEvent(this);            
            }

            isComplete = true;
        }
    }

    /*
     * @see org.eclipse.hyades.logging.events.cbe.CommonBaseEvent#isComplete()
     */
    public boolean isComplete() {
        return isComplete;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.COMMON_BASE_EVENT__CREATION_TIME :
                return getCreationTime();
            case EventPackage.COMMON_BASE_EVENT__GLOBAL_INSTANCE_ID :
                return getGlobalInstanceId();
            case EventPackage.COMMON_BASE_EVENT__ELAPSED_TIME :
                return new Long(getElapsedTime());
            case EventPackage.COMMON_BASE_EVENT__EXTENSION_NAME :
                return getExtensionName();
            case EventPackage.COMMON_BASE_EVENT__LOCAL_INSTANCE_ID :
                return getLocalInstanceId();
            case EventPackage.COMMON_BASE_EVENT__MSG :
                return getMsg();
            case EventPackage.COMMON_BASE_EVENT__PRIORITY :
                return new Short(getPriority());
            case EventPackage.COMMON_BASE_EVENT__REPEAT_COUNT :
                return new Short(getRepeatCount());
            case EventPackage.COMMON_BASE_EVENT__SEQUENCE_NUMBER :
                return new Long(getSequenceNumber());
            case EventPackage.COMMON_BASE_EVENT__SEVERITY :
                return new Short(getSeverity());
            case EventPackage.COMMON_BASE_EVENT__VERSION :
                return getVersion();
            case EventPackage.COMMON_BASE_EVENT__ANY :
                return getAny();
            case EventPackage.COMMON_BASE_EVENT__SITUATION :
                return getSituation();
            case EventPackage.COMMON_BASE_EVENT__ASSOCIATED_EVENTS :
                return getAssociatedEvents();
            case EventPackage.COMMON_BASE_EVENT__CONTEXT_DATA_ELEMENTS :
                return getContextDataElements();
            case EventPackage.COMMON_BASE_EVENT__EXTENDED_DATA_ELEMENTS :
                return getExtendedDataElements();
            case EventPackage.COMMON_BASE_EVENT__MSG_DATA_ELEMENT :
                return getMsgDataElement();
            case EventPackage.COMMON_BASE_EVENT__REPORTER_COMPONENT_ID :
                return getReporterComponentId();
            case EventPackage.COMMON_BASE_EVENT__SOURCE_COMPONENT_ID :
                return getSourceComponentId();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case EventPackage.COMMON_BASE_EVENT__SITUATION :
                    return basicSetSituation(null, msgs);
                case EventPackage.COMMON_BASE_EVENT__ASSOCIATED_EVENTS :
                    return ((InternalEList) getAssociatedEvents()).basicRemove(otherEnd, msgs);
                case EventPackage.COMMON_BASE_EVENT__CONTEXT_DATA_ELEMENTS :
                    return ((InternalEList) getContextDataElements()).basicRemove(otherEnd, msgs);
                case EventPackage.COMMON_BASE_EVENT__EXTENDED_DATA_ELEMENTS :
                    return ((InternalEList) getExtendedDataElements()).basicRemove(otherEnd, msgs);
                case EventPackage.COMMON_BASE_EVENT__MSG_DATA_ELEMENT :
                    return basicSetMsgDataElement(null, msgs);
                case EventPackage.COMMON_BASE_EVENT__REPORTER_COMPONENT_ID :
                    return basicSetReporterComponentId(null, msgs);
                case EventPackage.COMMON_BASE_EVENT__SOURCE_COMPONENT_ID :
                    return basicSetSourceComponentId(null, msgs);
                default :
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.COMMON_BASE_EVENT__CREATION_TIME :
                return isSetCreationTime();
            case EventPackage.COMMON_BASE_EVENT__GLOBAL_INSTANCE_ID :
                return GLOBAL_INSTANCE_ID_EDEFAULT == null ? globalInstanceId != null : !GLOBAL_INSTANCE_ID_EDEFAULT.equals(globalInstanceId);
            case EventPackage.COMMON_BASE_EVENT__ELAPSED_TIME :
                return isSetElapsedTime();
            case EventPackage.COMMON_BASE_EVENT__EXTENSION_NAME :
                return EXTENSION_NAME_EDEFAULT == null ? extensionName != null : !EXTENSION_NAME_EDEFAULT.equals(extensionName);
            case EventPackage.COMMON_BASE_EVENT__LOCAL_INSTANCE_ID :
                return LOCAL_INSTANCE_ID_EDEFAULT == null ? localInstanceId != null : !LOCAL_INSTANCE_ID_EDEFAULT.equals(localInstanceId);
            case EventPackage.COMMON_BASE_EVENT__MSG :
                return MSG_EDEFAULT == null ? msg != null : !MSG_EDEFAULT.equals(msg);
            case EventPackage.COMMON_BASE_EVENT__PRIORITY :
                return isSetPriority();
            case EventPackage.COMMON_BASE_EVENT__REPEAT_COUNT :
                return isSetRepeatCount();
            case EventPackage.COMMON_BASE_EVENT__SEQUENCE_NUMBER :
                return isSetSequenceNumber();
            case EventPackage.COMMON_BASE_EVENT__SEVERITY :
                return isSetSeverity();
            case EventPackage.COMMON_BASE_EVENT__VERSION :
                return VERSION_EDEFAULT == null ? version != null : !VERSION_EDEFAULT.equals(version);
            case EventPackage.COMMON_BASE_EVENT__ANY :
                return any != null && !any.isEmpty();
            case EventPackage.COMMON_BASE_EVENT__SITUATION :
                return situation != null;
            case EventPackage.COMMON_BASE_EVENT__ASSOCIATED_EVENTS :
                return associatedEvents != null && !associatedEvents.isEmpty();
            case EventPackage.COMMON_BASE_EVENT__CONTEXT_DATA_ELEMENTS :
                return contextDataElements != null && !contextDataElements.isEmpty();
            case EventPackage.COMMON_BASE_EVENT__EXTENDED_DATA_ELEMENTS :
                return extendedDataElements != null && !extendedDataElements.isEmpty();
            case EventPackage.COMMON_BASE_EVENT__MSG_DATA_ELEMENT :
                return msgDataElement != null;
            case EventPackage.COMMON_BASE_EVENT__REPORTER_COMPONENT_ID :
                return reporterComponentId != null;
            case EventPackage.COMMON_BASE_EVENT__SOURCE_COMPONENT_ID :
                return sourceComponentId != null;
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.COMMON_BASE_EVENT__CREATION_TIME :
                setCreationTime((String) newValue);
                return;
            case EventPackage.COMMON_BASE_EVENT__GLOBAL_INSTANCE_ID :
                setGlobalInstanceId((String) newValue);
                return;
            case EventPackage.COMMON_BASE_EVENT__ELAPSED_TIME :
                setElapsedTime(((Long) newValue).longValue());
                return;
            case EventPackage.COMMON_BASE_EVENT__EXTENSION_NAME :
                setExtensionName((String) newValue);
                return;
            case EventPackage.COMMON_BASE_EVENT__LOCAL_INSTANCE_ID :
                setLocalInstanceId((String) newValue);
                return;
            case EventPackage.COMMON_BASE_EVENT__MSG :
                setMsg((String) newValue);
                return;
            case EventPackage.COMMON_BASE_EVENT__PRIORITY :
                setPriority(((Short) newValue).shortValue());
                return;
            case EventPackage.COMMON_BASE_EVENT__REPEAT_COUNT :
                setRepeatCount(((Short) newValue).shortValue());
                return;
            case EventPackage.COMMON_BASE_EVENT__SEQUENCE_NUMBER :
                setSequenceNumber(((Long) newValue).longValue());
                return;
            case EventPackage.COMMON_BASE_EVENT__SEVERITY :
                setSeverity(((Short) newValue).shortValue());
                return;
            case EventPackage.COMMON_BASE_EVENT__VERSION :
                setVersion((String) newValue);
                return;
            case EventPackage.COMMON_BASE_EVENT__ANY :
                getAny().clear();
                getAny().addAll((Collection) newValue);
                return;
            case EventPackage.COMMON_BASE_EVENT__SITUATION :
                setSituation((Situation) newValue);
                return;
            case EventPackage.COMMON_BASE_EVENT__ASSOCIATED_EVENTS :
                getAssociatedEvents().clear();
                getAssociatedEvents().addAll((Collection) newValue);
                return;
            case EventPackage.COMMON_BASE_EVENT__CONTEXT_DATA_ELEMENTS :
                getContextDataElements().clear();
                getContextDataElements().addAll((Collection) newValue);
                return;
            case EventPackage.COMMON_BASE_EVENT__EXTENDED_DATA_ELEMENTS :
                getExtendedDataElements().clear();
                getExtendedDataElements().addAll((Collection) newValue);
                return;
            case EventPackage.COMMON_BASE_EVENT__MSG_DATA_ELEMENT :
                setMsgDataElement((MsgDataElement) newValue);
                return;
            case EventPackage.COMMON_BASE_EVENT__REPORTER_COMPONENT_ID :
                setReporterComponentId((ComponentIdentification) newValue);
                return;
            case EventPackage.COMMON_BASE_EVENT__SOURCE_COMPONENT_ID :
                setSourceComponentId((ComponentIdentification) newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.COMMON_BASE_EVENT__CREATION_TIME :
                unsetCreationTime();
                return;
            case EventPackage.COMMON_BASE_EVENT__GLOBAL_INSTANCE_ID :
                setGlobalInstanceId(GLOBAL_INSTANCE_ID_EDEFAULT);
                return;
            case EventPackage.COMMON_BASE_EVENT__ELAPSED_TIME :
                unsetElapsedTime();
                return;
            case EventPackage.COMMON_BASE_EVENT__EXTENSION_NAME :
                setExtensionName(EXTENSION_NAME_EDEFAULT);
                return;
            case EventPackage.COMMON_BASE_EVENT__LOCAL_INSTANCE_ID :
                setLocalInstanceId(LOCAL_INSTANCE_ID_EDEFAULT);
                return;
            case EventPackage.COMMON_BASE_EVENT__MSG :
                setMsg(MSG_EDEFAULT);
                return;
            case EventPackage.COMMON_BASE_EVENT__PRIORITY :
                unsetPriority();
                return;
            case EventPackage.COMMON_BASE_EVENT__REPEAT_COUNT :
                unsetRepeatCount();
                return;
            case EventPackage.COMMON_BASE_EVENT__SEQUENCE_NUMBER :
                unsetSequenceNumber();
                return;
            case EventPackage.COMMON_BASE_EVENT__SEVERITY :
                unsetSeverity();
                return;
            case EventPackage.COMMON_BASE_EVENT__VERSION :
                setVersion(VERSION_EDEFAULT);
                return;
            case EventPackage.COMMON_BASE_EVENT__ANY :
                getAny().clear();
                return;
            case EventPackage.COMMON_BASE_EVENT__SITUATION :
                setSituation((Situation) null);
                return;
            case EventPackage.COMMON_BASE_EVENT__ASSOCIATED_EVENTS :
                getAssociatedEvents().clear();
                return;
            case EventPackage.COMMON_BASE_EVENT__CONTEXT_DATA_ELEMENTS :
                getContextDataElements().clear();
                return;
            case EventPackage.COMMON_BASE_EVENT__EXTENDED_DATA_ELEMENTS :
                getExtendedDataElements().clear();
                return;
            case EventPackage.COMMON_BASE_EVENT__MSG_DATA_ELEMENT :
                setMsgDataElement((MsgDataElement) null);
                return;
            case EventPackage.COMMON_BASE_EVENT__REPORTER_COMPONENT_ID :
                setReporterComponentId((ComponentIdentification) null);
                return;
            case EventPackage.COMMON_BASE_EVENT__SOURCE_COMPONENT_ID :
                setSourceComponentId((ComponentIdentification) null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /*
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object arg0) {
        
        synchronized(this){
            return EventHelpers.compareEObject(this, arg0);
        }        
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy())
            return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (creationTime: ");
        if (creationTimeESet)
            result.append(creationTime);
        else
            result.append("<unset>");
        result.append(", globalInstanceId: ");
        result.append(globalInstanceId);
        result.append(", elapsedTime: ");
        if (elapsedTimeESet)
            result.append(elapsedTime);
        else
            result.append("<unset>");
        result.append(", extensionName: ");
        result.append(extensionName);
        result.append(", localInstanceId: ");
        result.append(localInstanceId);
        result.append(", msg: ");
        result.append(msg);
        result.append(", priority: ");
        if (priorityESet)
            result.append(priority);
        else
            result.append("<unset>");
        result.append(", repeatCount: ");
        if (repeatCountESet)
            result.append(repeatCount);
        else
            result.append("<unset>");
        result.append(", sequenceNumber: ");
        if (sequenceNumberESet)
            result.append(sequenceNumber);
        else
            result.append("<unset>");
        result.append(", severity: ");
        if (severityESet)
            result.append(severity);
        else
            result.append("<unset>");
        result.append(", version: ");
        result.append(version);
        result.append(", any: ");
        result.append(any);
        result.append(", situation: ");
        result.append(situation);
        result.append(", associatedEvents: ");
        result.append(associatedEvents);
        result.append(", contextDataElements: ");
        result.append(contextDataElements);
        result.append(", extendedDataElements: ");
        result.append(extendedDataElements);
        result.append(", msgDataElement: ");
        result.append(msgDataElement);   
        result.append(", reporterComponentId: ");
        result.append(reporterComponentId);  
        result.append(", sourceComponentId: ");
        result.append(sourceComponentId);        
        result.append(')');         
        return result.toString();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void unsetCreationTime() {
        String oldCreationTime = creationTime;
        boolean oldCreationTimeESet = creationTimeESet;
        creationTime = CREATION_TIME_EDEFAULT;
        creationTimeESet = false;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.UNSET, EventPackage.COMMON_BASE_EVENT__CREATION_TIME, oldCreationTime, CREATION_TIME_EDEFAULT, oldCreationTimeESet));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void unsetElapsedTime() {
        long oldElapsedTime = elapsedTime;
        boolean oldElapsedTimeESet = elapsedTimeESet;
        elapsedTime = ELAPSED_TIME_EDEFAULT;
        elapsedTimeESet = false;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.UNSET, EventPackage.COMMON_BASE_EVENT__ELAPSED_TIME, oldElapsedTime, ELAPSED_TIME_EDEFAULT, oldElapsedTimeESet));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void unsetPriority() {
        short oldPriority = priority;
        boolean oldPriorityESet = priorityESet;
        priority = PRIORITY_EDEFAULT;
        priorityESet = false;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.UNSET, EventPackage.COMMON_BASE_EVENT__PRIORITY, oldPriority, PRIORITY_EDEFAULT, oldPriorityESet));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void unsetRepeatCount() {
        short oldRepeatCount = repeatCount;
        boolean oldRepeatCountESet = repeatCountESet;
        repeatCount = REPEAT_COUNT_EDEFAULT;
        repeatCountESet = false;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.UNSET, EventPackage.COMMON_BASE_EVENT__REPEAT_COUNT, oldRepeatCount, REPEAT_COUNT_EDEFAULT, oldRepeatCountESet));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void unsetSequenceNumber() {
        long oldSequenceNumber = sequenceNumber;
        boolean oldSequenceNumberESet = sequenceNumberESet;
        sequenceNumber = SEQUENCE_NUMBER_EDEFAULT;
        sequenceNumberESet = false;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.UNSET, EventPackage.COMMON_BASE_EVENT__SEQUENCE_NUMBER, oldSequenceNumber, SEQUENCE_NUMBER_EDEFAULT, oldSequenceNumberESet));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void unsetSeverity() {
        short oldSeverity = severity;
        boolean oldSeverityESet = severityESet;
        severity = SEVERITY_EDEFAULT;
        severityESet = false;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.UNSET, EventPackage.COMMON_BASE_EVENT__SEVERITY, oldSeverity, SEVERITY_EDEFAULT, oldSeverityESet));
    }

    /**
     * Checks whether the contents of the instance conform to the
     * CBE specification.
     *
     * @throws ValidationException
     *                       if the event instance does not follow the
     *                       CBE specification.
     */
    public void validate() throws ValidationException {

        synchronized(this){

	        EAttribute attr;
	
	        // checking for required attributes	
	        EventValidation.validateRequiredProperties(CLASS_NAME, this);
	
	        // checking for boundaries
	        attr = EventPackage.eINSTANCE.getCommonBaseEvent_ExtensionName();
	        EventValidation.validateLength(CLASS_NAME, this, attr, 64);
	        
	        attr = EventPackage.eINSTANCE.getCommonBaseEvent_LocalInstanceId();
	        EventValidation.validateLength(CLASS_NAME, this, attr, 128);
	
	        // checking for Id length
	        attr = EventPackage.eINSTANCE.getCommonBaseEvent_GlobalInstanceId();
	        EventValidation.validateId(CLASS_NAME, this, attr);
	        
	        // checking CreationTime
	        attr = EventPackage.eINSTANCE.getCommonBaseEvent_CreationTime();
	        validateCreationTime(attr);
	
	        attr = EventPackage.eINSTANCE.getCommonBaseEvent_Severity();
	        validateShortRange(attr, (short) 0, (short) 70);
	        
	        attr = EventPackage.eINSTANCE.getCommonBaseEvent_Priority();
	        validateShortRange(attr, (short) 0, (short) 100);
	
	        attr = EventPackage.eINSTANCE.getCommonBaseEvent_Msg();
	        EventValidation.validateLength(CLASS_NAME, this, attr, 1024);
	
	        attr = EventPackage.eINSTANCE.getCommonBaseEvent_RepeatCount();
	        validateShortRange(attr, (short)0, Short.MAX_VALUE);
	
	        attr = EventPackage.eINSTANCE.getCommonBaseEvent_ElapsedTime();
	        validateLongRange(attr, 0, Long.MAX_VALUE);
	
	        // If repeatCount is specified then elapsedTime is required
	        if ((getRepeatCount() != 0) && (!isSetElapsedTime())) {
	            throw new ValidationException(EventHelpers.getString("LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_",EventValidation.getComponentName(this, EventPackage.eINSTANCE.getCommonBaseEvent_ElapsedTime().getName()), getClass()));
	        }
	
	        attr = EventPackage.eINSTANCE.getCommonBaseEvent_SequenceNumber();
	        validateLongRange(attr, 0, Long.MAX_VALUE);
	
	        // checking version
	        attr = EventPackage.eINSTANCE.getCommonBaseEvent_Version();
	        EventValidation.validateVersion(CLASS_NAME, this, attr);
	
	        // checking reporterComponentId
	        //   no need to check for missing sourceComponentId since that should have been caught
	        //   during validation of required attributes
	
	        // We don't want to check for null pointers on these
	        // two because an exception should have been thrown during validation
	        // of required attributes. 
	        getSourceComponentId().validate();
	        getSituation().validate();
	
	        if (getReporterComponentId() != null) {
	            getReporterComponentId().validate();
	        }
	
	        if (getMsgDataElement() != null) {
	            getMsgDataElement().validate();
	        }
	
	        if (getContextDataElements() != null) {
	            
	            ListIterator it = getContextDataElements().listIterator();
	            ContextDataElement contextDataElement = null;

	            while (it.hasNext()) {
	                
	                contextDataElement = ((ContextDataElement)(it.next()));
	                
	                try {
	                    contextDataElement.validate();
	                } 
	                catch (ValidationException v) {
	                    throw new ValidationException(EventHelpers.getString("LOG_INVALID_LIST_ELEMENT_ATTRIBUTE_EXC_",EventValidation.getComponentName(contextDataElement).concat("[").concat(String.valueOf(it.nextIndex())).concat("]")),v);
	                }
	            }
	        }
	
	        if (getAssociatedEvents() != null) {

	            ListIterator it = getAssociatedEvents().listIterator();
	            AssociatedEvent associatedEvent = null;

	            while (it.hasNext()) {

	                associatedEvent = ((AssociatedEvent)(it.next()));
	                
	                try {
	                    associatedEvent.validate();
	                } 
	                catch (ValidationException v) {
	                    throw new ValidationException(EventHelpers.getString("LOG_INVALID_LIST_ELEMENT_ATTRIBUTE_EXC_",EventValidation.getComponentName(associatedEvent).concat("[").concat(String.valueOf(it.nextIndex())).concat("]")),v);
	                }
	            }
	        }
	
	        if (getExtendedDataElements() != null) {
	            
	            ListIterator it = getExtendedDataElements().listIterator();
	            ExtendedDataElement extendedDataElement = null;
	            
	            while (it.hasNext()) {
	                
	                extendedDataElement = ((ExtendedDataElement)(it.next()));
	                
	                try {
	                    extendedDataElement.validate();
	                } 
	                catch (ValidationException v) {
	                    throw new ValidationException(EventHelpers.getString("LOG_INVALID_LIST_ELEMENT_ATTRIBUTE_EXC_",EventValidation.getComponentName(extendedDataElement).concat("[").concat(String.valueOf(it.nextIndex())).concat("]")),v);
	                }
	            }
	        }
        }
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getCommonBaseEvent();
    }

    /**
     * Required to circumvent a problem with de/serializing EMF ELists with RMI over IIOP by 
     * converting EMF ELists to Lists.  
     * 
     * @see java.io.Serializable
     */
    private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
        
        synchronized(this){

	        EventHelpers.serializableRead(this, in);
	
	        // now need to read in the isSet variables
	        creationTimeESet = in.readBoolean();
	        elapsedTimeESet = in.readBoolean();
	        priorityESet = in.readBoolean();
	        repeatCountESet = in.readBoolean();
	        sequenceNumberESet = in.readBoolean();
	        severityESet = in.readBoolean();
        }
    }

    /*
     * Private methods.
     */

    /**
     * Required to circumvent a problem with de/serializing EMF ELists with RMI over IIOP by 
     * converting EMF ELists to Lists.  
     * 
     * @see java.io.Serializable
     */
    private void writeObject(java.io.ObjectOutputStream out) throws IOException {

        synchronized(this){
            
            EventHelpers.serializableWrite(this, out);

	        // now need to write out the isSet variables
	        out.writeBoolean(creationTimeESet);
	        out.writeBoolean(elapsedTimeESet);
	        out.writeBoolean(priorityESet);
	        out.writeBoolean(repeatCountESet);
	        out.writeBoolean(sequenceNumberESet);
	        out.writeBoolean(severityESet);
        }
    }

    /**
     * Checks whether a CreationTime conforms to the spec
     */
    private void validateCreationTime(EStructuralFeature att) throws ValidationException {
        String inDate = (String) eGet(att);
        boolean badDate = false;
        long milliseconds = 0;

        if (inDate == null) {
            badDate = true;
        }
        else {
            try {
                milliseconds = EventHelpers.dateToLong(inDate);
            }
            catch (IllegalArgumentException ex) {
                badDate = true;
            }
        }

        if ((badDate == true) || (milliseconds == 0)) {
            throw new ValidationException(EventHelpers.getString("LOG_INVALID_CREATION_TIME_EXC_",EventValidation.getComponentName(this, att.getName()), inDate));
        }
    }

    /**
     * Checks whether a number is between (inclusive) the short high and low values
     */
    private void validateShortRange(EStructuralFeature att, short low, short high) throws ValidationException {
        
        short value = ((Short) eGet(att)).shortValue();
        
        if ((value < low) || (value > high)) {
            throw new ValidationException(EventHelpers.getString("LOG_VALUE_OUT_OF_RANGE_EXC_",new Short(value), EventValidation.getComponentName(this, att.getName()), new Short(low), new Short(high)));
        }
    }

    /**
     * Checks whether a number is between (inclusive) the long high and low values
     */
    private void validateLongRange(EStructuralFeature att, long low, long high) throws ValidationException {

        long value = ((Long) eGet(att)).longValue();
        
        if ((value < low) || (value > high)) {
            throw new ValidationException(EventHelpers.getString("LOG_VALUE_OUT_OF_RANGE_EXC_",new Long(value), EventValidation.getComponentName(this, att.getName()), new Long(low), new Long(high)));
        }
    }

    /**
     * @see org.eclipse.hyades.logging.core.IExternalizableToXml#externalizeCanonicalXmlString()
     */
    public String externalizeCanonicalXmlString() {
        return EventFormatter.toCanonicalXMLString(this);
    }

    /**
     * @see org.eclipse.hyades.logging.core.IExternalizableToXml#externalizeCanonicalXmlDocString()
     */
    public String externalizeCanonicalXmlDocString() {
        return EventFormatter.toCanonicalXMLDocString(this);
    }

    /**
     * @see org.eclipse.hyades.logging.core.IInternalizableFromXml#internalizeCanonicalXmlString(java.lang.String)
     */
    public void internalizeCanonicalXmlString(String value) {

        try {
            
            CommonBaseEvent event = EventFormatter.eventFromCanonicalXML(value);
            
            if(event != null){
                
                TemplateContentHandlerImpl contentHandler =  new TemplateContentHandlerImpl();
                contentHandler.setTemplateEvent(event);
                
                setContentHandler(contentHandler);            
                
                complete();                
                
                setContentHandler(null);
            }
		} 
        catch (Exception e) {
			//Ignore for backwards compatibility.
		}        
    }

    /**
     * @see org.eclipse.hyades.logging.core.IInternalizableFromXml#internalizeCanonicalXmlDocString(java.lang.String)
     */
    public void internalizeCanonicalXmlDocString(String value) {

        try {
            
            CommonBaseEvent[] events = EventFormatter.eventsFromCanonicalXMLDoc(value);
            
            if((events != null) && (events[0] != null)){
                
                TemplateContentHandlerImpl contentHandler =  new TemplateContentHandlerImpl();
                contentHandler.setTemplateEvent(events[0]);
                
                setContentHandler(contentHandler);            
                
                complete();                
                
                setContentHandler(null);
            }
		} 
        catch (Exception e) {
			//Ignore for backwards compatibility.
		}        
    }

    /**
     * return a cloned (copy by value) object. This is a deep copy version, in which all the
     * objects within this object will be copied by value.
     *  
     * @return Object
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized(this){
            return EcoreUtil.copy(this);
        }       
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * <p>
     * 
     * @since 1.0
     */
    public void init() {

        unsetCreationTime();
        unsetElapsedTime();
        unsetPriority();
        unsetRepeatCount();
        unsetSequenceNumber();
        unsetSeverity();

        setExtensionName(EXTENSION_NAME_EDEFAULT);
        setLocalInstanceId(LOCAL_INSTANCE_ID_EDEFAULT);
        setMsg(MSG_EDEFAULT);
        setVersion(VERSION_EDEFAULT);
        setGlobalInstanceId(GLOBAL_INSTANCE_ID_EDEFAULT);

        clearExtendedDataElements();
        clearContextDataElements();
        clearAssociatedEvents();
        clearAny();

        setSituation(null);
        setMsgDataElement(null);
        setReporterComponentId(null);
        setSourceComponentId(null);

        isComplete = false;
    }

} //CommonBaseEventImpl
