package org.eclipse.hyades.logging.events.cbe.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.ListIterator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;
import org.eclipse.hyades.logging.events.cbe.util.EventValidation;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MsgDataElementImpl.java,v 1.12 2005/03/09 17:33:19 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Msg Data Element</b></em>'.
 * 
 * @author Andrea Chiavegatto
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0
 * @implements Cloneable
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.MsgDataElementImpl#getMsgIdType <em>Msg Id Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.MsgDataElementImpl#getMsgCatalogType <em>Msg Catalog Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.MsgDataElementImpl#getMsgCatalog <em>Msg Catalog</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.MsgDataElementImpl#getMsgCatalogId <em>Msg Catalog Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.MsgDataElementImpl#getMsgId <em>Msg Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.MsgDataElementImpl#getMsgLocale <em>Msg Locale</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.MsgDataElementImpl#getMsgCatalogTokens <em>Msg Catalog Tokens</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class MsgDataElementImpl extends SerializableImpl implements MsgDataElement, Cloneable {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = -4093681142902289230L;

    /**
     * Classname for trace/log 
     */
    private static final String CLASS_NAME = MsgDataElementImpl.class.getName();

    /**
     * The default value of the '{@link #getMsgIdType() <em>Msg Id Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMsgIdType()
     * @generated
     * @ordered
     */
    protected static final String MSG_ID_TYPE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getMsgIdType() <em>Msg Id Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMsgIdType()
     * @generated
     * @ordered
     */
    protected String msgIdType = MSG_ID_TYPE_EDEFAULT;

    /**
     * The default value of the '{@link #getMsgCatalogType() <em>Msg Catalog Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMsgCatalogType()
     * @generated
     * @ordered
     */
    protected static final String MSG_CATALOG_TYPE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getMsgCatalogType() <em>Msg Catalog Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMsgCatalogType()
     * @generated
     * @ordered
     */
    protected String msgCatalogType = MSG_CATALOG_TYPE_EDEFAULT;

    /**
     * The default value of the '{@link #getMsgCatalog() <em>Msg Catalog</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMsgCatalog()
     * @generated
     * @ordered
     */
    protected static final String MSG_CATALOG_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getMsgCatalog() <em>Msg Catalog</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMsgCatalog()
     * @generated
     * @ordered
     */
    protected String msgCatalog = MSG_CATALOG_EDEFAULT;

    /**
     * The default value of the '{@link #getMsgCatalogId() <em>Msg Catalog Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMsgCatalogId()
     * @generated
     * @ordered
     */
    protected static final String MSG_CATALOG_ID_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getMsgCatalogId() <em>Msg Catalog Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMsgCatalogId()
     * @generated
     * @ordered
     */
    protected String msgCatalogId = MSG_CATALOG_ID_EDEFAULT;

    /**
     * The default value of the '{@link #getMsgId() <em>Msg Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMsgId()
     * @generated
     * @ordered
     */
    protected static final String MSG_ID_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getMsgId() <em>Msg Id</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMsgId()
     * @generated
     * @ordered
     */
    protected String msgId = MSG_ID_EDEFAULT;

    /**
     * The default value of the '{@link #getMsgLocale() <em>Msg Locale</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMsgLocale()
     * @generated
     * @ordered
     */
    protected static final String MSG_LOCALE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getMsgLocale() <em>Msg Locale</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMsgLocale()
     * @generated
     * @ordered
     */
    protected String msgLocale = MSG_LOCALE_EDEFAULT;

    /**
     * The cached value of the '{@link #getMsgCatalogTokens() <em>Msg Catalog Tokens</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getMsgCatalogTokens()
     * @generated
     * @ordered
     */
    protected EList msgCatalogTokens = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MsgDataElementImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getMsgDataElement();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getMsgIdType() {
        return msgIdType;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setMsgIdType(String newMsgIdType) {
        String oldMsgIdType = msgIdType;
        msgIdType = newMsgIdType;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.MSG_DATA_ELEMENT__MSG_ID_TYPE, oldMsgIdType, msgIdType));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getMsgCatalogType() {
        return msgCatalogType;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setMsgCatalogType(String newMsgCatalogType) {
        String oldMsgCatalogType = msgCatalogType;
        msgCatalogType = newMsgCatalogType;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG_TYPE, oldMsgCatalogType, msgCatalogType));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getMsgCatalog() {
        return msgCatalog;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setMsgCatalog(String newMsgCatalog) {
        String oldMsgCatalog = msgCatalog;
        msgCatalog = newMsgCatalog;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG, oldMsgCatalog, msgCatalog));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getMsgCatalogId() {
        return msgCatalogId;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setMsgCatalogId(String newMsgCatalogId) {
        String oldMsgCatalogId = msgCatalogId;
        msgCatalogId = newMsgCatalogId;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG_ID, oldMsgCatalogId, msgCatalogId));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getMsgId() {
        return msgId;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setMsgId(String newMsgId) {
        String oldMsgId = msgId;
        msgId = newMsgId;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.MSG_DATA_ELEMENT__MSG_ID, oldMsgId, msgId));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getMsgLocale() {
        return msgLocale;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setMsgLocale(String newMsgLocale) {
        String oldMsgLocale = msgLocale;
        msgLocale = newMsgLocale;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.MSG_DATA_ELEMENT__MSG_LOCALE, oldMsgLocale, msgLocale));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getMsgCatalogTokens() {
        if (msgCatalogTokens == null) {
            msgCatalogTokens = new EObjectContainmentEList(MsgCatalogToken.class, this, EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG_TOKENS);
        }
        return msgCatalogTokens;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG_TOKENS :
                    return ((InternalEList) getMsgCatalogTokens()).basicRemove(otherEnd, msgs);
                default :
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.MSG_DATA_ELEMENT__MSG_ID_TYPE :
                return getMsgIdType();
            case EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG_TYPE :
                return getMsgCatalogType();
            case EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG :
                return getMsgCatalog();
            case EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG_ID :
                return getMsgCatalogId();
            case EventPackage.MSG_DATA_ELEMENT__MSG_ID :
                return getMsgId();
            case EventPackage.MSG_DATA_ELEMENT__MSG_LOCALE :
                return getMsgLocale();
            case EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG_TOKENS :
                return getMsgCatalogTokens();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.MSG_DATA_ELEMENT__MSG_ID_TYPE :
                setMsgIdType((String) newValue);
                return;
            case EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG_TYPE :
                setMsgCatalogType((String) newValue);
                return;
            case EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG :
                setMsgCatalog((String) newValue);
                return;
            case EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG_ID :
                setMsgCatalogId((String) newValue);
                return;
            case EventPackage.MSG_DATA_ELEMENT__MSG_ID :
                setMsgId((String) newValue);
                return;
            case EventPackage.MSG_DATA_ELEMENT__MSG_LOCALE :
                setMsgLocale((String) newValue);
                return;
            case EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG_TOKENS :
                getMsgCatalogTokens().clear();
                getMsgCatalogTokens().addAll((Collection) newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.MSG_DATA_ELEMENT__MSG_ID_TYPE :
                setMsgIdType(MSG_ID_TYPE_EDEFAULT);
                return;
            case EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG_TYPE :
                setMsgCatalogType(MSG_CATALOG_TYPE_EDEFAULT);
                return;
            case EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG :
                setMsgCatalog(MSG_CATALOG_EDEFAULT);
                return;
            case EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG_ID :
                setMsgCatalogId(MSG_CATALOG_ID_EDEFAULT);
                return;
            case EventPackage.MSG_DATA_ELEMENT__MSG_ID :
                setMsgId(MSG_ID_EDEFAULT);
                return;
            case EventPackage.MSG_DATA_ELEMENT__MSG_LOCALE :
                setMsgLocale(MSG_LOCALE_EDEFAULT);
                return;
            case EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG_TOKENS :
                getMsgCatalogTokens().clear();
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.MSG_DATA_ELEMENT__MSG_ID_TYPE :
                return MSG_ID_TYPE_EDEFAULT == null ? msgIdType != null : !MSG_ID_TYPE_EDEFAULT.equals(msgIdType);
            case EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG_TYPE :
                return MSG_CATALOG_TYPE_EDEFAULT == null ? msgCatalogType != null : !MSG_CATALOG_TYPE_EDEFAULT.equals(msgCatalogType);
            case EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG :
                return MSG_CATALOG_EDEFAULT == null ? msgCatalog != null : !MSG_CATALOG_EDEFAULT.equals(msgCatalog);
            case EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG_ID :
                return MSG_CATALOG_ID_EDEFAULT == null ? msgCatalogId != null : !MSG_CATALOG_ID_EDEFAULT.equals(msgCatalogId);
            case EventPackage.MSG_DATA_ELEMENT__MSG_ID :
                return MSG_ID_EDEFAULT == null ? msgId != null : !MSG_ID_EDEFAULT.equals(msgId);
            case EventPackage.MSG_DATA_ELEMENT__MSG_LOCALE :
                return MSG_LOCALE_EDEFAULT == null ? msgLocale != null : !MSG_LOCALE_EDEFAULT.equals(msgLocale);
            case EventPackage.MSG_DATA_ELEMENT__MSG_CATALOG_TOKENS :
                return msgCatalogTokens != null && !msgCatalogTokens.isEmpty();
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy())
            return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (msgIdType: ");
        result.append(msgIdType);
        result.append(", msgCatalogType: ");
        result.append(msgCatalogType);
        result.append(", msgCatalog: ");
        result.append(msgCatalog);
        result.append(", msgCatalogId: ");
        result.append(msgCatalogId);
        result.append(", msgId: ");
        result.append(msgId);
        result.append(", msgLocale: ");
        result.append(msgLocale);
        result.append(", msgCatalogTokens: ");
        result.append(msgCatalogTokens);
        result.append(')');
        
        return result.toString();
    }

    /**
     * Checks whether the contents of this object conforms to the
     * CBE specification.
     *
     * @throws ValidationException 
     *                       if the object does not follow the 
     *                       CBE specification.
     */
    public void validate() throws ValidationException {

        synchronized(this){
	
	        // checking for required attributes	
	        EventValidation.validateRequiredProperties(CLASS_NAME, this);
	
	        // checking for boundaries
	        EAttribute attrMI = EventPackage.eINSTANCE.getMsgDataElement_MsgId();
	        EventValidation.validateLength(CLASS_NAME, this, attrMI, 256);
	
	        EAttribute attrMIT = EventPackage.eINSTANCE.getMsgDataElement_MsgIdType();
	        EventValidation.validateLength(CLASS_NAME, this, attrMIT, 32);
	
	        EAttribute attrMCI = EventPackage.eINSTANCE.getMsgDataElement_MsgCatalogId();
	        EventValidation.validateLength(CLASS_NAME, this, attrMCI, 64);
	
	        EAttribute attrMC = EventPackage.eINSTANCE.getMsgDataElement_MsgCatalog();
	        EventValidation.validateLength(CLASS_NAME, this, attrMC, 128);
	
	        EAttribute attrMCT = EventPackage.eINSTANCE.getMsgDataElement_MsgCatalogType();
	        EventValidation.validateLength(CLASS_NAME, this, attrMCT, 32);
	
	        EAttribute attr = EventPackage.eINSTANCE.getMsgDataElement_MsgLocale();
	        EventValidation.validateLength(CLASS_NAME, this, attr, 11);
	
	        if (getMsgCatalogTokens() != null) {
	            
	            ListIterator it = getMsgCatalogTokens().listIterator();
	            MsgCatalogToken msgCatalogToken = null;
	            
	            while (it.hasNext()) {
	                
	                msgCatalogToken = ((MsgCatalogToken)(it.next()));
	                
	                try {
	                    msgCatalogToken.validate();
	                } 
	                catch (ValidationException v) {
	                    throw new ValidationException(EventHelpers.getString("LOG_INVALID_LIST_ELEMENT_ATTRIBUTE_EXC_",EventValidation.getComponentName(msgCatalogToken).concat("[").concat(String.valueOf(it.nextIndex())).concat("]")),v);
	                }
	            }
	        }
	        	
	        // check for 'required' attributes
	        // if msgCatalog, must also have msgCatalogType and msgCatalogId
	        String mymc = getMsgCatalog();
	        String mymcType = getMsgCatalogType();
	        String mymcId = getMsgCatalogId();
	
	        if (!(((mymc == null) && (mymcType == null) && (mymcId == null)) || ((mymc != null) && (mymcType != null) && (mymcId != null)))) {
	            throw new ValidationException(EventHelpers.getString("LOG_MISSING_ATTRIBUTES_EXC_", "[" + EventValidation.getComponentName(this, attrMC.getName()) + ", " + EventValidation.getComponentName(this, attrMCI.getName()) + ", " + EventValidation.getComponentName(this, attrMCT.getName()) + "]"));
	        }
	
	        String myId = getMsgId();
	        String myType = getMsgIdType();
	        
	        if (!(((myId == null) && (myType == null)) || ((myId != null) && (myType != null)))) {
	            throw new ValidationException(EventHelpers.getString("LOG_MISSING_ATTRIBUTES_EXC_", "[" + EventValidation.getComponentName(this, attrMI.getName()) + ", " + EventValidation.getComponentName(this, attrMIT.getName()) + "]"));
	        }
        }
    }

    /** 
     * @see org.eclipse.hyades.logging.events.cbe.MsgDataElement#addMsgCatalogToken(org.eclipse.hyades.logging.events.cbe.MsgCatalogToken)
     */
    public MsgCatalogToken addMsgCatalogToken(MsgCatalogToken value) {
        getMsgCatalogTokens().add(value);
        return value;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.MsgDataElement#addMsgCatalogTokenAsString(String)
     */
    public MsgCatalogToken addMsgCatalogTokenAsString(String value) {
        MsgCatalogToken mct = EventFactory.eINSTANCE.createMsgCatalogToken();
        mct.setValue(value);
        return addMsgCatalogToken(mct);
    }

    /**
     * Removes all msgCatalogTokens that this event is referencing 
     */
    public void clearMsgCatalogTokens() {
        getMsgCatalogTokens().clear();
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.MsgDataElement#getMsgCatalogTokensAsStrings()
     */
    public String[] getMsgCatalogTokensAsStrings() {
        EList tokens = getMsgCatalogTokens();
        String[] strTokens = new String[tokens.size()];
        for (int i = 0; i < tokens.size(); i++) {
        	MsgCatalogToken element_i = (MsgCatalogToken) tokens.get(i);
        	if (element_i == null)
        		strTokens[i] = null;
        	else
        		strTokens[i] = new String((element_i).getValue());
        }
        return strTokens;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.MsgDataElement#setMsgCatalogTokensAsStrings(String[])
     */
    public void setMsgCatalogTokensAsStrings(String[] msgCatalogTokens) {
        EList tokens = getMsgCatalogTokens();
        tokens.clear();
        MsgCatalogToken mct;
        for (int i = 0; i < msgCatalogTokens.length; i++) {
            mct = EventFactory.eINSTANCE.createMsgCatalogToken();
            mct.setValue(msgCatalogTokens[i]);
            tokens.add(mct);
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.MsgDataElement#setMsgCatalogTokens(org.eclipse.hyades.logging.events.cbe.MsgCatalogToken[])
     */
    public void setMsgCatalogTokens(MsgCatalogToken[] msgCatalogTokens) {
        EList tokens = getMsgCatalogTokens();
        tokens.clear();
        tokens.addAll(Arrays.asList(msgCatalogTokens));
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object arg0) {

        synchronized(this){
            return EventHelpers.compareEObject(this, arg0);
        }
    }

    /*
     * Private methods.
     */

    /**
     * Required to circumvent a problem with de/serializing EMF ELists with RMI over IIOP by 
     * converting EMF ELists to Lists.  
     * 
     * @see java.io.Serializable
     */
    private void writeObject(java.io.ObjectOutputStream out) throws IOException {

        synchronized(this){
            EventHelpers.serializableWrite(this, out);
        }
    }

    /**
     * Required to circumvent a problem with de/serializing EMF ELists with RMI over IIOP by 
     * converting EMF ELists to Lists.  
     * 
     * @see java.io.Serializable
     */
    private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {

        synchronized(this){
            EventHelpers.serializableRead(this, in);
        }
    }

    /**
     * return a cloned (copy by value) object. This is a deep copy version, in which all the
     * objects within this object will be copied by value.
     *  
     * @return Object
     */
    public Object clone() throws CloneNotSupportedException {

        synchronized(this){
            return EcoreUtil.copy(this);
        }       
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        setMsgCatalog(MSG_CATALOG_EDEFAULT);
        setMsgCatalogId(MSG_CATALOG_ID_EDEFAULT);
        setMsgCatalogType(MSG_CATALOG_TYPE_EDEFAULT);
        setMsgId(MSG_ID_EDEFAULT);
        setMsgIdType(MSG_ID_TYPE_EDEFAULT);
        setMsgLocale(MSG_LOCALE_EDEFAULT);

        clearMsgCatalogTokens();
    }
} //MsgDataElementImpl
