package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.Test;
import junit.framework.TestSuite;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AllTests.java,v 1.3 2005/02/16 22:20:40 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * JUnit test suite for the CBE implementation. 
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 */
public class AllTests {

    public static Test suite() {
        TestSuite suite = new TestSuite("Test for org.eclipse.hyades.logging.events.cbe.impl.tests");
        //$JUnit-BEGIN$
        suite.addTest(new TestSuite(AssociatedEventImplTest.class));
        suite.addTest(new TestSuite(AssociationEngineImplTest.class));
        suite.addTest(new TestSuite(AvailableSituationImplTest.class));
        suite.addTest(new TestSuite(CommonBaseEventImplTest.class));
        suite.addTest(new TestSuite(ComponentIdentificationImplTest.class));
        suite.addTest(new TestSuite(ConfigureSituationImplTest.class));
        suite.addTest(new TestSuite(ConnectSituationImplTest.class));
        suite.addTest(new TestSuite(ContextDataElementImplTest.class));
        suite.addTest(new TestSuite(CreateSituationImplTest.class));
        suite.addTest(new TestSuite(DependencySituationImplTest.class));
        suite.addTest(new TestSuite(EventFactoryImplTest.class));
        suite.addTest(new TestSuite(EventFactoryObjectFactoryTest.class));
        suite.addTest(new TestSuite(EventPackageImplTest.class));
        suite.addTest(new TestSuite(ExtendedDataElementImplTest.class));
        suite.addTest(new TestSuite(MsgCatalogTokenImplTest.class));
        suite.addTest(new TestSuite(MsgDataElementImplTest.class));
        suite.addTest(new TestSuite(SituationImplTest.class));
        suite.addTest(new TestSuite(DestroySituationImplTest.class));
        suite.addTest(new TestSuite(FeatureSituationImplTest.class));
        suite.addTest(new TestSuite(OtherSituationImplTest.class));
        suite.addTest(new TestSuite(ReportSituationImplTest.class));
        suite.addTest(new TestSuite(RequestSituationImplTest.class));
        suite.addTest(new TestSuite(StartSituationImplTest.class));
        suite.addTest(new TestSuite(StopSituationImplTest.class));
        //$JUnit-END$
        return suite;
    }
}
