package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AssociationEngineImplTest.java,v 1.6 2005/02/16 22:20:40 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * @author Scott Brown
 * @version 1.0.1
 * @since 1.0.1
 */
public class AssociationEngineImplTest extends TestCase {
    AssociationEngine ae = null;

    /**
     * Constructor for AssociationEngineImplTest.
     * @param arg0
     */
    public AssociationEngineImplTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();

        ae = EventFactory.eINSTANCE.createAssociationEngine();
    }

    public void testValidate1() throws ValidationException {
        ae = EventFactory.eINSTANCE.createAssociationEngine();
        ae.setName("ae test");
        ae.setType("Type");
        ae.setId(Util.getAlphaString(64));
        ae.validate();
    }

    public void testRequiredAttributes() throws ValidationException {
        ae.setName("ae test");
        ae.setType("Type");
        ae.setId(Util.getAlphaString(64));
        ae.validate();

        ae = EventFactory.eINSTANCE.createAssociationEngine();
        Util.assertMissingAttributes(ae, "all");

        ae.setName("ae test");
        ae.setType("Type");
        //ae.setId(Util.getAlphaString(64));
        Util.assertMissingAttributes(ae, "id");

        ae = EventFactory.eINSTANCE.createAssociationEngine();
        ae.setName("ae test");
        //ae.setType("Type");
        ae.setId(Util.getAlphaString(64));
        Util.assertMissingAttributes(ae, "type");

        ae = EventFactory.eINSTANCE.createAssociationEngine();
        //ae.setName("ae test");
        ae.setType("Type");
        ae.setId(Util.getAlphaString(64));
        Util.assertMissingAttributes(ae, "name");
    }

    public void testInvalidAttributes() {
        ae.setName(Util.getAlphaString(64));
        ae.setType(Util.getAlphaString(64));
        ae.setId(Util.getAlphaString(64));
        Util.assertValidBoundaries(ae);

        ae.setName(Util.getAlphaString(65));
        Util.assertInvalidBoundaries(ae, "name");

        ae.setName(Util.getAlphaString(64));
        ae.setType(Util.getAlphaString(65));
        Util.assertInvalidBoundaries(ae, "type");

        ae.setType(Util.getAlphaString(64));
        ae.setId(Util.getAlphaString(65));
        try {
            ae.validate();
            fail("id too long");
        }
        catch (ValidationException ve) {
            Util.assertExceptionId("IWAT0206E", ve);
        }
    }

    public void testToString() {
        String name = "my name";
        String type = "my type";
        String id = "my id";

        ae = EventFactory.eINSTANCE.createAssociationEngine();
        //System.out.println(ae);
        assertNotNull("empty ae", ae.toString());

        ae.setName(name);
        ae.setType(type);
        ae.setId(id);
        //System.out.println(ae);
        assertNotNull("ae with soma data filled in", ae.toString());
    }

    public void testGetSet() throws ValidationException {
        String name = "my name";
        String type = "my type";
        String id = "my id";

        ae = EventFactory.eINSTANCE.createAssociationEngine();
        ae.setName(name);
        ae.setType(type);
        ae.setId(id);

        assertEquals(name, ae.getName());
        assertEquals(type, ae.getType());
        assertEquals(id, ae.getId());
    }

    /**
     * Tests the <code>equals</code> operator.
     */
    public void testEquals() {
        AssociationEngine ae1 = EventFactory.eINSTANCE.createAssociationEngine();
        ae1.setName("ae test");
        ae1.setType("Type");
        ae1.setId("AE345678901234567890123456789012");

        AssociationEngine ae2 = EventFactory.eINSTANCE.createAssociationEngine();
        ae2.setName("ae test");
        ae2.setType("Type");
        ae2.setId("A2345678901234567890123456789012");

        AssociationEngine ae3 = (AssociationEngine) Util.clone(ae1);
        assertEquals(ae1, ae3);

        AssociationEngine ae4 = (AssociationEngine) Util.clone(ae2);
        assertEquals(ae2, ae4);

        assertFalse(ae1.equals(ae2));
    }
}
