package org.eclipse.hyades.logging.events.cbe.impl.tests;

import java.io.Serializable;

import javax.naming.CompositeName;
import javax.naming.Reference;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryImpl;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryObjectFactory;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EventFactoryObjectFactoryTest.java,v 1.7 2005/04/28 14:49:15 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 *
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 */
public class EventFactoryObjectFactoryTest extends TestCase implements Serializable {

    /**
     * Stream-Unique IDentifier (SUID) of this class.
     * <p>
     * NOTE:  This value MUST not be modified unless an incompatible 
     *        change is introduced.  
     * <p>
     * See the 'Java Object Serialization Specification' for more details.
     * <p>
     * Compatible changes include:
     * <ul>
     * <li>Adding, modifying access or modifying <code>static</code>/<code>transient</code> to non-<code>static</code>/non-<code>transient</code> of fields.</li>
     * <li>Adding or removing classes.</li>
     * <li>Adding or removing <code>writeObject</code>/<code>readObject</code> methods.</li>
     * <li>Adding <code>java.io.Serializable</code> inheritance.</li>
     * </ul>
     * <p>
     * Incompatible changes include:
     * <ul>
     * <li>Deleting, modifying non-<code>static</code>/non-<code>transient</code> to <code>static</code>/<code>transient</code> or modifying the declared type of fields.</li>
     * <li>Modifying the hierarchy or interchanging/removing <code>java.io.Serializable</code>/<code>java.io.Externalizable</code> inheritance of the class.</li>
     * <li>Modifying <code>writeObject</code>/<code>readObject</code> methods.</li>
     * <li>Adding <code>writeReplace</code>/<code>readResolve</code> methods.</li>
     * </ul>
     */
    private static final long serialVersionUID = -6182976151135299477L;

    /**
     * Constructor for EventFactoryObjectFactoryTest.
     * @param arg0
     */
    public EventFactoryObjectFactoryTest(String testcase) {
        super(testcase);
    }

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * Tests whether an <code>EventFactory</code> can be bound to JNDI and 
     * rebuilt back.
     */
    public void testGetObjectInstance() throws Exception {
        final String EXTENSION_NAME = "Example";
        ContentHandler mockHandler = new MockHandler(EXTENSION_NAME);
        EventFactoryImpl efi = new EventFactoryImpl();
        efi.setContentHandler(mockHandler);

        Reference ref = efi.getReference();

        EventFactoryObjectFactory efof = new EventFactoryObjectFactory();
        EventFactory ef = (EventFactory) efof.getObjectInstance(ref, new CompositeName("AA"), null, null);
        assertNotNull("Returned factory cannot be null", ef);

        CommonBaseEvent event = ef.createCommonBaseEvent("someExtension");
        event.complete();

        assertEquals("Mediation must change extension name", event.getExtensionName(), EXTENSION_NAME);
    }

    /*
     * Private methods. 
     */

    /**
     * 
     */
    public class MockHandler implements ContentHandler, Serializable {

        /**
         * Stream-Unique IDentifier (SUID) of this class.
         * <p>
         * NOTE:  This value MUST not be modified unless an incompatible 
         *        change is introduced.  
         * <p>
         * See the 'Java Object Serialization Specification' for more details.
         * <p>
         * Compatible changes include:
         * <ul>
         * <li>Adding, modifying access or modifying <code>static</code>/<code>transient</code> to non-<code>static</code>/non-<code>transient</code> of fields.</li>
         * <li>Adding or removing classes.</li>
         * <li>Adding or removing <code>writeObject</code>/<code>readObject</code> methods.</li>
         * <li>Adding <code>java.io.Serializable</code> inheritance.</li>
         * </ul>
         * <p>
         * Incompatible changes include:
         * <ul>
         * <li>Deleting, modifying non-<code>static</code>/non-<code>transient</code> to <code>static</code>/<code>transient</code> or modifying the declared type of fields.</li>
         * <li>Modifying the hierarchy or interchanging/removing <code>java.io.Serializable</code>/<code>java.io.Externalizable</code> inheritance of the class.</li>
         * <li>Modifying <code>writeObject</code>/<code>readObject</code> methods.</li>
         * <li>Adding <code>writeReplace</code>/<code>readResolve</code> methods.</li>
         * </ul>
         */
        private static final long serialVersionUID = -3409120821201617507L;

        private String extensionName;

        public MockHandler(String name) {
            extensionName = name;
        }
        public void completeEvent(CommonBaseEvent event) throws CompletionException {
            event.setExtensionName(extensionName);
        }
    }
}
