package org.eclipse.hyades.logging.events.cbe.tests;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.MissingPropertyException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MissingPropertyExceptionTest.java,v 1.6 2005/03/10 14:51:13 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * MissingPropertyExceptionTest class.
 * <p>
 * 
 * 
 * @author Denilson Nastacio
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 */
public class MissingPropertyExceptionTest extends TestCase {
    /**
     * Constructor for MissingPropertyExceptionTest.
     * @param arg0
     */
    public MissingPropertyExceptionTest(String arg0) {
        super(arg0);
    }

    /*
     * Test for void MissingPropertyException()
     */
    public void testMissingPropertyException() {
        
        MissingPropertyException e  = new MissingPropertyException();
        
        assertEquals(e.getMessage(),"null");
        
        assertNull(e.getCause());
    }

    /*
     * Test for void MissingPropertyException(String, String)
     */
    public void testMissingPropertyExceptionStringString() {
        
        MissingPropertyException e = new MissingPropertyException("LOG_INVALID_JNDI_REFERENCE_EXC_","org.eclipse.hyades.logging.core.properties.plugin");

        assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_", null);

        assertNull(e.getCause());
    }

    /*
     * Test for void MissingPropertyException(String, String) (missing resource bundle)
     */
    public void testMissingPropertyExceptionStringStringMissingResourceBundle() {
        
        MissingPropertyException e = new MissingPropertyException("LOG_INVALID_JNDI_REFERENCE_EXC_","MISSING_RESOURCE_BUNDLE");

        assertEquals("Can't find bundle for base name MISSING_RESOURCE_BUNDLE, locale en : LOG_INVALID_JNDI_REFERENCE_EXC_", e.getMessage());

        assertNull(e.getCause());
    }

    /*
     * Test for void MissingPropertyException(String, String) (missing resource key)
     */
    public void testMissingPropertyExceptionStringStringMissingResourceKey() {
        
        MissingPropertyException e = new MissingPropertyException("MISSING_RESOURCE_KEY","org.eclipse.hyades.logging.core.properties.plugin");

        assertEquals("Can't find resource for bundle java.util.PropertyResourceBundle, key MISSING_RESOURCE_KEY : MISSING_RESOURCE_KEY", e.getMessage());

        assertNull(e.getCause());
    }

    /*
     * Test for void MissingPropertyException(String, String, Object[])
     */
    public void testMissingPropertyExceptionStringStringObjectArray() {
        
        String[] parameters = new String[]{"valueOne"};
        MissingPropertyException e = new MissingPropertyException("LOG_INVALID_JNDI_REFERENCE_EXC_","org.eclipse.hyades.logging.core.properties.plugin", parameters);

        assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_", parameters);

        assertNull(e.getCause());
    }

    /*
     * Test for void MissingPropertyException(String, String, Object[]) (missing resource bundle)
     */
    public void testMissingPropertyExceptionStringStringObjectArrayMissingResourceBundle() {
        
        MissingPropertyException e = new MissingPropertyException("LOG_INVALID_JNDI_REFERENCE_EXC_","MISSING_RESOURCE_BUNDLE", new String[]{"valueOne"});

        assertEquals("Can't find bundle for base name MISSING_RESOURCE_BUNDLE, locale en : LOG_INVALID_JNDI_REFERENCE_EXC_ {valueOne}", e.getMessage());

        assertNull(e.getCause());
    }

    /*
     * Test for void MissingPropertyException(String, String, Object[]) (missing resource key)
     */
    public void testMissingPropertyExceptionStringStringObjectArrayMissingResourceKey() {
        
        MissingPropertyException e = new MissingPropertyException("MISSING_RESOURCE_KEY","org.eclipse.hyades.logging.core.properties.plugin", new String[]{"valueOne"});

        assertEquals("Can't find resource for bundle java.util.PropertyResourceBundle, key MISSING_RESOURCE_KEY : MISSING_RESOURCE_KEY {valueOne}", e.getMessage());

        assertNull(e.getCause());
    }

   /*
    * Test for void MissingPropertyException(String, String, Object[], Throwable)
    */
   public void testMissingPropertyExceptionStringStringObjectArrayThrowable() {
       
       String[] parameters = new String[]{"valueOne"};
       Exception cause = new Exception("Linked Exception");
       MissingPropertyException e = new MissingPropertyException("LOG_INVALID_JNDI_REFERENCE_EXC_","org.eclipse.hyades.logging.core.properties.plugin", parameters, cause);

       assertEquals("IWAT0187E The reference obtained from the specified JNDI name is not a reference to an event factory.\nJNDI name: valueOne : Linked Exception", e.getMessage());

       assertEquals(cause, e.getCause());
   }

   /*
    * Test for void MissingPropertyException(String, String, Object[], Throwable) (missing resource bundle)
    */
   public void testMissingPropertyExceptionStringStringObjectArrayThrowableMissingResourceBundle() {
       
       Exception cause = new Exception("Linked Exception");
       MissingPropertyException e = new MissingPropertyException("LOG_INVALID_JNDI_REFERENCE_EXC_","MISSING_RESOURCE_BUNDLE", new String[]{"valueOne"}, cause);

       assertEquals("Can't find bundle for base name MISSING_RESOURCE_BUNDLE, locale en : LOG_INVALID_JNDI_REFERENCE_EXC_ {valueOne} : Linked Exception", e.getMessage());

       assertEquals(cause, e.getCause());
   }

   /*
    * Test for void MissingPropertyException(String, String, Object[], Throwable) (missing resource key)
    */
   public void testMissingPropertyExceptionStringStringObjectArrayThrowableMissingResourceKey() {
       
       Exception cause = new Exception("Linked Exception");
       MissingPropertyException e = new MissingPropertyException("MISSING_RESOURCE_KEY","org.eclipse.hyades.logging.core.properties.plugin", new String[]{"valueOne"},cause);

       assertEquals("Can't find resource for bundle java.util.PropertyResourceBundle, key MISSING_RESOURCE_KEY : MISSING_RESOURCE_KEY {valueOne} : Linked Exception", e.getMessage());

       assertEquals(cause, e.getCause());
   }
   
   /*
    * Test for void MissingPropertyException(String)
    */
   public void testMissingPropertyExceptionString() {

       MissingPropertyException e = new MissingPropertyException(EventHelpers.getString("LOG_INVALID_JNDI_REFERENCE_EXC_","a" ));
       
       assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_", new Object[] { "a" });
       
       assertNull(e.getCause());
   }

    /*
     * Test for void MissingPropertyException(String, Throwable)
     */
    public void testMissingPropertyExceptionStringThrowable() {

        Exception cause = new Exception("Linked Exception");

        MissingPropertyException e = new MissingPropertyException(EventHelpers.getString("LOG_INVALID_JNDI_REFERENCE_EXC_","a" ), cause);
        
        assertEquals(e.getMessage(),"IWAT0187E The reference obtained from the specified JNDI name is not a reference to an event factory.\nJNDI name: a : Linked Exception");
        
        assertEquals(cause, e.getCause());
    }

    /*
     * Test for void MissingPropertyException(Throwable)
     */
    public void testMissingPropertyExceptionThrowable() {

        Exception linkedException = new Exception();

        MissingPropertyException e = new MissingPropertyException(linkedException);

        assertEquals(e.getMessage(),"null");
        
        assertEquals(linkedException, e.getCause());
    }

    /*
     * Package methods.
     */

    /**
     * Verifies whether the exception contains a message that matches the
     * resource key in the event resource bundle.
     */
    static void assertExceptionMsg(MissingPropertyException e, String msgKey, Object[] params) {
        assertEquals(EventHelpers.getString(msgKey,params), e.getLocalizedMessage());
    }
}
