package org.eclipse.hyades.logging.events.cbe.util;

import java.security.BasicPermission;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EventPermission.java,v 1.4 2005/02/16 22:20:40 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * A permission-based security permission specific to event operations.
 * <p>
 * The <code>EventPermission</code> is used by the system's <code>SecurityManager</code> 
 * for the context of the currently executing thread to see if the caller has permission to 
 * execute event operations running with a <code>SecurityManager</code>. 
 * <p>
 * Currently, there only exists one named event permission, namely "factory".  This named
 * event permission is used to execute event factory home operations such as create, retrieve, 
 * update and release event factory instances.  The caller has permission if the 
 * <code>EventPermission("factory")</code> permission has been explicitly granted to the caller.
 * <p>  
 * Event permissions are typically created by the security policy code based on a security policy file.
 * <p>
 *
 * @author Paul E Slauenwhite
 * @version 1.0.1
 * @since 1.0.1 
 * @see java.security.BasicPermission
 * @deprecated As of Hyades M10, Java permission-based security is no longer supported. 
 */
public class EventPermission extends BasicPermission {

    /**
     * Creates a new named event permission with no actions.
     * <p>
     * Currently, the only supported named event permission is 
     * "factory".  
     * <p>
     * By definition, event permissions do not have actions.
     * <p>
     * Event permissions are typically created by the security policy 
     * code based on a security policy file.
     * <p>
     * 
     * @param name The name of the event permission (e.g. "factory").
     * @param actions Must be null or an empty string.
     * @throws IllegalArgumentException If the name parameter is not "factory" or the actions parameter is not null or not an empty string.
     */
    public EventPermission(String name, String actions) throws IllegalArgumentException {

        super(name);

        if ((actions != null) && (name.trim().length() > 0)) {
            throw new IllegalArgumentException("Illegal Event Permission actions");
        }

        if ((name == null) || (!name.trim().equalsIgnoreCase("factory"))) {
            throw new IllegalArgumentException("Illegal Event Permission name");
        }
    }

    /**
     * Creates a new named event permission with no actions.
     * <p>
     * Currently, the only supported named event permission is 
     * "factory".  
     * <p>
     * By definition, event permissions do not have actions.
     * <p>
     * Event permissions are typically created by the security policy 
     * code based on a security policy file.
     * <p>
     * 
     * @param name The name of the event permission (e.g. "factory").
     * @throws IllegalArgumentException If the name parameter is not "factory" or the actions parameter is not null or not an empty string.
     */
    public EventPermission(String name) throws IllegalArgumentException {
        this(name, null);
    }
}
