/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JavaTaskExecutableObjectSkeleton.java,v 1.4 2005/02/16 22:20:26 qiyanli Exp $
 *
 * Contributors:
 * IBM Rational - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.remote;

import org.eclipse.hyades.execution.core.impl.IJavaTaskExecutableObject;

/**
 * Implemented in this class are the semantics of running a test within the
 * same process as the session context.
 */
public class JavaTaskExecutableObjectSkeleton
	extends ExecutableObjectSkeleton
	implements IJavaTaskExecutableObject {
	
	private Thread jobRunner;
	
	private boolean runAsThread=true;

	/**
	 * @see org.eclipse.hyades.execution.core.impl.IJavaTaskExecutableObject.run()
	 */
	public void run() {
		((IJavaTaskExecutableObject)delegate).run();
	}

	/**
	 * Spin a thread, within the context of which, <code>run()</code> will be called.
	 * This method returns without <code>run()</code> having necessarily been called.
	 * <code>run()</code> will not be called until the containing executor instance
	 * gives the go-ahead (via the START_TEST command).
	 * 
	 * @see org.eclipse.hyades.execution.core.impl.IJavaTaskExecutableObject#start()
	 */
	public void start() {
		if(runAsThread) {
			jobRunner = new Thread(new JobRunnable(), "JavaTaskExecutableObjectSkeleton Runner");
			jobRunner.setDaemon(true);
			jobRunner.start();
		}
		else {
			// Wait until it's okay to start the test.
			JavaTaskExecutorSkeleton executorSkel =
				 (JavaTaskExecutorSkeleton)((IJavaTaskExecutableObject)delegate).getExecutor();
				 executorSkel.waitForOKToStart();
	
			 // Run the test.
			 System.out.println("JavaTaskExecutableObjectSkeleton: Running test");
			 JavaTaskExecutableObjectSkeleton.this.run();
			 System.out.println("JavaTaskExecutableObjectSkeleton: Running test complete");
		}
		
	}

	/**
	 * This implementation calls <code>Thread.stop()</code>, which is deprecated.
	 * We'll need to find another way for the test to find out that it is supposed
	 * to stop running and do so in an orderly fashion.
	 * 
	 * @see org.eclipse.hyades.execution.core.impl.IJavaTaskExecutableObject#stop()
	 */
	public void stop() {
		jobRunner.stop();
	}
	
	public void runAsSeparateThread(boolean value) {
		runAsThread=value;
	}
	
	// Run the test in the context of a seperate thread. The test run will not
	// proceed until the containing executor has received a START_TEST command.
	private class JobRunnable implements Runnable {
		public void run() {
			
			// Wait until it's okay to start the test.
			JavaTaskExecutorSkeleton executorSkel =
				(JavaTaskExecutorSkeleton)((IJavaTaskExecutableObject)delegate).getExecutor();
			executorSkel.waitForOKToStart();
			
			// Run the test.
			System.out.println("JavaTaskExecutableObjectSkeleton: Running test");
			JavaTaskExecutableObjectSkeleton.this.run();
			System.out.println("JavaTaskExecutableObjectSkeleton: Running test complete");
		}
	}

}
