/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpRecorderPlugin.java,v 1.9 2005/04/22 14:51:05 bjiang Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.http;

import java.util.ResourceBundle;

import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.recorder.http.local.HttpRecorderAgentEnvironmentAdapter;
import org.eclipse.hyades.execution.recorder.http.local.HttpRecorderDataProcessor;
import org.eclipse.hyades.execution.recorder.http.local.HttpRecorderExecutableObjectAdapter;
import org.eclipse.hyades.execution.testgen.TestgenPlugin;
import org.eclipse.hyades.internal.execution.recorder.Recorder;
import org.eclipse.hyades.internal.execution.recorder.RecorderException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;


/**
 * The main class of the Recorder Harness
 * @author Ernest Jessee
 */
public class HttpRecorderPlugin extends AbstractUIPlugin
{
	public static final String PLUGIN_ID = "org.eclipse.hyades.execution.recorder.http"; //$NON-NLS-1$
	
	public static final String RECORDING_PATH = "recording_path"; //$NON-NLS-1$
	public static final String RECORDER_APP_ADAPTER="application_under_test"; //$NON-NLS-1$
	
	public static final String PROXY_PORT="default_proxy_port"; //$NON-NLS-1$

	public static final String DEFAULT_PORT="1080";		
	private static HttpRecorderPlugin plugin;
	private ResourceBundle resourceBundle;
	
	/**
	 * Stores a preference in the plugins preference store with the specified key and value 
	 * @param String key
	 * @param String value
	 */
	public static void storePreference(String key, String value)
	{
		getDefault().getPreferenceStore().setValue(key,value);
	}

	private Recorder recorder;

	/**
	 * Returns the plugin's resource bundle,
	 */
	private ResourceBundle getResourceBundle()
	{
		if(resourceBundle == null)
		{
		
			try
			{
				resourceBundle = Platform.getResourceBundle(Platform.getBundle(PLUGIN_ID));
			}
			catch (Exception e) {
				resourceBundle = null;
			}
		}
		
		return resourceBundle;
	}
	
	/**
	 * returns resource String from this plugin's resource bundle
	 * @param String key
	 * @return String
	 */
	public static String getResourceString(String key)
	{
		return HttpRecorderPlugin.getDefault().getResourceBundle().getString(key);
	}
	
	/**
	 * acquires a reference to a plugin preference specified by "key"
	 * @param key
	 * @return
	 */
	public static String getPreference(String key)
	{
		return getDefault().getPreferenceStore().getString(key);
	}
	
	/**
	 * acquires a reference to a plugin preference specified by "key"
	 * @param key
	 * @return
	 */
	public static boolean getBoolPreference(String key)
	{
		return getDefault().getPreferenceStore().getBoolean(key);
	}
	
		
	/**
	 * The constructor.
	 */
	public HttpRecorderPlugin()
	{
		super();
		plugin = this;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
			
		try
		{
			recorder = new Recorder("org.eclipse.hyades.execution.recorder.http", //$NON-NLS-1$
									new HttpRecorderDataProcessor(),
									new HttpRecorderAgentEnvironmentAdapter(),
									new HttpRecorderExecutableObjectAdapter());
		}
		catch (RecorderException e1)
		{
			e1.printStackTrace();
		}
				
		initializeDefaultPreferences(getPreferenceStore());
	}

	/**
	 * Returns the shared instance.
	 */
	public static HttpRecorderPlugin getDefault() {
		return plugin;
	}
	
	
	
	/**
	 * @return
	 */
	public Recorder getRecorder()
	{
		return recorder;
	}

	/**
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#initializeDefaultPreferences(org.eclipse.jface.preference.IPreferenceStore)
	 */
	protected void initializeDefaultPreferences(IPreferenceStore store)
	{	
		if (Platform.getOS().equals("win32"))
			store.setDefault(HttpRecorderPlugin.RECORDER_APP_ADAPTER,"org.eclipse.hyades.execution.recorder.RecorderApplication.InternetExplorer");//$NON-NLS-1$
		else
			store.setDefault(HttpRecorderPlugin.RECORDER_APP_ADAPTER,"-1");		  //$NON-NLS-1$
		TestgenPlugin.getDefault().getPreferenceStore().setDefault(TestgenPlugin.TEST_GENERATOR,TestgenPlugin.getDefault().getDefaultGeneratorID());		
		store.setDefault(HttpRecorderPlugin.PROXY_PORT,DEFAULT_PORT);		 //$NON-NLS-1$
		
	}
	
	/**
	 * Returns this plugin's id.
	 * @return String
	 */
	public static String getID()
	{
		return PLUGIN_ID;
	}
}
