/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: InsertColumnAction.java,v 1.5 2005/02/16 22:22:14 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.action;

import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.hyades.test.ui.datapool.internal.util.ContextIds;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * @author psun
 *
 */
public class InsertColumnAction extends SelectionProviderAction {
	private DatapoolTable table;

	public InsertColumnAction(ISelectionProvider viewer, DatapoolTable table)
	{
		super(viewer, DatapoolPlugin.getResourceString("INS_COL_TEXT")); //$NON-NLS-1$
		setDescription(DatapoolPlugin.getResourceString("INS_COL_LDESC")); //$NON-NLS-1$
		WorkbenchHelp.setHelp(this, DatapoolPlugin.getID() + ContextIds.INS_COL_ACT);
		this.table = table;
	}

	public void run()
	{
		if (table != null)
			table.insertColumn();
	}

	public void aboutToShow(boolean bShow)
	{
		setEnabled(bShow);
	}
	
}
