/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StringValueClass.java,v 1.5 2005/02/16 22:22:16 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.util;

import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDisplayValueClass;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/**
 * @author psun
 *
 */
public class StringValueClass implements IDisplayValueClass {

	public String getPropertyDescription(Object theObject)
	{
		if(theObject instanceof String)
			return (String)theObject;
		
		String returnString = null;
		if(theObject != null)
			returnString = theObject.toString();
		else
			returnString = new String();
		return returnString;
	}
	
	public Object getPropertyDisplay(Object theObject, Composite parent, boolean editable)
	{
		if(editable && theObject != null)
		{
			TextCellEditor cellEditor = new TextCellEditor(parent);
			cellEditor.setValue(theObject.toString());
			return cellEditor;
		}
		else
		{
			Label label = new Label(parent, SWT.NONE);
			label.setText(getPropertyDescription(theObject));
			return label;
		}
	}
	
	public Object getValueDisplay(Object theObject, Composite parent, boolean editable)
	{
		return null;
	}	
	
	
	public Object getUpdatedObject(Object theObject, Object display)
	{
		String input = (String)((TextCellEditor)display).getValue();
		
		if(theObject == null && (input == null || input.length() == 0))
			return theObject;			
			
		return input;
	}
}
