package org.eclipse.hyades.execution.local;
/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SessionStub.java,v 1.5 2005/06/03 03:18:53 sschneid Exp $
 * 
 * Contributors: 
 * Scapa - Initial API and implementation
 **********************************************************************/

import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.invocation.ReturnData;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;


public class SessionStub extends ExecutionComponentStub implements ISession {
	
	public SessionStub(IExecutionComponent delegate) {
		super(delegate);
	}

	/**
	 * @see 
	 */
	public void release() {
		ReturnData invokeRtn = delegateRemoteCall(new Class[]{}, new Object[]{}, "release");
		Object rtnValue = invokeRtn.getReturnValue();
		if(invokeRtn.isError()) {
			throw new RemoteInvocationException((Throwable)rtnValue);
		}
		
	}

	
	public void invokeRemote(CustomCommand command) {
		((SessionImpl)delegate).invokeRemote(command);
	}
	
	public Agent getAgent() {
		return ((SessionImpl)delegate).getAgent();
	}
	
	public void removeListener() {
		((SessionImpl)delegate).removeListener();
	}
	
	/**
	 * This implementation returns <code>this</code>.
	 * 
	 * @see org.eclipse.hyades.execution.invocation.IRemoteObject#getSessionContext()
	 */
	public ISession getSessionContext() {
		return this;
	}

}