/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: KeystoreHelper.java,v 1.4 2005/02/16 22:20:15 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.security;

/**
 * @author rduggan
 *
 */
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.NoSuchProviderException;
import java.io.File;
import java.io.IOException;
import java.io.FileOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class KeystoreHelper {
	
	
	public static KeyStore createKeyStore(String pathname, String password)
	   throws KeyStoreException,
	           NoSuchAlgorithmException,
	           CertificateException,
	           IOException,
	           NoSuchProviderException  {
	           	
	    KeyStore ks=KeyStore.getInstance("JKS");
		
		File file=new File(pathname);
		
		/* Do not stomp an existing file */
		if(!file.exists()) {
			ks.load(null, password.toCharArray());
			persistKeyStore(ks, pathname, password);
		}
		else {
			return loadKeyStore(pathname, password);
		}
		return ks;
	}
	
	public static KeyStore loadKeyStore(String pathname, String password)
	   throws KeyStoreException,
	           NoSuchAlgorithmException,
	           CertificateException,
	           IOException,
	           NoSuchProviderException  {
		
		KeyStore ks=null;
		File file=new File(pathname);
		
		/* Do not stomp an existing file */
		if(file.exists()) {
			ks=KeyStore.getInstance("JKS");
			/* Initialize the keystore with no information */
			FileInputStream is=new FileInputStream(file);
			ks.load(is, password.toCharArray());
			is.close();
		}
		return ks;
	}
	
	public static Certificate loadCertificate(String certFilename) 
	   throws CertificateException,
	           FileNotFoundException {
		
		CertificateFactory factory=CertificateFactory.getInstance("X.509");
		
		return factory.generateCertificate(new FileInputStream(certFilename));
	}
	
	public static void addCertificateToKeyStore(KeyStore ks, Certificate cert, String alias)
		      throws KeyStoreException {
		ks.setCertificateEntry(alias, cert);
			
	}
	
	public static void persistKeyStore(KeyStore ks, String pathname, String password) 
		throws KeyStoreException,
		        FileNotFoundException,
		        NoSuchAlgorithmException,
		        CertificateException,
		        IOException {
		FileOutputStream os=new FileOutputStream(pathname);
		ks.store(os, password.toCharArray());
		os.close();
		
		
	}
}
