/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IConnectionHandler.java,v 1.2 2005/05/05 19:52:33 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.execution.file;

import org.eclipse.hyades.internal.execution.core.file.ISocketChannel;

/**
 * New connection handler interface that operates on socket channels rather than
 * plain sockets (the socket channel is local abstraction and is not the
 * standard Java one)
 * 
 * @author Scott E. Schneider
 */
public interface IConnectionHandler {
    /**
     * Method that is invoked once a new connection is made with the client via
     * the client socket channel. It is assumed the implementation of this
     * method will spawn off a worker to handle the communication with the
     * client.
     * 
     * @param clientChannel
     *            the client channel created from the server socket channel
     */
    public void connectionAccepted(ISocketChannel clientChannel);
}