/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ActiveAgentListCommand.java,v 1.4 2005/02/16 22:20:15 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

import java.util.Vector;

/**
 * Insert the type's description here.
 * Creation date: (10/31/00 9:35:35 PM)
 * @author:
 */
public class ActiveAgentListCommand extends SimpleProcessCommand {

	protected Vector _agents=new Vector();
	protected RAString _processName=new RAString("");
/**
 * ActiveAgentListCommand constructor comment.
 */
public ActiveAgentListCommand() {
	super();
	_tag=RA_AGENT_LIST;
}
/**
 * Insert the method's description here.
 * Creation date: (10/31/00 9:40:59 PM)
 * @return java.lang.String[]
 */
public String[] getAgents() {
	int length=_agents.size();
	String[] results=new String[length];
	for(int i=0; i<length; i++) {
		results[i]=((RAString)_agents.elementAt(i)).getData();
	}
	return results;
}
public String getProcessName() {
	return _processName.getData();

}
/**
 * getSize method comment.
 */
public int getSize() {
	int size=super.getSize();
	size+=_processName.getSize();
	size+=sizeofLong;
	for(int i=0; i<_agents.size(); i++) {
		size+=((RAString)_agents.elementAt(i)).getSize();
	}
	return size;
}
/**
 * readFromBuffer method comment.
 */
public int readFromBuffer(byte[] buffer, int offset) {
	int current=super.readFromBuffer(buffer, offset);
	current=Message.readRAStringFromBuffer(buffer, current, _processName);
	long listLength=Message.readRALongFromBuffer(buffer, current);
	current+=sizeofLong;
	for(int i=0; i<listLength; i++) {
		RAString agent=new RAString("");
		current=Message.readRAStringFromBuffer(buffer, current, agent);
		_agents.addElement(agent);
	}
	return current;
}
/**
 * writeToBuffer method comment.
 */
public int writeToBuffer(byte[] buffer, int offset) {
	int current=super.writeToBuffer(buffer, offset);
	current=Message.writeRAStringToBuffer(buffer, current, _processName);
	current=Message.writeRALongToBuffer(buffer, current, _agents.size());
	for(int i=0; i<_agents.size(); i++) {
		current=Message.writeRAStringToBuffer(buffer, current, ((RAString)_agents.elementAt(i)));
	}
	return current;
}
}
