/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ControlMessage.java,v 1.11 2005/04/26 15:14:11 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;


/**
 * Insert the type's description here.
 * Creation date: (6/2/00 3:06:05 PM)
 * @author: Administrator
 */
public class ControlMessage extends Message {

	CommandElement[] _entries=null;
	
	/* The length field */
	long _length;

	/* The authentication key */
	protected RAString _key=new RAString("");
/**
 * ControlMessage constructor comment.
 */
public ControlMessage() {
	super();
	_type=RA_CONTROL_MESSAGE;
}
/**
 * Insert the method's description here.
 * Creation date: (6/2/00 4:35:08 PM)
 * @param command com.ibm.jvmpi.common.CommandEntryElement
 */
public void appendCommand(CommandElement command)  {
	if(_entries==null) {
		_entries=new CommandElement[1];
		_entries[0]=command;
		return;
	}
	synchronized(_entries) {
//		if(this.getSize()+command.getSize() >= MAX_MESSAGE_LENGTH)
//			throw new MessageOverflowException();
			
		CommandElement[] _oldElements=_entries;
		_entries=new CommandElement[_oldElements.length+1];
		for(int i=0; i<_oldElements.length; i++) {
			_entries[i]=_oldElements[i];
		}
		_entries[_oldElements.length]=command;
	}
}
/**
 * Insert the method's description here.
 * Creation date: (6/8/00 2:35:25 PM)
 * @return com.ibm.jvmpi.common.CommandEntryElement
 * @param offset int
 */
public CommandElement getCommand(int offset) {
	return _entries[offset];
}
/**
 * Insert the method's description here.
 * Creation date: (6/8/00 6:40:36 PM)
 * @return int
 */
public int getCommandCount() {
	return _entries.length;
}
/**
 * Insert the method's description here.
 * Creation date: (10/31/00 5:57:46 PM)
 */
public RAString getKey() {
	return _key;
}
/* 185463 begin */
/**
 * Returns length of message read from message itself.
 * Creation date: (09/27/00 5:57:46 PM)
 */
public long getLength() {
	return _length;
}
/* 185463 end */

/**
 * Insert the method's description here.
 * Creation date: (6/8/00 10:21:47 AM)
 * @return short
 */
public int getSize() {
	int size=super.getSize();

	/* The length field */
	size+=sizeofLong;
	/* Key size */
	size+=(int)_key.getSize();

	/* Area for the count */
	size+=sizeofLong;

	/* The commands */

	/*synchronized(_entries) {*/
		for(int i=0; i<_entries.length; i++)
			size+=_entries[i].getSize();
	/*}*/
	return  size;
}


/**
 * readFromBuffer method comment.
 */
public int readFromBuffer(byte[] buffer, int offset) {
	int current=super.readFromBuffer(buffer, offset);

	_length=Message.readRALongFromBuffer(buffer, current);
	current+=sizeofLong;
	/* authentication key */
	current=readRAStringFromBuffer(buffer, current, _key);

	/* How many commands are in this message */
	long count=Message.readRALongFromBuffer(buffer, current);
	current+=sizeofLong;
	
	_entries=new CommandElement[(int)count];

	/* Read in each command */
	for(int i=0; i<count; i++) {
		boolean success=true;
		long tag=Message.readRALongFromBuffer(buffer, current);
		current+=sizeofLong;
		CommandElement command=null;
		switch((int)tag) {
		case (int)RA_AUTHENTICATION_FAILED:
			command=new AuthenticationFailedCommand();
			current=((AuthenticationFailedCommand)command).readFromBuffer(buffer, current);
			break;
		case (int)RA_AUTHENTICATION_SUCCESSFUL:
			command=new AuthenticationSuccessfulCommand();
			current=((AuthenticationSuccessfulCommand)command).readFromBuffer(buffer, current);
			break;
		case (int)RA_SERVER_SECURITY_REQUIREMENTS:
			command=new ServerSecurityInfoCommand();
			current=((ServerSecurityInfoCommand)command).readFromBuffer(buffer, current);
			break;
		case (int)RA_PROCESS_LAUNCHED:
			{
			command=new ProcessLaunchedCommand();
			current=((ProcessLaunchedCommand)command).readFromBuffer(buffer, current);
			}
			break;
		case (int)RA_PROCESS_EXITED:
			{
			command=new ProcessExitedCommand();
			current=((ProcessExitedCommand)command).readFromBuffer(buffer, current);
			}
			break;
		case (int)RA_PROCESS_LIST:
			{
			command=new RegisteredProcessListCommand();
			current=((RegisteredProcessListCommand)command).readFromBuffer(buffer, current);
			}
			break;
		case (int)RA_AGENT_LIST:
			{
			command=new ActiveAgentListCommand();
			current=((ActiveAgentListCommand)command).readFromBuffer(buffer, current);
			}
			break;
		case (int)RA_AGENT_ATTACHED: // Bug 54376
			command=new AgentAttachedCommand();
			current=((AgentAttachedCommand)command).readFromBuffer(buffer, current);
			break;
		case (int)RA_AGENT_DETACHED: // Bug 54376
			command=new AgentDetachedCommand();
			current=((AgentDetachedCommand)command).readFromBuffer(buffer, current);
			break;
		case (int)RA_AGENT_ACTIVE:
			command=new AgentActiveCommand();
			current=((AgentActiveCommand)command).readFromBuffer(buffer, current);
			break;
		case (int)RA_AGENT_INACTIVE:
			command=new AgentInactiveCommand();
			current=((AgentInactiveCommand)command).readFromBuffer(buffer, current);
			break;
		case (int)RA_AGENT_DETAILS:
			command=new AgentDetailsCommand();
			current=((AgentDetailsCommand)command).readFromBuffer(buffer, current);
			break;
		case (int)RA_ERROR_STRING:
			command=new ErrorCommand();
			current=((ErrorCommand)command).readFromBuffer(buffer, current);
			break;
		case (int)RA_CUSTOM_COMMAND:
			command=new CustomCommand();
			current=((CustomCommand)command).readFromBuffer(buffer, current);
			break;
        case (int)RA_BINARY_CUSTOM_COMMAND:
            command=new BinaryCustomCommand();
            current=((BinaryCustomCommand)command).readFromBuffer(buffer, current);
            break;
		case (int)RA_CONTROLLER_REQUEST_MONITOR:
			command=new MonitorPeerRequestCommand();
			current=((MonitorPeerRequestCommand)command).readFromBuffer(buffer, current);
			break;
		/* Bug 77768 begins */
		case (int)RA_CONTROLLER_REQUEST_MONITOR_PORT:
			command=new MonitorPeerRequestPortCommand();
			current=((MonitorPeerRequestPortCommand)command).readFromBuffer(buffer, current);
			break;
		/* Bug 77768 ends */
		case (int)RA_MANAGE_FILE:
			command = new ManageFileCommand() ;
			current = ((ManageFileCommand)command).readFromBuffer(buffer,current) ;
			break;
		case (int)RA_RESOURCE_LOCATION:
			command = new ResourceLocation();
			current = ((ResourceLocation)command).readFromBuffer(buffer, current);
			break;
		case (int)RA_PROPERTY_LIST:
			command=new PropertyListCommand();
			current=((PropertyListCommand)command).readFromBuffer(buffer, current);
			break;
		}
		/* Store the command in the array */
		_entries[i]=command;
		
	}
	return current;
}
/**
 * Insert the method's description here.
 * Creation date: (10/31/00 5:59:07 PM)
 * @param key java.lang.String
 */
public void setKey(RAString key) {
	_key=key;
}
/**
 * writeToBuffer method comment.
 */
public int writeToBuffer(byte[] buffer, int offset) {
	int current=super.writeToBuffer(buffer, offset);

	/* Insert the length */
	_length=getSize();
	current=Message.writeRALongToBuffer(buffer, current, _length);
	/* Insert the authentication key */
	current=writeRAStringToBuffer(buffer, current, _key);

	/* place the command count in the buffer */
	current=Message.writeRALongToBuffer(buffer, current, _entries.length);
	
	for(int i=0; i<_entries.length; i++) {
		current=_entries[i].writeToBuffer(buffer, current);
		
	}
	return current;
}
}
