/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DetailedAgentInfoCommand.java,v 1.4 2005/02/16 22:20:15 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

/**
 * Insert the type's description here.
 * Creation date: (6/8/00 11:39:15 AM)
 * @author: Administrator
 */
public abstract class DetailedAgentInfoCommand extends DetailedProcessCommand implements Constants{

	protected RAString _agentName=new RAString("");
	protected RAString _agentUUID=new RAString("");
	protected RAString _agentType=new RAString("");
/**
 * ProcessInfoCommandEntry constructor comment.
 */
public DetailedAgentInfoCommand() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (9/11/00 9:12:04 PM)
 * @return java.lang.String
 */
public String getAgentName() {
	if(_agentName != null)
		return _agentName.getData();
	return null;
}
/**
 * Insert the method's description here.
 * Creation date: (11/29/00 12:09:31 PM)
 * @return java.lang.String
 */
public String getAgentUUID() {
	if(_agentUUID != null) {
		return _agentUUID.getData();
	}
	return null;
}

public String getAgentType() {
	if(_agentType != null) {
		return _agentType.getData();
	}
	return null;
}

/**
 * Insert the method's description here.
 * Creation date: (6/8/00 12:54:50 PM)
 * @return int
 */
public int getSize() {
	return super.getSize()+_agentName.getSize()+_agentUUID.getSize()+_agentType.getSize();
}
/**
 * Insert the method's description here.
 * Creation date: (9/11/00 9:25:14 PM)
 * @return int
 * @param buffer byte[]
 * @param length int[]
 */
public int readFromBuffer(byte[] buffer, int offset) {
	int current=super.readFromBuffer(buffer, offset);
	current=Message.readRAStringFromBuffer(buffer, current, _agentName);
	current=Message.readRAStringFromBuffer(buffer, current, _agentUUID);
	current=Message.readRAStringFromBuffer(buffer, current, _agentType);
	return current;
}
/**
 * Insert the method's description here.
 * Creation date: (9/11/00 9:11:41 PM)
 * @param name java.lang.String
 */
public void setAgentName(String name) {
	_agentName=new RAString(name);
}
/**
 * Insert the method's description here.
 * Creation date: (7/21/00 2:35:32 PM)
 * @return int
 * @param buffer byte[]
 * @param offset int
 */
public int writeToBuffer(byte[] buffer, int offset) {
	int current=super.writeToBuffer(buffer, offset);
	current=Message.writeRAStringToBuffer(buffer, current, _agentName);
	current=Message.writeRAStringToBuffer(buffer, current, _agentUUID);
	current=Message.writeRAStringToBuffer(buffer, current, _agentType);
	return current;
}
}
