/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DetailedProcessCommand.java,v 1.4 2005/02/16 22:20:15 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

/**
 * Insert the type's description here.
 * Creation date: (11/29/00 11:56:45 AM)
 * @author:
 */
public class DetailedProcessCommand extends SimpleProcessCommand {

	protected RAString _processUUID=new RAString("");
/**
 * DetailedProcessCommand constructor comment.
 */
public DetailedProcessCommand() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (11/29/00 11:57:19 AM)
 * @return java.lang.String
 */
public String getProcessUUID() {
	if(_processUUID != null) {
		return _processUUID.getData();
	}
	return null;
}
/**
 * getSize method comment.
 */
public int getSize() {
	return super.getSize()+_processUUID.getSize();
}
/**
 * readFromBuffer method comment.
 */
public int readFromBuffer(byte[] buffer, int offset) {
	int current=super.readFromBuffer(buffer, offset);
	current=Message.readRAStringFromBuffer(buffer, current, _processUUID);
	return current;
}
/**
 * writeToBuffer method comment.
 */
public int writeToBuffer(byte[] buffer, int offset) {
	int current=super.writeToBuffer(buffer, offset);
	current=Message.writeRAStringToBuffer(buffer, current, _processUUID);
	return current;
}
}
