/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MonitorPeerRequestCommand.java,v 1.4 2005/02/16 22:20:15 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
/**
 * Insert the type's description here.
 * Creation date: (9/12/00 2:35:40 PM)
 * @author:
 */
public class MonitorPeerRequestCommand extends SimpleAgentInfoCommand {

	protected RABinaryArray _peerNode=new RABinaryArray();
	protected RABinaryArray _targetNode =new RABinaryArray();
	protected RAString _peerName=new RAString("");
	protected long _peerProcessId;
	
	private InetAddress _peerAddress=null;
	private InetAddress _targetAddress=null;
/**
 * CustomCommand constructor comment.
 */
public MonitorPeerRequestCommand() {
	super();
	_tag=RA_CONTROLLER_REQUEST_MONITOR;
}

/**
 * getSize method comment.
 */
public int getSize() {
	return super.getSize()+_peerNode.getSize()+sizeofLong+_peerName.getSize();

}


public InetAddress getPeerNode() throws UnknownHostException {
	/* Check our cache */
	if(_peerAddress!=null) {
		return _targetAddress;
	}
	if(_peerNode.length()==0) {
		return null;
	}
	byte[] data=_peerNode.getData();
	
	/* Build a string representing the IP address in decimal form */
	String addr=new String();
	addr+=convertPointAddress(new Byte(data[0]).intValue());
	
	for(int i=1; i<_peerNode.length(); i++) {
		addr=addr+"."+convertPointAddress(new Byte(data[i]).intValue());
	}
	
	/* Lookup the InetAddress objects for this address */
	return InetAddress.getByName(addr);
}

public InetAddress getTargetNode()throws UnknownHostException {
	/* Check our cache */
	if(_targetAddress!=null) {
		return _targetAddress;
	}
	if(_targetNode.length()==0) {
		return null;
	}
	byte[] data=_targetNode.getData();
	
	/* Build a string representing the IP address in decimal form */
	String addr=new String();
	addr+=convertPointAddress(new Byte(data[0]).intValue());
	for(int i=1; i<_targetNode.length(); i++) {
		addr=addr+"."+convertPointAddress(new Byte(data[i]).intValue());
	}
	
	/* Lookup the InetAddress objects for this address */
	return InetAddress.getByName(addr);
	
}


public String getPeerAgentName() {
	if(_peerName!=null) {
		return _peerName.getData();
	}
	return null;	
}

public long getPeerProcessId() {
	return _peerProcessId;	
}




/**
 * readFromBuffer method comment.
 */
public int readFromBuffer(byte[] buffer, int offset) {
	int current=super.readFromBuffer(buffer, offset);
	current=Message.readRABinaryArrayFromBuffer(buffer, current, _targetNode);
	_peerProcessId=Message.readRALongFromBuffer(buffer, current);
	current+=sizeofLong;
	current=Message.readRAStringFromBuffer(buffer, current, _peerName);
	current=Message.readRABinaryArrayFromBuffer(buffer, current, _peerNode);
	return current;
}

/**
 * writeToBuffer method comment.
 */
public int writeToBuffer(byte[] buffer, int offset) {
	int current=super.writeToBuffer(buffer, offset);
	current=Message.writeRABinaryArrayToBuffer(buffer, current, _targetNode);
	current=Message.writeRALongToBuffer(buffer, current, _peerProcessId);
	current=Message.writeRAStringToBuffer(buffer, current, _peerName);
	current=Message.writeRABinaryArrayToBuffer(buffer, current, _peerNode);
	return current;
}


private int convertPointAddress(int pointAddress) {
	if(pointAddress<0) {
		pointAddress=256-Math.abs(pointAddress);
		
	}
	return pointAddress;
	
}



}
