/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AgentConfiguration.java,v 1.4 2005/02/16 22:20:16 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.control;

import java.util.Vector;


/**
 * Insert the type's description here.
 * Creation date: (11/9/00 8:15:06 AM)
 * @author:
 */
public class AgentConfiguration {
	public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001 - All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
	protected String _agentName=null;
	protected Vector _entries= new Vector();
/**
 * AgentConfiguration constructor comment.
 */
public AgentConfiguration() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (11/9/00 8:18:32 AM)
 * @param param com.ibm.etools.logging.tracing.client.AgentConfigurationEntry
 */
public void addEntry(AgentConfigurationEntry entry) {
	_entries.addElement(entry);
}
/**
 * Insert the method's description here.
 * Creation date: (10/15/2001 3:47:31 PM)
 */
public void clear() {
	_entries.clear();
}
/**
 * Insert the method's description here.
 * Creation date: (11/9/00 8:20:58 AM)
 * @return java.lang.String
 */
public String getAgentName() {
	return _agentName;
}
/**
 * Insert the method's description here.
 * Creation date: (11/9/00 12:32:57 PM)
 * @return com.ibm.etools.logging.tracing.client.AgentConfigurationEntry
 * @param offset int
 */
public AgentConfigurationEntry getEntryAt(int offset) {
	return (AgentConfigurationEntry)_entries.elementAt(offset);
}
/**
 * Insert the method's description here.
 * Creation date: (11/9/00 8:20:29 AM)
 * @param name java.lang.String
 */
public void setAgentName(String name) {
	_agentName=name;
}
/**
 * Insert the method's description here.
 * Creation date: (11/9/00 12:30:28 PM)
 * @return int
 */
public int size() {
	return _entries.size();
}

/**
 *  Removes an entry from this configuration.
 */
public boolean removeEntry(AgentConfigurationEntry entry) {
	return _entries.removeElement(entry);
}

}
