/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AgentListener.java,v 1.4 2005/02/16 22:20:16 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.control;

import org.eclipse.hyades.internal.execution.local.common.CommandElement;


public interface AgentListener {
	
	
	/**
	 * Invoked when an agent first becomes active
	 */
	void agentActive(Agent agent);
	
	/**
	 * Invoked when an agent becomes inactive.
	 */
	void agentInactive(Agent agent);
	
	/**
	 * Invoked when an error is recieved from the agent.
	 */
	void error(Agent agent, String errorId, String errorMessage);

	/**
	 * Invoked when there is no established handler for the context of a message.
	 */
	void handleCommand(Agent agent, CommandElement command);

}

