/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProcessListener.java,v 1.4 2005/02/16 22:20:17 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.control;

public interface ProcessListener {
	
	/**
	 * Invoked when a process is launched.  The
	 * process parameter contains all the information
	 * regarding the process.
	 */
	void processLaunched(Process process);
	
	
	/**
	 * Invoked when a process that was previously launched
	 * exits.The process parameter contains all the information
	 * regarding the process.
	 */
	void processExited(Process process);

}

